/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.documentation.html;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.nifi.annotation.behavior.DynamicProperties;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.documentation.DocumentationWriter;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlDocumentationWriter
implements DocumentationWriter {
    public static final Logger LOGGER = LoggerFactory.getLogger(HtmlDocumentationWriter.class);
    public static final String ADDITIONAL_DETAILS_HTML = "additionalDetails.html";
    private final ExtensionManager extensionManager;

    public HtmlDocumentationWriter(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    @Override
    public void write(ConfigurableComponent configurableComponent, OutputStream streamToWriteTo, boolean includesAdditionalDocumentation) throws IOException {
        try {
            XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(streamToWriteTo, "UTF-8");
            xmlStreamWriter.writeDTD("<!DOCTYPE html>");
            xmlStreamWriter.writeStartElement("html");
            xmlStreamWriter.writeAttribute("lang", "en");
            this.writeHead(configurableComponent, xmlStreamWriter);
            this.writeBody(configurableComponent, xmlStreamWriter, includesAdditionalDocumentation);
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.close();
        }
        catch (FactoryConfigurationError | XMLStreamException e) {
            throw new IOException("Unable to create XMLOutputStream", e);
        }
    }

    protected void writeHead(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("head");
        xmlStreamWriter.writeStartElement("meta");
        xmlStreamWriter.writeAttribute("charset", "utf-8");
        xmlStreamWriter.writeEndElement();
        HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "title", this.getTitle(configurableComponent));
        xmlStreamWriter.writeStartElement("link");
        xmlStreamWriter.writeAttribute("rel", "stylesheet");
        xmlStreamWriter.writeAttribute("href", "../../../../../css/component-usage.css");
        xmlStreamWriter.writeAttribute("type", "text/css");
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeStartElement("script");
        xmlStreamWriter.writeAttribute("type", "text/javascript");
        xmlStreamWriter.writeCharacters("window.onload = function(){if(self==top) { document.getElementById('nameHeader').style.display = \"inherit\"; } }");
        xmlStreamWriter.writeEndElement();
    }

    protected String getTitle(ConfigurableComponent configurableComponent) {
        return configurableComponent.getClass().getSimpleName();
    }

    private void writeBody(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter, boolean hasAdditionalDetails) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("body");
        this.writeHeader(configurableComponent, xmlStreamWriter);
        this.writeDeprecationWarning(configurableComponent, xmlStreamWriter);
        this.writeDescription(configurableComponent, xmlStreamWriter, hasAdditionalDetails);
        this.writeTags(configurableComponent, xmlStreamWriter);
        this.writeProperties(configurableComponent, xmlStreamWriter);
        this.writeDynamicProperties(configurableComponent, xmlStreamWriter);
        this.writeAdditionalBodyInfo(configurableComponent, xmlStreamWriter);
        this.writeStatefulInfo(configurableComponent, xmlStreamWriter);
        this.writeRestrictedInfo(configurableComponent, xmlStreamWriter);
        this.writeInputRequirementInfo(configurableComponent, xmlStreamWriter);
        this.writeSystemResourceConsiderationInfo(configurableComponent, xmlStreamWriter);
        this.writeSeeAlso(configurableComponent, xmlStreamWriter);
        xmlStreamWriter.writeEndElement();
    }

    private void writeHeader(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("h1");
        xmlStreamWriter.writeAttribute("id", "nameHeader");
        xmlStreamWriter.writeAttribute("style", "display: none;");
        xmlStreamWriter.writeCharacters(this.getTitle(configurableComponent));
        xmlStreamWriter.writeEndElement();
    }

    private void writeInputRequirementInfo(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        InputRequirement inputRequirement = configurableComponent.getClass().getAnnotation(InputRequirement.class);
        if (inputRequirement != null) {
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h3", "Input requirement: ");
            switch (inputRequirement.value()) {
                case INPUT_FORBIDDEN: {
                    xmlStreamWriter.writeCharacters("This component does not allow an incoming relationship.");
                    break;
                }
                case INPUT_ALLOWED: {
                    xmlStreamWriter.writeCharacters("This component allows an incoming relationship.");
                    break;
                }
                case INPUT_REQUIRED: {
                    xmlStreamWriter.writeCharacters("This component requires an incoming relationship.");
                    break;
                }
                default: {
                    xmlStreamWriter.writeCharacters("This component does not have input requirement.");
                }
            }
        }
    }

    private void writeStatefulInfo(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        Stateful stateful = configurableComponent.getClass().getAnnotation(Stateful.class);
        HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h3", "State management: ");
        if (stateful != null) {
            xmlStreamWriter.writeStartElement("table");
            xmlStreamWriter.writeAttribute("id", "stateful");
            xmlStreamWriter.writeStartElement("tr");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Scope");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Description");
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement("tr");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", HtmlDocumentationWriter.join(stateful.scopes(), ", "));
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", stateful.description());
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
        } else {
            xmlStreamWriter.writeCharacters("This component does not store state.");
        }
    }

    private void writeRestrictedInfo(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        Restricted restricted = configurableComponent.getClass().getAnnotation(Restricted.class);
        HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h3", "Restricted: ");
        if (restricted != null) {
            Restriction[] restrictions;
            String value = restricted.value();
            if (!StringUtils.isBlank((String)value)) {
                xmlStreamWriter.writeCharacters(restricted.value());
            }
            if ((restrictions = restricted.restrictions()) != null && restrictions.length > 0) {
                xmlStreamWriter.writeStartElement("table");
                xmlStreamWriter.writeAttribute("id", "restrictions");
                xmlStreamWriter.writeStartElement("tr");
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Required Permission");
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Explanation");
                xmlStreamWriter.writeEndElement();
                for (Restriction restriction : restrictions) {
                    xmlStreamWriter.writeStartElement("tr");
                    HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", restriction.requiredPermission().getPermissionLabel());
                    HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", restriction.explanation());
                    xmlStreamWriter.writeEndElement();
                }
                xmlStreamWriter.writeEndElement();
            } else {
                xmlStreamWriter.writeCharacters("This component requires access to restricted components regardless of restriction.");
            }
        } else {
            xmlStreamWriter.writeCharacters("This component is not restricted.");
        }
    }

    private void writeDeprecationWarning(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        DeprecationNotice deprecationNotice = configurableComponent.getClass().getAnnotation(DeprecationNotice.class);
        if (deprecationNotice != null) {
            xmlStreamWriter.writeStartElement("h2");
            xmlStreamWriter.writeCharacters("Deprecation notice: ");
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement("p");
            xmlStreamWriter.writeCharacters("");
            if (!StringUtils.isEmpty((String)deprecationNotice.reason())) {
                xmlStreamWriter.writeCharacters(deprecationNotice.reason());
            } else {
                xmlStreamWriter.writeCharacters("Please be aware this processor is deprecated and may be removed in the near future.");
            }
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement("p");
            xmlStreamWriter.writeCharacters("Please consider using one the following alternatives: ");
            Class[] componentNames = deprecationNotice.alternatives();
            String[] classNames = deprecationNotice.classNames();
            if (componentNames.length > 0 || classNames.length > 0) {
                this.iterateAndLinkComponents(xmlStreamWriter, componentNames, classNames, ",", configurableComponent.getClass().getSimpleName());
            } else {
                xmlStreamWriter.writeCharacters("No alternative components suggested.");
            }
            xmlStreamWriter.writeEndElement();
        }
    }

    private void writeSeeAlso(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        SeeAlso seeAlso = configurableComponent.getClass().getAnnotation(SeeAlso.class);
        if (seeAlso != null) {
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h3", "See Also:");
            xmlStreamWriter.writeStartElement("p");
            Class[] componentNames = seeAlso.value();
            String[] classNames = seeAlso.classNames();
            if (componentNames.length > 0 || classNames.length > 0) {
                this.iterateAndLinkComponents(xmlStreamWriter, componentNames, classNames, ", ", configurableComponent.getClass().getSimpleName());
            } else {
                xmlStreamWriter.writeCharacters("No tags provided.");
            }
            xmlStreamWriter.writeEndElement();
        }
    }

    protected void writeAdditionalBodyInfo(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
    }

    private void writeTags(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        Tags tags = configurableComponent.getClass().getAnnotation(Tags.class);
        xmlStreamWriter.writeStartElement("h3");
        xmlStreamWriter.writeCharacters("Tags: ");
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeStartElement("p");
        if (tags != null) {
            String tagString = HtmlDocumentationWriter.join(tags.value(), ", ");
            xmlStreamWriter.writeCharacters(tagString);
        } else {
            xmlStreamWriter.writeCharacters("No tags provided.");
        }
        xmlStreamWriter.writeEndElement();
    }

    static String join(Object[] objects, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            sb.append(objects[i].toString());
            if (i >= objects.length - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    protected void writeDescription(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter, boolean hasAdditionalDetails) throws XMLStreamException {
        HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h2", "Description: ");
        HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "p", this.getDescription(configurableComponent));
        if (hasAdditionalDetails) {
            xmlStreamWriter.writeStartElement("p");
            this.writeLink(xmlStreamWriter, "Additional Details...", ADDITIONAL_DETAILS_HTML);
            xmlStreamWriter.writeEndElement();
        }
    }

    protected String getDescription(ConfigurableComponent configurableComponent) {
        CapabilityDescription capabilityDescription = configurableComponent.getClass().getAnnotation(CapabilityDescription.class);
        String description = capabilityDescription != null ? capabilityDescription.value() : "No description provided.";
        return description;
    }

    protected void writeProperties(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        List properties = configurableComponent.getPropertyDescriptors();
        HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h3", "Properties: ");
        if (properties.size() > 0) {
            boolean containsExpressionLanguage = this.containsExpressionLanguage(configurableComponent);
            boolean containsSensitiveProperties = this.containsSensitiveProperties(configurableComponent);
            xmlStreamWriter.writeStartElement("p");
            xmlStreamWriter.writeCharacters("In the list below, the names of required properties appear in ");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "strong", "bold");
            xmlStreamWriter.writeCharacters(". Any other properties (not in bold) are considered optional. The table also indicates any default values");
            if (containsExpressionLanguage) {
                if (!containsSensitiveProperties) {
                    xmlStreamWriter.writeCharacters(", and ");
                } else {
                    xmlStreamWriter.writeCharacters(", ");
                }
                xmlStreamWriter.writeCharacters("whether a property supports the ");
                this.writeLink(xmlStreamWriter, "NiFi Expression Language", "../../../../../html/expression-language-guide.html");
            }
            if (containsSensitiveProperties) {
                xmlStreamWriter.writeCharacters(", and whether a property is considered \"sensitive\", meaning that its value will be encrypted. Before entering a value in a sensitive property, ensure that the ");
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "strong", "nifi.properties");
                xmlStreamWriter.writeCharacters(" file has an entry for the property ");
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "strong", "nifi.sensitive.props.key");
            }
            xmlStreamWriter.writeCharacters(".");
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement("table");
            xmlStreamWriter.writeAttribute("id", "properties");
            xmlStreamWriter.writeStartElement("tr");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Name");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Default Value");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Allowable Values");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Description");
            xmlStreamWriter.writeEndElement();
            for (PropertyDescriptor property : properties) {
                xmlStreamWriter.writeStartElement("tr");
                xmlStreamWriter.writeStartElement("td");
                xmlStreamWriter.writeAttribute("id", "name");
                if (property.isRequired()) {
                    HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "strong", property.getDisplayName());
                } else {
                    xmlStreamWriter.writeCharacters(property.getDisplayName());
                }
                xmlStreamWriter.writeEndElement();
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", property.getDefaultValue(), false, "default-value");
                xmlStreamWriter.writeStartElement("td");
                xmlStreamWriter.writeAttribute("id", "allowable-values");
                this.writeValidValues(xmlStreamWriter, property);
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeStartElement("td");
                xmlStreamWriter.writeAttribute("id", "description");
                if (property.getDescription() != null && property.getDescription().trim().length() > 0) {
                    xmlStreamWriter.writeCharacters(property.getDescription());
                } else {
                    xmlStreamWriter.writeCharacters("No Description Provided.");
                }
                if (property.isSensitive()) {
                    xmlStreamWriter.writeEmptyElement("br");
                    HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "strong", "Sensitive Property: true");
                }
                if (property.isExpressionLanguageSupported()) {
                    xmlStreamWriter.writeEmptyElement("br");
                    String text = "Supports Expression Language: true";
                    String perFF = " (will be evaluated using flow file attributes and variable registry)";
                    String registry = " (will be evaluated using variable registry only)";
                    InputRequirement inputRequirement = configurableComponent.getClass().getAnnotation(InputRequirement.class);
                    switch (property.getExpressionLanguageScope()) {
                        case FLOWFILE_ATTRIBUTES: {
                            if (inputRequirement != null && inputRequirement.value().equals((Object)InputRequirement.Requirement.INPUT_FORBIDDEN)) {
                                text = text + " (will be evaluated using variable registry only)";
                                break;
                            }
                            text = text + " (will be evaluated using flow file attributes and variable registry)";
                            break;
                        }
                        case VARIABLE_REGISTRY: {
                            text = text + " (will be evaluated using variable registry only)";
                            break;
                        }
                        default: {
                            text = text + " (undefined scope)";
                        }
                    }
                    HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "strong", text);
                }
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
        } else {
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "p", "This component has no required or optional properties.");
        }
    }

    private boolean containsSensitiveProperties(ConfigurableComponent component) {
        for (PropertyDescriptor descriptor : component.getPropertyDescriptors()) {
            if (!descriptor.isSensitive()) continue;
            return true;
        }
        return false;
    }

    private boolean containsExpressionLanguage(ConfigurableComponent component) {
        for (PropertyDescriptor descriptor : component.getPropertyDescriptors()) {
            if (!descriptor.isExpressionLanguageSupported()) continue;
            return true;
        }
        return false;
    }

    private void writeDynamicProperties(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        List<DynamicProperty> dynamicProperties = this.getDynamicProperties(configurableComponent);
        if (dynamicProperties != null && dynamicProperties.size() > 0) {
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h3", "Dynamic Properties: ");
            xmlStreamWriter.writeStartElement("p");
            xmlStreamWriter.writeCharacters("Dynamic Properties allow the user to specify both the name and value of a property.");
            xmlStreamWriter.writeStartElement("table");
            xmlStreamWriter.writeAttribute("id", "dynamic-properties");
            xmlStreamWriter.writeStartElement("tr");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Name");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Value");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Description");
            xmlStreamWriter.writeEndElement();
            for (DynamicProperty dynamicProperty : dynamicProperties) {
                String text;
                xmlStreamWriter.writeStartElement("tr");
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", dynamicProperty.name(), false, "name");
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", dynamicProperty.value(), false, "value");
                xmlStreamWriter.writeStartElement("td");
                xmlStreamWriter.writeCharacters(dynamicProperty.description());
                xmlStreamWriter.writeEmptyElement("br");
                if (dynamicProperty.expressionLanguageScope().equals((Object)ExpressionLanguageScope.NONE)) {
                    text = dynamicProperty.supportsExpressionLanguage() ? "Supports Expression Language: true (undefined scope)" : "Supports Expression Language: false";
                } else {
                    switch (dynamicProperty.expressionLanguageScope()) {
                        case FLOWFILE_ATTRIBUTES: {
                            text = "Supports Expression Language: true (will be evaluated using flow file attributes and variable registry)";
                            break;
                        }
                        case VARIABLE_REGISTRY: {
                            text = "Supports Expression Language: true (will be evaluated using variable registry only)";
                            break;
                        }
                        default: {
                            text = "Supports Expression Language: false";
                        }
                    }
                }
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "strong", text);
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
        }
    }

    private List<DynamicProperty> getDynamicProperties(ConfigurableComponent configurableComponent) {
        DynamicProperty dynProp;
        ArrayList<DynamicProperty> dynamicProperties = new ArrayList<DynamicProperty>();
        DynamicProperties dynProps = configurableComponent.getClass().getAnnotation(DynamicProperties.class);
        if (dynProps != null) {
            for (DynamicProperty dynProp2 : dynProps.value()) {
                dynamicProperties.add(dynProp2);
            }
        }
        if ((dynProp = configurableComponent.getClass().getAnnotation(DynamicProperty.class)) != null) {
            dynamicProperties.add(dynProp);
        }
        return dynamicProperties;
    }

    private void writeValidValueDescription(XMLStreamWriter xmlStreamWriter, String description) throws XMLStreamException {
        xmlStreamWriter.writeCharacters(" ");
        xmlStreamWriter.writeStartElement("img");
        xmlStreamWriter.writeAttribute("src", "../../../../../html/images/iconInfo.png");
        xmlStreamWriter.writeAttribute("alt", description);
        xmlStreamWriter.writeAttribute("title", description);
        xmlStreamWriter.writeEndElement();
    }

    protected void writeValidValues(XMLStreamWriter xmlStreamWriter, PropertyDescriptor property) throws XMLStreamException {
        if (property.getAllowableValues() != null && property.getAllowableValues().size() > 0) {
            xmlStreamWriter.writeStartElement("ul");
            for (AllowableValue value : property.getAllowableValues()) {
                xmlStreamWriter.writeStartElement("li");
                xmlStreamWriter.writeCharacters(value.getDisplayName());
                if (value.getDescription() != null) {
                    this.writeValidValueDescription(xmlStreamWriter, value.getDescription());
                }
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
        } else if (property.getControllerServiceDefinition() != null) {
            Class controllerServiceClass = property.getControllerServiceDefinition();
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "strong", "Controller Service API: ");
            xmlStreamWriter.writeEmptyElement("br");
            xmlStreamWriter.writeCharacters(controllerServiceClass.getSimpleName());
            List<Class<? extends ControllerService>> implementationList = this.lookupControllerServiceImpls(controllerServiceClass);
            Class[] implementations = (Class[])implementationList.stream().toArray(Class[]::new);
            xmlStreamWriter.writeEmptyElement("br");
            if (implementations.length > 0) {
                String title = implementations.length > 1 ? "Implementations: " : "Implementation: ";
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "strong", title);
                this.iterateAndLinkComponents(xmlStreamWriter, implementations, null, "<br>", controllerServiceClass.getSimpleName());
            } else {
                xmlStreamWriter.writeCharacters("No implementations found.");
            }
        }
    }

    protected static final void writeSimpleElement(XMLStreamWriter writer, String elementName, String characters, boolean strong) throws XMLStreamException {
        HtmlDocumentationWriter.writeSimpleElement(writer, elementName, characters, strong, null);
    }

    protected static final void writeSimpleElement(XMLStreamWriter writer, String elementName, String characters, boolean strong, String id) throws XMLStreamException {
        writer.writeStartElement(elementName);
        if (id != null) {
            writer.writeAttribute("id", id);
        }
        if (strong) {
            writer.writeStartElement("strong");
        }
        writer.writeCharacters(characters);
        if (strong) {
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    protected static final void writeSimpleElement(XMLStreamWriter writer, String elementName, String characters) throws XMLStreamException {
        HtmlDocumentationWriter.writeSimpleElement(writer, elementName, characters, false);
    }

    protected void writeLink(XMLStreamWriter xmlStreamWriter, String text, String location) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("a");
        xmlStreamWriter.writeAttribute("href", location);
        xmlStreamWriter.writeCharacters(text);
        xmlStreamWriter.writeEndElement();
    }

    private void writeSystemResourceConsiderationInfo(ConfigurableComponent configurableComponent, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        SystemResourceConsideration[] systemResourceConsiderations = (SystemResourceConsideration[])configurableComponent.getClass().getAnnotationsByType(SystemResourceConsideration.class);
        HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "h3", "System Resource Considerations:");
        if (systemResourceConsiderations.length > 0) {
            xmlStreamWriter.writeStartElement("table");
            xmlStreamWriter.writeAttribute("id", "system-resource-considerations");
            xmlStreamWriter.writeStartElement("tr");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Resource");
            HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "th", "Description");
            xmlStreamWriter.writeEndElement();
            for (SystemResourceConsideration systemResourceConsideration : systemResourceConsiderations) {
                xmlStreamWriter.writeStartElement("tr");
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", systemResourceConsideration.resource().name());
                HtmlDocumentationWriter.writeSimpleElement(xmlStreamWriter, "td", systemResourceConsideration.description().trim().isEmpty() ? "Not Specified" : systemResourceConsideration.description());
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
        } else {
            xmlStreamWriter.writeCharacters("None specified.");
        }
    }

    private List<Class<? extends ControllerService>> lookupControllerServiceImpls(Class<? extends ControllerService> parent) {
        ArrayList<Class<? extends ControllerService>> implementations = new ArrayList<Class<? extends ControllerService>>();
        Set controllerServices = this.extensionManager.getExtensions(ControllerService.class);
        for (Class controllerServiceClass : controllerServices) {
            if (!parent.isAssignableFrom(controllerServiceClass)) continue;
            implementations.add(controllerServiceClass);
        }
        return implementations;
    }

    protected void iterateAndLinkComponents(XMLStreamWriter xmlStreamWriter, Class<? extends ConfigurableComponent>[] linkedComponents, String[] classNames, String separator, String sourceContextName) throws XMLStreamException {
        String effectiveSeparator = separator;
        boolean separatorIsElement = effectiveSeparator.startsWith("<") && effectiveSeparator.endsWith(">");
        effectiveSeparator = effectiveSeparator.replaceAll("\\<([^>]*)>", "$1");
        int index = 0;
        for (Class<? extends ConfigurableComponent> linkedComponent : linkedComponents) {
            String linkedComponentName = linkedComponent.getName();
            List linkedComponentBundles = this.extensionManager.getBundles(linkedComponentName);
            if (linkedComponentBundles != null && linkedComponentBundles.size() > 0) {
                Bundle firstLinkedComponentBundle = (Bundle)linkedComponentBundles.get(0);
                BundleCoordinate coordinate = firstLinkedComponentBundle.getBundleDetails().getCoordinate();
                String group = coordinate.getGroup();
                String id = coordinate.getId();
                String version = coordinate.getVersion();
                if (index != 0) {
                    if (separatorIsElement) {
                        xmlStreamWriter.writeEmptyElement(effectiveSeparator);
                    } else {
                        xmlStreamWriter.writeCharacters(effectiveSeparator);
                    }
                }
                this.writeLink(xmlStreamWriter, linkedComponent.getSimpleName(), "../../../../../components/" + group + "/" + id + "/" + version + "/" + linkedComponent.getCanonicalName() + "/index.html");
                ++index;
                continue;
            }
            LOGGER.warn("Could not link to {} because no bundles were found for {}", new Object[]{linkedComponentName, sourceContextName});
        }
        if (classNames != null) {
            for (String className : classNames) {
                List linkedComponentBundles;
                if (index != 0) {
                    if (separatorIsElement) {
                        xmlStreamWriter.writeEmptyElement(effectiveSeparator);
                    } else {
                        xmlStreamWriter.writeCharacters(effectiveSeparator);
                    }
                }
                if ((linkedComponentBundles = this.extensionManager.getBundles(className)) != null && linkedComponentBundles.size() > 0) {
                    Bundle firstBundle = (Bundle)linkedComponentBundles.get(0);
                    BundleCoordinate firstCoordinate = firstBundle.getBundleDetails().getCoordinate();
                    String group = firstCoordinate.getGroup();
                    String id = firstCoordinate.getId();
                    String version = firstCoordinate.getVersion();
                    String link = "../../../../../components/" + group + "/" + id + "/" + version + "/" + (String)className + "/index.html";
                    int indexOfLastPeriod = className.lastIndexOf(".") + 1;
                    this.writeLink(xmlStreamWriter, className.substring(indexOfLastPeriod), link);
                    ++index;
                    continue;
                }
                LOGGER.warn("Could not link to {} because no bundles were found for {}", new Object[]{className, sourceContextName});
            }
        }
    }
}

