/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.documentation;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Set;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.documentation.DocumentationWriter;
import org.apache.nifi.documentation.html.HtmlDocumentationWriter;
import org.apache.nifi.documentation.html.HtmlProcessorDocumentationWriter;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.ExtensionMapping;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocGenerator {
    private static final Logger logger = LoggerFactory.getLogger(DocGenerator.class);

    public static void generate(NiFiProperties properties, ExtensionManager extensionManager, ExtensionMapping extensionMapping) {
        File explodedNiFiDocsDir = properties.getComponentDocumentationWorkingDirectory();
        logger.debug("Generating documentation for: " + extensionMapping.size() + " components in: " + explodedNiFiDocsDir);
        DocGenerator.documentConfigurableComponent(extensionManager.getExtensions(Processor.class), explodedNiFiDocsDir, extensionManager);
        DocGenerator.documentConfigurableComponent(extensionManager.getExtensions(ControllerService.class), explodedNiFiDocsDir, extensionManager);
        DocGenerator.documentConfigurableComponent(extensionManager.getExtensions(ReportingTask.class), explodedNiFiDocsDir, extensionManager);
    }

    public static void documentConfigurableComponent(Set<Class> extensionClasses, File explodedNiFiDocsDir, ExtensionManager extensionManager) {
        for (Class extensionClass : extensionClasses) {
            if (!ConfigurableComponent.class.isAssignableFrom(extensionClass)) continue;
            String extensionClassName = extensionClass.getCanonicalName();
            Bundle bundle = extensionManager.getBundle(extensionClass.getClassLoader());
            if (bundle == null) {
                logger.warn("No coordinate found for {}, skipping...", new Object[]{extensionClassName});
                continue;
            }
            BundleCoordinate coordinate = bundle.getBundleDetails().getCoordinate();
            String path = coordinate.getGroup() + "/" + coordinate.getId() + "/" + coordinate.getVersion() + "/" + extensionClassName;
            File componentDirectory = new File(explodedNiFiDocsDir, path);
            componentDirectory.mkdirs();
            Class<ConfigurableComponent> componentClass = extensionClass.asSubclass(ConfigurableComponent.class);
            try {
                logger.debug("Documenting: " + componentClass);
                DocGenerator.document(extensionManager, componentDirectory, componentClass, coordinate);
            }
            catch (Exception e) {
                logger.warn("Unable to document: " + componentClass, (Throwable)e);
            }
        }
    }

    private static void document(ExtensionManager extensionManager, File componentDocsDir, Class<? extends ConfigurableComponent> componentClass, BundleCoordinate bundleCoordinate) throws InstantiationException, IllegalAccessException, IOException, InitializationException {
        String classType = componentClass.getCanonicalName();
        ConfigurableComponent component = extensionManager.getTempComponent(classType, bundleCoordinate);
        DocumentationWriter writer = DocGenerator.getDocumentWriter(extensionManager, componentClass);
        File baseDocumentationFile = new File(componentDocsDir, "index.html");
        if (baseDocumentationFile.exists()) {
            logger.warn(baseDocumentationFile + " already exists, overwriting!");
        }
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(baseDocumentationFile));){
            writer.write(component, output, DocGenerator.hasAdditionalInfo(componentDocsDir));
        }
    }

    private static DocumentationWriter getDocumentWriter(ExtensionManager extensionManager, Class<? extends ConfigurableComponent> componentClass) {
        if (Processor.class.isAssignableFrom(componentClass)) {
            return new HtmlProcessorDocumentationWriter(extensionManager);
        }
        if (ControllerService.class.isAssignableFrom(componentClass)) {
            return new HtmlDocumentationWriter(extensionManager);
        }
        if (ReportingTask.class.isAssignableFrom(componentClass)) {
            return new HtmlDocumentationWriter(extensionManager);
        }
        return null;
    }

    private static boolean hasAdditionalInfo(File directory) {
        return directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equalsIgnoreCase("additionalDetails.html");
            }
        }).length > 0;
    }
}

