/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server.codec;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.nifi.distributed.cache.operations.CacheOperation;
import org.apache.nifi.distributed.cache.operations.SetOperation;
import org.apache.nifi.distributed.cache.server.protocol.CacheOperationResult;
import org.apache.nifi.distributed.cache.server.protocol.CacheRequest;
import org.apache.nifi.distributed.cache.server.set.SetCache;
import org.apache.nifi.distributed.cache.server.set.SetCacheResult;
import org.apache.nifi.logging.ComponentLog;

@ChannelHandler.Sharable
public class SetCacheRequestHandler
extends SimpleChannelInboundHandler<CacheRequest> {
    private final ComponentLog log;
    private final SetCache setCache;

    public SetCacheRequestHandler(ComponentLog log, SetCache setCache) {
        this.log = Objects.requireNonNull(log, "Component Log required");
        this.setCache = Objects.requireNonNull(setCache, "Set Cache required");
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, CacheRequest cacheRequest) throws Exception {
        CacheOperation cacheOperation = cacheRequest.getCacheOperation();
        ByteBuffer body = ByteBuffer.wrap(cacheRequest.getBody());
        CacheOperationResult result = SetOperation.ADD_IF_ABSENT == cacheOperation ? this.getCacheOperationResult(this.setCache.addIfAbsent(body)) : (SetOperation.CONTAINS == cacheOperation ? this.getCacheOperationResult(this.setCache.contains(body)) : (SetOperation.REMOVE == cacheOperation ? this.getCacheOperationResult(this.setCache.remove(body)) : null));
        if (SetOperation.CLOSE == cacheOperation) {
            this.log.debug("Set Cache Operation [{}] received", new Object[]{cacheOperation});
            channelHandlerContext.close();
        } else if (result == null) {
            this.log.warn("Set Cache Operation [{}] not supported", new Object[]{cacheOperation});
        } else {
            this.log.debug("Set Cache Operation [{}] Success [{}]", new Object[]{cacheOperation, result.isSuccess()});
            channelHandlerContext.writeAndFlush((Object)result);
        }
    }

    private CacheOperationResult getCacheOperationResult(SetCacheResult setCacheResult) {
        return new CacheOperationResult(setCacheResult.getResult());
    }
}

