/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server.set;

import io.netty.channel.ChannelHandler;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.nifi.distributed.cache.operations.CacheOperation;
import org.apache.nifi.distributed.cache.operations.SetOperation;
import org.apache.nifi.distributed.cache.protocol.ProtocolVersion;
import org.apache.nifi.distributed.cache.server.EventCacheServer;
import org.apache.nifi.distributed.cache.server.EvictionPolicy;
import org.apache.nifi.distributed.cache.server.codec.CacheOperationResultEncoder;
import org.apache.nifi.distributed.cache.server.codec.CacheRequestDecoder;
import org.apache.nifi.distributed.cache.server.codec.CacheVersionRequestHandler;
import org.apache.nifi.distributed.cache.server.codec.CacheVersionResponseEncoder;
import org.apache.nifi.distributed.cache.server.codec.SetCacheRequestHandler;
import org.apache.nifi.distributed.cache.server.set.PersistentSetCache;
import org.apache.nifi.distributed.cache.server.set.SetCache;
import org.apache.nifi.distributed.cache.server.set.SimpleSetCache;
import org.apache.nifi.event.transport.EventServer;
import org.apache.nifi.event.transport.EventServerFactory;
import org.apache.nifi.event.transport.netty.NettyEventServerFactory;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.remote.StandardVersionNegotiator;
import org.apache.nifi.remote.VersionNegotiator;

public class StandardSetCacheServer
extends EventCacheServer {
    private final EventServerFactory eventServerFactory;
    private final SetCache cache;

    public StandardSetCacheServer(ComponentLog log, String identifier, SSLContext sslContext, int port, int maxCacheEntries, EvictionPolicy evictionPolicy, File persistencePath, int maxReadLength) throws IOException {
        super(log, port);
        SimpleSetCache simpleCache = new SimpleSetCache(identifier, maxCacheEntries, evictionPolicy);
        if (persistencePath == null) {
            this.cache = simpleCache;
        } else {
            PersistentSetCache persistentCache = new PersistentSetCache(identifier, persistencePath, simpleCache);
            persistentCache.restore();
            this.cache = persistentCache;
        }
        NettyEventServerFactory nettyEventServerFactory = this.createEventServerFactory(identifier, sslContext);
        SetCacheRequestHandler setCacheRequestHandler = new SetCacheRequestHandler(log, this.cache);
        CacheVersionResponseEncoder cacheVersionResponseEncoder = new CacheVersionResponseEncoder();
        CacheOperationResultEncoder cacheOperationResultEncoder = new CacheOperationResultEncoder();
        StandardVersionNegotiator versionNegotiator = new StandardVersionNegotiator(new int[]{ProtocolVersion.V1.value()});
        nettyEventServerFactory.setHandlerSupplier(() -> StandardSetCacheServer.lambda$new$0(cacheVersionResponseEncoder, cacheOperationResultEncoder, log, maxReadLength, setCacheRequestHandler, (VersionNegotiator)versionNegotiator));
        this.eventServerFactory = nettyEventServerFactory;
    }

    @Override
    public void stop() {
        try {
            this.cache.shutdown();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cache Shutdown Failed", e);
        }
        finally {
            super.stop();
        }
    }

    @Override
    protected EventServer createEventServer() {
        return this.eventServerFactory.getEventServer();
    }

    private static /* synthetic */ List lambda$new$0(CacheVersionResponseEncoder cacheVersionResponseEncoder, CacheOperationResultEncoder cacheOperationResultEncoder, ComponentLog log, int maxReadLength, SetCacheRequestHandler setCacheRequestHandler, VersionNegotiator versionNegotiator) {
        return Arrays.asList(new ChannelHandler[]{cacheVersionResponseEncoder, cacheOperationResultEncoder, new CacheRequestDecoder(log, maxReadLength, (CacheOperation[])SetOperation.values()), setCacheRequestHandler, new CacheVersionRequestHandler(log, versionNegotiator)});
    }
}

