/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.distributed.cache.server.CacheServer;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.ssl.SSLContextProvider;

public abstract class AbstractCacheServer
extends AbstractControllerService {
    public static final String EVICTION_STRATEGY_LFU = "Least Frequently Used";
    public static final String EVICTION_STRATEGY_LRU = "Least Recently Used";
    public static final String EVICTION_STRATEGY_FIFO = "First In, First Out";
    public static final PropertyDescriptor PORT = new PropertyDescriptor.Builder().name("Port").description("The port to listen on for incoming connections").required(true).addValidator(StandardValidators.PORT_VALIDATOR).defaultValue("4557").build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("If specified, this service will be used to create an SSL Context that will be used to secure communications; if not specified, communications will not be secure").required(false).identifiesControllerService(SSLContextProvider.class).build();
    public static final PropertyDescriptor MAX_CACHE_ENTRIES = new PropertyDescriptor.Builder().name("Maximum Cache Entries").description("The maximum number of cache entries that the cache can hold").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("10000").build();
    public static final PropertyDescriptor EVICTION_POLICY = new PropertyDescriptor.Builder().name("Eviction Strategy").description("Determines which strategy should be used to evict values from the cache to make room for new entries").required(true).allowableValues(new String[]{"Least Frequently Used", "Least Recently Used", "First In, First Out"}).defaultValue("Least Frequently Used").build();
    public static final PropertyDescriptor PERSISTENCE_PATH = new PropertyDescriptor.Builder().name("Persistence Directory").description("If specified, the cache will be persisted in the given directory; if not specified, the cache will be in-memory only").required(false).addValidator(StandardValidators.createDirectoryExistsValidator((boolean)true, (boolean)true)).build();
    public static final PropertyDescriptor MAX_READ_SIZE = new PropertyDescriptor.Builder().name("maximum-read-size").displayName("Maximum Read Size").description("The maximum number of network bytes to read for a single cache item").required(false).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).defaultValue("1 MB").build();
    private volatile CacheServer cacheServer;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(PORT);
        properties.add(MAX_CACHE_ENTRIES);
        properties.add(EVICTION_POLICY);
        properties.add(PERSISTENCE_PATH);
        properties.add(SSL_CONTEXT_SERVICE);
        properties.add(MAX_READ_SIZE);
        return properties;
    }

    @OnEnabled
    public void startServer(ConfigurationContext context) throws IOException {
        if (this.cacheServer == null) {
            this.cacheServer = this.createCacheServer(context);
            this.cacheServer.start();
        }
    }

    @OnShutdown
    @OnDisabled
    public void shutdownServer() throws IOException {
        if (this.cacheServer != null) {
            this.cacheServer.stop();
        }
        this.cacheServer = null;
    }

    protected void finalize() throws Throwable {
        this.shutdownServer();
    }

    public int getPort() {
        return this.cacheServer == null ? -1 : this.cacheServer.getPort();
    }

    protected abstract CacheServer createCacheServer(ConfigurationContext var1);
}

