/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.protocol;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.nifi.distributed.cache.protocol.exception.HandshakeException;
import org.apache.nifi.remote.VersionNegotiator;

public class ProtocolHandshake {
    public static final byte[] MAGIC_HEADER = new byte[]{78, 105, 70, 105};
    public static final int RESOURCE_OK = 20;
    public static final int DIFFERENT_RESOURCE_VERSION = 21;
    public static final int ABORT = 255;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initiateHandshake(InputStream in, OutputStream out, VersionNegotiator versionNegotiator) throws IOException, HandshakeException {
        DataInputStream dis = new DataInputStream(in);
        DataOutputStream dos = new DataOutputStream(out);
        try {
            dos.write(MAGIC_HEADER);
            ProtocolHandshake.initiateVersionNegotiation(versionNegotiator, dis, dos);
        }
        finally {
            dos.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void receiveHandshake(InputStream in, OutputStream out, VersionNegotiator versionNegotiator) throws IOException, HandshakeException {
        DataInputStream dis = new DataInputStream(in);
        DataOutputStream dos = new DataOutputStream(out);
        try {
            byte[] magicHeaderBuffer = new byte[MAGIC_HEADER.length];
            dis.readFully(magicHeaderBuffer);
            ProtocolHandshake.receiveVersionNegotiation(versionNegotiator, dis, dos);
        }
        finally {
            dos.flush();
        }
    }

    private static void initiateVersionNegotiation(VersionNegotiator negotiator, DataInputStream dis, DataOutputStream dos) throws IOException, HandshakeException {
        dos.writeInt(negotiator.getVersion());
        dos.flush();
        int statusCode = dis.read();
        switch (statusCode) {
            case 20: {
                return;
            }
            case 21: {
                int newVersion = dis.readInt();
                Integer newPreference = negotiator.getPreferredVersion(newVersion);
                if (newPreference == null) {
                    throw new HandshakeException("Could not agree on protocol version");
                }
                negotiator.setVersion(newPreference.intValue());
                ProtocolHandshake.initiateVersionNegotiation(negotiator, dis, dos);
                return;
            }
            case 255: {
                throw new HandshakeException("Remote destination aborted connection with message: " + dis.readUTF());
            }
        }
        throw new HandshakeException("Received unexpected response code " + statusCode + " when negotiating version with remote server");
    }

    private static void receiveVersionNegotiation(VersionNegotiator negotiator, DataInputStream dis, DataOutputStream dos) throws IOException, HandshakeException {
        int version = dis.readInt();
        if (negotiator.isVersionSupported(version)) {
            dos.write(20);
            dos.flush();
            negotiator.setVersion(version);
        } else {
            Integer preferred = negotiator.getPreferredVersion(version);
            if (preferred == null) {
                dos.write(255);
                dos.flush();
                throw new HandshakeException("Unable to negotiate an acceptable version of the Distributed Cache Protocol");
            }
            dos.write(21);
            dos.writeInt(preferred);
            dos.flush();
            ProtocolHandshake.receiveVersionNegotiation(negotiator, dis, dos);
        }
    }
}

