/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client.adapter;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.nifi.distributed.cache.client.Serializer;

public class OutboundAdapter {
    private static final int NO_MINIMUM_VERSION = 0;
    private int minimumVersion = 0;
    private final ByteArrayOutputStream bos = new ByteArrayOutputStream();
    private final DataOutputStream dos = new DataOutputStream(this.bos);

    public int getMinimumVersion() {
        return this.minimumVersion;
    }

    public OutboundAdapter minimumVersion(int minimumVersion) {
        this.minimumVersion = minimumVersion;
        return this;
    }

    public OutboundAdapter write(int value) throws IOException {
        this.dos.writeInt(value);
        return this;
    }

    public OutboundAdapter write(long value) throws IOException {
        this.dos.writeLong(value);
        return this;
    }

    public OutboundAdapter write(String value) throws IOException {
        this.dos.writeUTF(value);
        return this;
    }

    public OutboundAdapter write(byte[] value) throws IOException {
        this.dos.writeInt(value.length);
        this.dos.write(value);
        return this;
    }

    public OutboundAdapter write(Collection<byte[]> values) throws IOException {
        this.dos.writeInt(values.size());
        for (byte[] value : values) {
            this.write(value);
        }
        return this;
    }

    public <T> OutboundAdapter write(T value, Serializer<T> serializer) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        serializer.serialize(value, (OutputStream)os);
        this.dos.writeInt(os.size());
        this.dos.write(os.toByteArray());
        return this;
    }

    public byte[] toBytes() throws IOException {
        this.dos.flush();
        return this.bos.toByteArray();
    }
}

