/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client.adapter;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.apache.nifi.distributed.cache.client.Deserializer;

public class InboundToken<T> {
    private boolean isComplete;
    private Integer length;
    private T value;

    public InboundToken() {
        this.reset();
    }

    public void reset() {
        this.isComplete = false;
        this.length = null;
        this.value = null;
    }

    public void update(ByteBuf byteBuf, Deserializer<T> deserializer) throws IOException {
        if (this.length == null && byteBuf.readableBytes() >= 4) {
            this.length = byteBuf.readInt();
        }
        if (this.length != null && byteBuf.readableBytes() >= this.length) {
            byte[] bytes = new byte[this.length.intValue()];
            byteBuf.readBytes(bytes);
            this.value = deserializer.deserialize(bytes);
            this.isComplete = true;
        }
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public T getValue() {
        return this.value;
    }
}

