/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client.adapter;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import org.apache.nifi.distributed.cache.client.Deserializer;
import org.apache.nifi.distributed.cache.client.adapter.InboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.InboundToken;

public class ValueInboundAdapter<T>
implements InboundAdapter {
    private final Deserializer<T> deserializer;
    private final ByteBuf byteBuf;
    private final InboundToken<T> inboundToken;

    public ValueInboundAdapter(Deserializer<T> deserializer) {
        this.deserializer = deserializer;
        this.byteBuf = Unpooled.buffer();
        this.inboundToken = new InboundToken();
    }

    public T getResult() {
        return this.inboundToken.getValue();
    }

    @Override
    public boolean isComplete() {
        return this.inboundToken.isComplete();
    }

    @Override
    public void queue(byte[] bytes) {
        this.byteBuf.writeBytes(bytes);
    }

    @Override
    public void dequeue() throws IOException {
        this.inboundToken.update(this.byteBuf, this.deserializer);
    }
}

