/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.distributed.cache.client.CommsSession;
import org.apache.nifi.distributed.cache.client.DistributedMapCacheClientService;
import org.apache.nifi.distributed.cache.client.DistributedSetCacheClient;
import org.apache.nifi.distributed.cache.client.SSLCommsSession;
import org.apache.nifi.distributed.cache.client.Serializer;
import org.apache.nifi.distributed.cache.client.StandardCommsSession;
import org.apache.nifi.distributed.cache.protocol.ProtocolHandshake;
import org.apache.nifi.distributed.cache.protocol.exception.HandshakeException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.remote.StandardVersionNegotiator;
import org.apache.nifi.remote.VersionNegotiator;
import org.apache.nifi.ssl.SSLContextService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tags(value={"distributed", "cache", "state", "set", "cluster"})
@SeeAlso(classNames={"org.apache.nifi.distributed.cache.server.DistributedSetCacheServer", "org.apache.nifi.ssl.StandardSSLContextService"})
@CapabilityDescription(value="Provides the ability to communicate with a DistributedSetCacheServer. This can be used in order to share a Set between nodes in a NiFi cluster")
public class DistributedSetCacheClientService
extends AbstractControllerService
implements DistributedSetCacheClient {
    private static final Logger logger = LoggerFactory.getLogger(DistributedMapCacheClientService.class);
    public static final PropertyDescriptor HOSTNAME = new PropertyDescriptor.Builder().name("Server Hostname").description("The name of the server that is running the DistributedSetCacheServer service").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PORT = new PropertyDescriptor.Builder().name("Server Port").description("The port on the remote server that is to be used when communicating with the DistributedSetCacheServer service").required(true).addValidator(StandardValidators.PORT_VALIDATOR).defaultValue("4557").build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("If specified, indicates the SSL Context Service that is used to communicate with the remote server. If not specified, communications will not be encrypted").required(false).identifiesControllerService(SSLContextService.class).build();
    public static final PropertyDescriptor COMMUNICATIONS_TIMEOUT = new PropertyDescriptor.Builder().name("Communications Timeout").description("Specifices how long to wait when communicating with the remote server before determining that there is a communications failure if data cannot be sent or received").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("30 secs").build();
    private final BlockingQueue<CommsSession> queue = new LinkedBlockingQueue<CommsSession>();
    private volatile ConfigurationContext configContext;
    private volatile boolean closed = false;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(HOSTNAME);
        descriptors.add(PORT);
        descriptors.add(SSL_CONTEXT_SERVICE);
        descriptors.add(COMMUNICATIONS_TIMEOUT);
        return descriptors;
    }

    @OnEnabled
    public void onConfigured(ConfigurationContext context) {
        this.configContext = context;
    }

    @OnStopped
    public void onStopped() throws IOException {
        this.close();
    }

    public CommsSession createCommsSession(ConfigurationContext context) throws IOException {
        String hostname = context.getProperty(HOSTNAME).getValue();
        int port = context.getProperty(PORT).asInteger();
        int timeoutMillis = context.getProperty(COMMUNICATIONS_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        SSLContextService sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        CommsSession commsSession = sslContextService == null ? new StandardCommsSession(hostname, port, timeoutMillis) : new SSLCommsSession(sslContextService.createSSLContext(SSLContextService.ClientAuth.REQUIRED), hostname, port, timeoutMillis);
        commsSession.setTimeout(timeoutMillis, TimeUnit.MILLISECONDS);
        return commsSession;
    }

    private CommsSession leaseCommsSession() throws IOException {
        CommsSession session = (CommsSession)this.queue.poll();
        if (session != null && !session.isClosed()) {
            return session;
        }
        session = this.createCommsSession(this.configContext);
        StandardVersionNegotiator versionNegotiator = new StandardVersionNegotiator(new int[]{1});
        try {
            ProtocolHandshake.initiateHandshake((InputStream)session.getInputStream(), (OutputStream)session.getOutputStream(), (VersionNegotiator)versionNegotiator);
            session.setProtocolVersion(versionNegotiator.getVersion());
        }
        catch (HandshakeException e) {
            IOUtils.closeQuietly((Closeable)session);
            throw new IOException(e);
        }
        return session;
    }

    public <T> boolean addIfAbsent(T value, Serializer<T> serializer) throws IOException {
        return this.invokeRemoteBoolean("addIfAbsent", value, serializer);
    }

    public <T> boolean contains(T value, Serializer<T> serializer) throws IOException {
        return this.invokeRemoteBoolean("contains", value, serializer);
    }

    public <T> boolean remove(T value, Serializer<T> serializer) throws IOException {
        return this.invokeRemoteBoolean("remove", value, serializer);
    }

    public void close() throws IOException {
        CommsSession commsSession;
        this.closed = true;
        while ((commsSession = (CommsSession)this.queue.poll()) != null) {
            try (DataOutputStream dos = new DataOutputStream(commsSession.getOutputStream());){
                dos.writeUTF("close");
                dos.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            IOUtils.closeQuietly((Closeable)commsSession);
        }
        if (logger.isDebugEnabled() && this.getIdentifier() != null) {
            logger.debug("Closed {}", new Object[]{this.getIdentifier()});
        }
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            this.close();
        }
        logger.debug("Finalize called");
    }

    private <T> boolean invokeRemoteBoolean(String methodName, T value, Serializer<T> serializer) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Client is closed");
        }
        CommsSession session = this.leaseCommsSession();
        boolean tryToRequeue = true;
        try {
            DataOutputStream dos = new DataOutputStream(session.getOutputStream());
            dos.writeUTF(methodName);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            serializer.serialize(value, (OutputStream)baos);
            dos.writeInt(baos.size());
            baos.writeTo(dos);
            dos.flush();
            DataInputStream dis = new DataInputStream(session.getInputStream());
            boolean bl = dis.readBoolean();
            return bl;
        }
        catch (IOException ioe) {
            tryToRequeue = false;
            throw ioe;
        }
        finally {
            if (tryToRequeue && !this.closed) {
                this.queue.offer(session);
            } else {
                IOUtils.closeQuietly((Closeable)session);
            }
        }
    }
}

