/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.dbcp.utils;

import java.io.File;
import java.lang.reflect.Modifier;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.nifi.components.resource.ResourceReference;
import org.apache.nifi.components.resource.ResourceReferences;
import org.apache.nifi.components.resource.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DriverUtils.class);
    private static final String DRIVER_CLASS_PATTERN = "(?i).*(driver|jdbc).*";
    private static final Pattern DRIVER_PATTERN = Pattern.compile("(?i).*(driver|jdbc).*");

    public static List<String> findDriverClassNames(ResourceReferences driverResources) {
        TreeSet<String> driverClasses = new TreeSet<String>();
        if (driverResources == null || driverResources.getCount() == 0) {
            LOGGER.debug("No driver resources provided for static discovery");
            return new ArrayList<String>();
        }
        LOGGER.debug("Starting static driver discovery for {} resources", (Object)driverResources.getCount());
        for (ResourceReference resource : driverResources.flattenRecursively().asList()) {
            try {
                LOGGER.debug("Processing resource: {} (type: {})", (Object)resource.getLocation(), (Object)resource.getResourceType());
                List<File> jarFiles = DriverUtils.getJarFilesFromResource(resource);
                LOGGER.debug("Found {} JAR files in resource {}", (Object)jarFiles.size(), (Object)resource.getLocation());
                for (File jarFile : jarFiles) {
                    LOGGER.debug("Scanning JAR file: {}", (Object)jarFile.getAbsolutePath());
                    Set<String> foundDrivers = DriverUtils.scanJarForDriverClassesUsingMetadata(jarFile);
                    LOGGER.debug("Found {} potential driver classes in {}", (Object)foundDrivers.size(), (Object)jarFile.getName());
                    driverClasses.addAll(foundDrivers);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error processing resource {} for static driver discovery", (Object)resource.getLocation(), (Object)e);
            }
        }
        LOGGER.debug("Static driver discovery completed. Found {} potential driver classes", (Object)driverClasses.size());
        return new ArrayList<String>(driverClasses);
    }

    private static Set<String> scanJarForDriverClassesUsingMetadata(File jarFile) {
        TreeSet<String> treeSet;
        TreeSet<String> driverClasses = new TreeSet<String>();
        JarFile jar = new JarFile(jarFile);
        try {
            JarEntry servicesEntry = jar.getJarEntry("META-INF/services/java.sql.Driver");
            if (servicesEntry != null) {
                try (Scanner scanner = new Scanner(jar.getInputStream(servicesEntry));){
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine().trim();
                        if (line.isEmpty() || line.startsWith("#")) continue;
                        driverClasses.add(line);
                        LOGGER.debug("Found driver in META-INF/services: {}", (Object)line);
                    }
                }
            }
            treeSet = driverClasses;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.warn("Error scanning JAR file {} for driver classes", (Object)jarFile.getAbsolutePath(), (Object)e);
                return driverClasses;
            }
        }
        jar.close();
        return treeSet;
    }

    private static List<File> getJarFilesFromResource(ResourceReference resource) {
        File file;
        ArrayList<File> jarFiles = new ArrayList<File>();
        if (resource.getResourceType() == ResourceType.FILE && (file = new File(resource.getLocation())).exists() && file.canRead() && file.getName().toLowerCase().endsWith(".jar")) {
            jarFiles.add(file);
        }
        return jarFiles;
    }

    public static List<String> discoverDriverClasses(ResourceReferences driverResources) {
        TreeSet<String> driverClasses = new TreeSet<String>();
        if (driverResources == null || driverResources.getCount() == 0) {
            return new ArrayList<String>();
        }
        for (ResourceReference resource : driverResources.flattenRecursively().asList()) {
            try {
                List<File> jarFiles = DriverUtils.getJarFilesFromResource(resource);
                for (File jarFile : jarFiles) {
                    driverClasses.addAll(DriverUtils.scanJarForDriverClasses(jarFile));
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error processing resource {} for driver discovery", (Object)resource.getLocation(), (Object)e);
            }
        }
        return new ArrayList<String>(driverClasses);
    }

    private static Set<String> scanJarForDriverClasses(File jarFile) {
        TreeSet<String> actualDriverClasses = new TreeSet<String>();
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String className;
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".class") || entryName.contains("$") || !DriverUtils.isPotentialDriverClass(className = entryName.substring(0, entryName.length() - 6).replace('/', '.')) || !DriverUtils.isActualDriverClass(className)) continue;
                actualDriverClasses.add(className);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error scanning JAR file {} for driver classes", (Object)jarFile.getAbsolutePath(), (Object)e);
        }
        return actualDriverClasses;
    }

    private static boolean isPotentialDriverClass(String className) {
        return DRIVER_PATTERN.matcher(className).matches();
    }

    private static boolean isActualDriverClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return Driver.class.isAssignableFrom(clazz) && !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
        }
        catch (Throwable e) {
            return false;
        }
    }
}

