/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.dbcp;

import java.util.Collections;
import java.util.Set;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;

public class DriverClassValidator
implements Validator {
    private static final Set<String> UNSUPPORTED_CLASSES = Collections.singleton("org.h2.Driver");

    public ValidationResult validate(String subject, String input, ValidationContext context) {
        ValidationResult.Builder builder = new ValidationResult.Builder().subject(subject).input(input);
        if (input == null || input.isEmpty()) {
            builder.valid(false);
            builder.explanation("Driver Class required");
        } else {
            String driverClass = context.newPropertyValue(input).evaluateAttributeExpressions().getValue().trim();
            if (this.isDriverClassUnsupported(driverClass)) {
                builder.valid(false);
                builder.explanation(String.format("Driver Class is listed as unsupported %s", UNSUPPORTED_CLASSES));
            } else {
                builder.valid(true);
                builder.explanation("Driver Class is valid");
            }
        }
        return builder.build();
    }

    private boolean isDriverClassUnsupported(String driverClass) {
        return UNSUPPORTED_CLASSES.contains(driverClass);
    }
}

