/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.dbcp.api;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class DatabasePasswordRequestContext {
    private final String jdbcUrl;
    private final String databaseUser;
    private final String driverClassName;
    private final Map<String, String> connectionProperties;

    private DatabasePasswordRequestContext(Builder builder) {
        this.jdbcUrl = builder.jdbcUrl;
        this.databaseUser = builder.databaseUser;
        this.driverClassName = builder.driverClassName;
        this.connectionProperties = builder.connectionProperties == null ? Collections.emptyMap() : Collections.unmodifiableMap(builder.connectionProperties);
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public Map<String, String> getConnectionProperties() {
        return this.connectionProperties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String jdbcUrl;
        private String databaseUser;
        private String driverClassName;
        private Map<String, String> connectionProperties;

        public Builder jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public Builder databaseUser(String databaseUser) {
            this.databaseUser = databaseUser;
            return this;
        }

        public Builder driverClassName(String driverClassName) {
            this.driverClassName = driverClassName;
            return this;
        }

        public Builder connectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties = connectionProperties;
            return this;
        }

        public DatabasePasswordRequestContext build() {
            Objects.requireNonNull(this.jdbcUrl, "JDBC URL required");
            Objects.requireNonNull(this.driverClassName, "Driver Class Name required");
            return new DatabasePasswordRequestContext(this);
        }
    }
}

