/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.dbcp;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.nifi.dbcp.api.DatabasePasswordProvider;
import org.apache.nifi.dbcp.api.DatabasePasswordRequestContext;

public class ProviderAwareBasicDataSource
extends BasicDataSource {
    private volatile DatabasePasswordProvider databasePasswordProvider;
    private volatile DatabasePasswordRequestContext passwordRequestContext;

    public void setDatabasePasswordProvider(DatabasePasswordProvider passwordProvider, DatabasePasswordRequestContext requestContext) {
        if (passwordProvider != null && requestContext == null) {
            throw new IllegalArgumentException("Database Password Request Context required when a provider is configured");
        }
        this.databasePasswordProvider = passwordProvider;
        this.passwordRequestContext = requestContext;
    }

    protected ConnectionFactory createConnectionFactory() throws SQLException {
        ConnectionFactory delegate = super.createConnectionFactory();
        if (this.databasePasswordProvider == null) {
            return delegate;
        }
        if (delegate instanceof DriverConnectionFactory) {
            DriverConnectionFactory driverConnectionFactory = (DriverConnectionFactory)delegate;
            return new PasswordRefreshingConnectionFactory(driverConnectionFactory, this.databasePasswordProvider, this.passwordRequestContext);
        }
        throw new SQLException("Database Password Provider configured but unsupported ConnectionFactory [%s]".formatted(delegate.getClass().getName()));
    }

    private static class PasswordRefreshingConnectionFactory
    extends DriverConnectionFactory {
        private final DatabasePasswordProvider passwordProvider;
        private final DatabasePasswordRequestContext passwordRequestContext;

        PasswordRefreshingConnectionFactory(DriverConnectionFactory delegate, DatabasePasswordProvider passwordProvider, DatabasePasswordRequestContext passwordRequestContext) {
            super(delegate.getDriver(), delegate.getConnectionString(), delegate.getProperties());
            this.passwordProvider = passwordProvider;
            this.passwordRequestContext = passwordRequestContext;
        }

        public Connection createConnection() throws SQLException {
            char[] passwordCharacters;
            try {
                passwordCharacters = this.passwordProvider.getPassword(this.passwordRequestContext);
            }
            catch (Exception e) {
                throw new SQLException("Failed to obtain database password from provider", e);
            }
            if (passwordCharacters == null || passwordCharacters.length == 0) {
                throw new SQLException("Database Password Provider returned an empty password");
            }
            String password = new String(passwordCharacters);
            Arrays.fill(passwordCharacters, '\u0000');
            this.getProperties().put("password", password);
            return super.createConnection();
        }
    }
}

