/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.datadog.metrics;

import com.yammer.metrics.core.VirtualMachineMetrics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.PortStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;

public class MetricsService {
    public Map<String, Double> getProcessorMetrics(ProcessorStatus status) {
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        metrics.put("FlowFilesReceivedLast5Minutes", new Double(status.getInputCount()));
        metrics.put("FlowFilesSentLast5Minutes", new Double(status.getOutputCount()));
        metrics.put("BytesReadLast5Minutes", new Double(status.getInputBytes()));
        metrics.put("BytesWrittenLast5Minutes", new Double(status.getOutputBytes()));
        metrics.put("ActiveThreads", new Double(status.getActiveThreadCount()));
        metrics.put("TotalTaskDurationSeconds", new Double(status.getProcessingNanos()));
        return metrics;
    }

    public Map<String, Double> getPortStatusMetrics(PortStatus status) {
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        metrics.put("ActiveThreads", new Double(status.getActiveThreadCount().intValue()));
        metrics.put("InputCount", new Double(status.getInputCount()));
        metrics.put("OutputCount", new Double(status.getOutputCount()));
        metrics.put("InputBytes", new Double(status.getInputBytes()));
        metrics.put("OutputBytes", new Double(status.getOutputBytes()));
        metrics.put("FlowFilesReceivedLast5Minutes", new Double(status.getFlowFilesReceived()));
        metrics.put("FlowFilesSentLast5Minutes", new Double(status.getFlowFilesSent()));
        metrics.put("BytesReceivedLast5Minutes", new Double(status.getBytesReceived()));
        metrics.put("BytesSentLast5Minutes", new Double(status.getBytesSent()));
        return metrics;
    }

    public Map<String, String> getPortStatusTags(PortStatus status) {
        HashMap<String, String> portTags = new HashMap<String, String>();
        portTags.put("port-id", status.getId());
        portTags.put("port-group-id", status.getGroupId());
        portTags.put("port-name", status.getName());
        return portTags;
    }

    public Map<String, String> getConnectionStatusTags(ConnectionStatus status) {
        HashMap<String, String> connectionTags = new HashMap<String, String>();
        connectionTags.put("connection-id", status.getId());
        connectionTags.put("connection-name", status.getName());
        connectionTags.put("connection-group-id", status.getGroupId());
        connectionTags.put("connection-destination-id", status.getDestinationId());
        connectionTags.put("connection-destination-name", status.getDestinationName());
        connectionTags.put("connection-source-id", status.getSourceId());
        connectionTags.put("connection-source-name", status.getSourceName());
        return connectionTags;
    }

    public Map<String, Double> getConnectionStatusMetrics(ConnectionStatus status) {
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        metrics.put("InputCount", new Double(status.getInputCount()));
        metrics.put("InputBytes", new Double(status.getInputBytes()));
        metrics.put("QueuedCount", new Double(status.getQueuedCount()));
        metrics.put("QueuedBytes", new Double(status.getQueuedBytes()));
        metrics.put("OutputCount", new Double(status.getOutputCount()));
        metrics.put("OutputBytes", new Double(status.getOutputBytes()));
        return metrics;
    }

    public Map<String, Double> getDataFlowMetrics(ProcessGroupStatus status) {
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        metrics.put("FlowFilesReceivedLast5Minutes", new Double(status.getFlowFilesReceived()));
        metrics.put("BytesReceivedLast5Minutes", new Double(status.getBytesReceived()));
        metrics.put("FlowFilesSentLast5Minutes", new Double(status.getFlowFilesSent()));
        metrics.put("BytesSentLast5Minutes", new Double(status.getBytesSent()));
        metrics.put("FlowFilesQueued", new Double(status.getQueuedCount().intValue()));
        metrics.put("BytesQueued", new Double(status.getQueuedContentSize().longValue()));
        metrics.put("BytesReadLast5Minutes", new Double(status.getBytesRead().longValue()));
        metrics.put("BytesWrittenLast5Minutes", new Double(status.getBytesWritten().longValue()));
        metrics.put("ActiveThreads", new Double(status.getActiveThreadCount().intValue()));
        metrics.put("TotalTaskDurationSeconds", new Double(this.calculateProcessingNanos(status)));
        status.getOutputPortStatus();
        return metrics;
    }

    public List<String> getAllTagsList() {
        ArrayList<String> tagsList = new ArrayList<String>();
        tagsList.add("env");
        tagsList.add("dataflow_id");
        tagsList.add("port-id");
        tagsList.add("port-name");
        tagsList.add("port-group-id");
        tagsList.add("connection-id");
        tagsList.add("connection-name");
        tagsList.add("connection-group-id");
        tagsList.add("connection-source-id");
        tagsList.add("connection-source-name");
        tagsList.add("connection-destination-id");
        tagsList.add("connection-destination-name");
        return tagsList;
    }

    public Map<String, Double> getJVMMetrics(VirtualMachineMetrics virtualMachineMetrics) {
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        metrics.put("jvm.uptime", new Double(virtualMachineMetrics.uptime()));
        metrics.put("jvm.heap_used", new Double(virtualMachineMetrics.heapUsed()));
        metrics.put("jvm.heap_usage", new Double(virtualMachineMetrics.heapUsage()));
        metrics.put("jvm.non_heap_usage", new Double(virtualMachineMetrics.nonHeapUsage()));
        metrics.put("jvm.thread_count", new Double(virtualMachineMetrics.threadCount()));
        metrics.put("jvm.daemon_thread_count", new Double(virtualMachineMetrics.daemonThreadCount()));
        metrics.put("jvm.file_descriptor_usage", new Double(virtualMachineMetrics.fileDescriptorUsage()));
        for (Map.Entry entry : virtualMachineMetrics.threadStatePercentages().entrySet()) {
            int normalizedValue = (int)(100.0 * (entry.getValue() == null ? 0.0 : (Double)entry.getValue()));
            switch ((Thread.State)((Object)entry.getKey())) {
                case BLOCKED: {
                    metrics.put("jvm.thread_states.blocked", new Double(normalizedValue));
                    break;
                }
                case RUNNABLE: {
                    metrics.put("jvm.thread_states.runnable", new Double(normalizedValue));
                    break;
                }
                case TERMINATED: {
                    metrics.put("jvm.thread_states.terminated", new Double(normalizedValue));
                    break;
                }
                case TIMED_WAITING: {
                    metrics.put("jvm.thread_states.timed_waiting", new Double(normalizedValue));
                    break;
                }
            }
        }
        for (Map.Entry entry : virtualMachineMetrics.garbageCollectors().entrySet()) {
            String gcName = ((String)entry.getKey()).replace(" ", "");
            long runs = ((VirtualMachineMetrics.GarbageCollectorStats)entry.getValue()).getRuns();
            long timeMS = ((VirtualMachineMetrics.GarbageCollectorStats)entry.getValue()).getTime(TimeUnit.MILLISECONDS);
            metrics.put("jvm.gc.runs." + gcName, new Double(runs));
            metrics.put("jvm.gc.time." + gcName, new Double(timeMS));
        }
        return metrics;
    }

    protected long calculateProcessingNanos(ProcessGroupStatus status) {
        long nanos = 0L;
        for (ProcessorStatus procStats : status.getProcessorStatus()) {
            nanos += procStats.getProcessingNanos();
        }
        for (ProcessGroupStatus childGroupStatus : status.getProcessGroupStatus()) {
            nanos += this.calculateProcessingNanos(childGroupStatus);
        }
        return nanos;
    }
}

