/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.datadog;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AtomicDouble;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.PortStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.metrics.jvm.JmxJvmMetrics;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.AbstractReportingTask;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.datadog.DDMetricRegistryBuilder;
import org.apache.nifi.reporting.datadog.metrics.MetricsService;
import org.coursera.metrics.datadog.DynamicTagsCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tags(value={"reporting", "datadog", "metrics"})
@CapabilityDescription(value="Publishes metrics from NiFi to datadog. For accurate and informative reporting, components should have unique names.")
public class DataDogReportingTask
extends AbstractReportingTask {
    static final AllowableValue DATADOG_AGENT = new AllowableValue("Datadog Agent", "Datadog Agent", "Metrics will be sent via locally installed Datadog agent. Datadog agent needs to be installed manually before using this option");
    static final AllowableValue DATADOG_HTTP = new AllowableValue("Datadog HTTP", "Datadog HTTP", "Metrics will be sent via HTTP transport with no need of Agent installed. Datadog API key needs to be set");
    static final PropertyDescriptor DATADOG_TRANSPORT = new PropertyDescriptor.Builder().name("Datadog transport").description("Transport through which metrics will be sent to Datadog").required(true).allowableValues(new AllowableValue[]{DATADOG_AGENT, DATADOG_HTTP}).defaultValue(DATADOG_HTTP.getValue()).build();
    static final PropertyDescriptor API_KEY = new PropertyDescriptor.Builder().name("API key").description("Datadog API key. If specified value is 'agent', local Datadog agent will be used.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor METRICS_PREFIX = new PropertyDescriptor.Builder().name("Metrics prefix").description("Prefix to be added before every metric").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("nifi").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor ENVIRONMENT = new PropertyDescriptor.Builder().name("Environment").description("Environment, dataflow is running in. This property will be included as metrics tag.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("dev").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private MetricsService metricsService;
    private DDMetricRegistryBuilder ddMetricRegistryBuilder;
    private MetricRegistry metricRegistry;
    private String metricsPrefix;
    private String environment;
    private String statusId;
    private ConcurrentHashMap<String, AtomicDouble> metricsMap;
    private Map<String, String> defaultTags;
    private volatile JmxJvmMetrics virtualMachineMetrics;
    private Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());

    @OnScheduled
    public void setup(ConfigurationContext context) {
        this.metricsService = this.getMetricsService();
        this.ddMetricRegistryBuilder = this.getMetricRegistryBuilder();
        this.metricRegistry = this.getMetricRegistry();
        this.metricsMap = this.getMetricsMap();
        this.metricsPrefix = METRICS_PREFIX.getDefaultValue();
        this.environment = ENVIRONMENT.getDefaultValue();
        this.virtualMachineMetrics = JmxJvmMetrics.getInstance();
        this.ddMetricRegistryBuilder.setMetricRegistry(this.metricRegistry).setTags(this.metricsService.getAllTagsList());
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(METRICS_PREFIX);
        properties.add(ENVIRONMENT);
        properties.add(API_KEY);
        properties.add(DATADOG_TRANSPORT);
        return properties;
    }

    public void onTrigger(ReportingContext context) {
        ProcessGroupStatus status = context.getEventAccess().getControllerStatus();
        this.metricsPrefix = context.getProperty(METRICS_PREFIX).evaluateAttributeExpressions().getValue();
        this.environment = context.getProperty(ENVIRONMENT).evaluateAttributeExpressions().getValue();
        this.statusId = status.getId();
        this.defaultTags = ImmutableMap.of((Object)"env", (Object)this.environment, (Object)"dataflow_id", (Object)this.statusId);
        try {
            this.updateDataDogTransport(context);
        }
        catch (IOException e) {
            this.logger.warn("Unable to update data dog transport", (Throwable)e);
        }
        this.updateAllMetricGroups(status);
        this.ddMetricRegistryBuilder.getDatadogReporter().report();
    }

    protected void updateMetrics(Map<String, Double> metrics, Optional<String> processorName, Map<String, String> tags) {
        for (Map.Entry<String, Double> entry : metrics.entrySet()) {
            String metricName = this.buildMetricName(processorName, entry.getKey());
            this.logger.debug(metricName + ": " + entry.getValue());
            if (!this.metricsMap.containsKey(metricName)) {
                this.metricsMap.put(metricName, new AtomicDouble(entry.getValue().doubleValue()));
                this.metricRegistry.register(metricName, (Metric)new MetricGauge(metricName, tags));
            }
            this.metricsMap.get(metricName).set(entry.getValue().doubleValue());
        }
    }

    private void updateAllMetricGroups(ProcessGroupStatus processGroupStatus) {
        ArrayList<ProcessorStatus> processorStatuses = new ArrayList<ProcessorStatus>();
        this.populateProcessorStatuses(processGroupStatus, processorStatuses);
        for (ProcessorStatus processorStatus : processorStatuses) {
            this.updateMetrics(this.metricsService.getProcessorMetrics(processorStatus), (Optional<String>)Optional.of((Object)processorStatus.getName()), this.defaultTags);
        }
        ArrayList<ConnectionStatus> connectionStatuses = new ArrayList<ConnectionStatus>();
        this.populateConnectionStatuses(processGroupStatus, connectionStatuses);
        for (ConnectionStatus connectionStatus : connectionStatuses) {
            HashMap<String, String> connectionStatusTags = new HashMap<String, String>(this.defaultTags);
            connectionStatusTags.putAll(this.metricsService.getConnectionStatusTags(connectionStatus));
            this.updateMetrics(this.metricsService.getConnectionStatusMetrics(connectionStatus), (Optional<String>)Optional.absent(), connectionStatusTags);
        }
        ArrayList<PortStatus> arrayList = new ArrayList<PortStatus>();
        this.populateInputPortStatuses(processGroupStatus, arrayList);
        for (PortStatus portStatus : arrayList) {
            HashMap<String, String> portTags = new HashMap<String, String>(this.defaultTags);
            portTags.putAll(this.metricsService.getPortStatusTags(portStatus));
            this.updateMetrics(this.metricsService.getPortStatusMetrics(portStatus), (Optional<String>)Optional.absent(), portTags);
        }
        ArrayList<PortStatus> arrayList2 = new ArrayList<PortStatus>();
        this.populateOutputPortStatuses(processGroupStatus, arrayList2);
        for (PortStatus portStatus : arrayList2) {
            HashMap<String, String> portTags = new HashMap<String, String>(this.defaultTags);
            portTags.putAll(this.metricsService.getPortStatusTags(portStatus));
            this.updateMetrics(this.metricsService.getPortStatusMetrics(portStatus), (Optional<String>)Optional.absent(), portTags);
        }
        this.updateMetrics(this.metricsService.getJVMMetrics(this.virtualMachineMetrics), (Optional<String>)Optional.absent(), this.defaultTags);
        this.updateMetrics(this.metricsService.getDataFlowMetrics(processGroupStatus), (Optional<String>)Optional.absent(), this.defaultTags);
    }

    private void updateDataDogTransport(ReportingContext context) throws IOException {
        String dataDogTransport = context.getProperty(DATADOG_TRANSPORT).getValue();
        if (dataDogTransport.equalsIgnoreCase(DATADOG_AGENT.getValue())) {
            this.ddMetricRegistryBuilder.build("agent");
        } else if (dataDogTransport.equalsIgnoreCase(DATADOG_HTTP.getValue()) && context.getProperty(API_KEY).isSet()) {
            this.ddMetricRegistryBuilder.build(context.getProperty(API_KEY).getValue());
        }
    }

    private void populateProcessorStatuses(ProcessGroupStatus groupStatus, List<ProcessorStatus> statuses) {
        statuses.addAll(groupStatus.getProcessorStatus());
        for (ProcessGroupStatus childGroupStatus : groupStatus.getProcessGroupStatus()) {
            this.populateProcessorStatuses(childGroupStatus, statuses);
        }
    }

    private void populateConnectionStatuses(ProcessGroupStatus groupStatus, List<ConnectionStatus> statuses) {
        statuses.addAll(groupStatus.getConnectionStatus());
        for (ProcessGroupStatus childGroupStatus : groupStatus.getProcessGroupStatus()) {
            this.populateConnectionStatuses(childGroupStatus, statuses);
        }
    }

    private void populateInputPortStatuses(ProcessGroupStatus groupStatus, List<PortStatus> statuses) {
        statuses.addAll(groupStatus.getInputPortStatus());
        for (ProcessGroupStatus childGroupStatus : groupStatus.getProcessGroupStatus()) {
            this.populateInputPortStatuses(childGroupStatus, statuses);
        }
    }

    private void populateOutputPortStatuses(ProcessGroupStatus groupStatus, List<PortStatus> statuses) {
        statuses.addAll(groupStatus.getOutputPortStatus());
        for (ProcessGroupStatus childGroupStatus : groupStatus.getProcessGroupStatus()) {
            this.populateOutputPortStatuses(childGroupStatus, statuses);
        }
    }

    private String buildMetricName(Optional<String> processorName, String metricName) {
        return this.metricsPrefix + "." + (String)processorName.or((Object)"flow") + "." + metricName;
    }

    protected MetricsService getMetricsService() {
        return new MetricsService();
    }

    protected DDMetricRegistryBuilder getMetricRegistryBuilder() {
        return new DDMetricRegistryBuilder();
    }

    protected MetricRegistry getMetricRegistry() {
        return new MetricRegistry();
    }

    protected ConcurrentHashMap<String, AtomicDouble> getMetricsMap() {
        return new ConcurrentHashMap<String, AtomicDouble>();
    }

    private class MetricGauge
    implements Gauge,
    DynamicTagsCallback {
        private Map<String, String> tags;
        private String metricName;

        public MetricGauge(String metricName, Map<String, String> tagsMap) {
            this.tags = tagsMap;
            this.metricName = metricName;
        }

        public Object getValue() {
            return ((AtomicDouble)DataDogReportingTask.this.metricsMap.get(this.metricName)).get();
        }

        public List<String> getTags() {
            ArrayList tagsList = Lists.newArrayList();
            for (Map.Entry<String, String> entry : this.tags.entrySet()) {
                tagsList.add(entry.getKey() + ":" + entry.getValue());
            }
            return tagsList;
        }
    }
}

