/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;

public class SimpleCommerceDataSet {
    static String dropPersons = "drop table persons";
    static String dropProducts = "drop table products";
    static String dropRelationships = "drop table relationships";
    static String createPersons = "create table persons (id integer, name varchar(100), code integer)";
    static String createProducts = "create table products (id integer, name varchar(100), code integer)";
    static String createRelationships = "create table relationships (id integer,name varchar(100), code integer)";
    static Random rng = new Random(53495L);

    public static void loadTestData2Database(Connection con, int nrOfPersons, int nrOfProducts, int nrOfRels) throws SQLException {
        int i;
        System.out.println(SimpleCommerceDataSet.createRandomName());
        System.out.println(SimpleCommerceDataSet.createRandomName());
        System.out.println(SimpleCommerceDataSet.createRandomName());
        Statement st = con.createStatement();
        try {
            st.executeUpdate(dropPersons);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            st.executeUpdate(dropProducts);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            st.executeUpdate(dropRelationships);
        }
        catch (Exception exception) {
            // empty catch block
        }
        st.executeUpdate(createPersons);
        st.executeUpdate(createProducts);
        st.executeUpdate(createRelationships);
        for (i = 0; i < nrOfPersons; ++i) {
            SimpleCommerceDataSet.loadPersons(st, i);
        }
        for (i = 0; i < nrOfProducts; ++i) {
            SimpleCommerceDataSet.loadProducts(st, i);
        }
        for (i = 0; i < nrOfRels; ++i) {
            SimpleCommerceDataSet.loadRelationships(st, i);
        }
        st.close();
    }

    private static void loadPersons(Statement st, int nr) throws SQLException {
        st.executeUpdate("insert into persons values (" + nr + ", '" + SimpleCommerceDataSet.createRandomName() + "', " + rng.nextInt(469946) + ")");
    }

    private static void loadProducts(Statement st, int nr) throws SQLException {
        st.executeUpdate("insert into products values (" + nr + ", '" + SimpleCommerceDataSet.createRandomName() + "', " + rng.nextInt(469946) + ")");
    }

    private static void loadRelationships(Statement st, int nr) throws SQLException {
        st.executeUpdate("insert into relationships values (" + nr + ", '" + SimpleCommerceDataSet.createRandomName() + "', " + rng.nextInt(469946) + ")");
    }

    private static String createRandomName() {
        return SimpleCommerceDataSet.createRandomString() + " " + SimpleCommerceDataSet.createRandomString();
    }

    private static String createRandomString() {
        int length = rng.nextInt(10);
        String characters = "ABCDEFGHIJ";
        char[] text = new char[length];
        for (int i = 0; i < length; ++i) {
            text[i] = "ABCDEFGHIJ".charAt(rng.nextInt("ABCDEFGHIJ".length()));
        }
        return new String(text);
    }
}

