/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.couchbase;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.couchbase.AbstractCouchbaseProcessor;
import org.apache.nifi.services.couchbase.CouchbaseClient;
import org.apache.nifi.services.couchbase.exception.CouchbaseException;
import org.apache.nifi.services.couchbase.utils.CouchbaseContext;
import org.apache.nifi.services.couchbase.utils.CouchbaseGetResult;

@Tags(value={"nosql", "couchbase", "database", "get"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Get a document from Couchbase Server. The ID of the document to fetch may be supplied by setting the <Document Id> property or reading it from the FlowFile content.")
@WritesAttributes(value={@WritesAttribute(attribute="couchbase.bucket", description="The bucket where the document is stored."), @WritesAttribute(attribute="couchbase.scope", description="The scope where the document is stored."), @WritesAttribute(attribute="couchbase.collection", description="The collection where the document is stored."), @WritesAttribute(attribute="couchbase.document.id", description="Id of the document."), @WritesAttribute(attribute="couchbase.document.cas", description="CAS of the document.")})
public class GetCouchbase
extends AbstractCouchbaseProcessor {
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        long startNanos = System.nanoTime();
        String documentId = context.getProperty(DOCUMENT_ID).evaluateAttributeExpressions(flowFile).getValue();
        CouchbaseContext couchbaseContext = this.getCouchbaseContext(context, flowFile);
        CouchbaseClient couchbaseClient = this.connectionService.getClient(couchbaseContext);
        try {
            if (StringUtils.isEmpty((CharSequence)documentId)) {
                throw new CouchbaseException("Document ID is missing. Please provide a valid Document ID through processor property or FlowFile content.");
            }
            CouchbaseGetResult result = couchbaseClient.getDocument(documentId);
            flowFile = session.write(flowFile, out -> out.write(result.resultContent()));
            Map<String, String> attributes = this.getFlowfileAttributes(couchbaseContext, documentId, String.valueOf(result.cas()));
            attributes.put(CoreAttributes.MIME_TYPE.key(), couchbaseContext.documentType().getMimeType());
            flowFile = session.putAllAttributes(flowFile, attributes);
            long fetchMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            session.getProvenanceReporter().fetch(flowFile, this.createTransitUri(this.connectionService.getServiceLocation(), couchbaseContext, documentId), fetchMillis);
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (CouchbaseException e) {
            this.handleCouchbaseException(couchbaseClient, context, session, this.getLogger(), flowFile, e, "Failed to get document from Couchbase");
        }
    }
}

