/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.couchbase;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.error.DocumentDoesNotExistException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.couchbase.AbstractCouchbaseLookupService;
import org.apache.nifi.couchbase.CouchbaseConfigurationProperties;
import org.apache.nifi.couchbase.CouchbaseUtils;
import org.apache.nifi.lookup.LookupFailureException;
import org.apache.nifi.lookup.StringLookupService;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.util.StringUtils;

@Tags(value={"lookup", "enrich", "key", "value", "couchbase"})
@CapabilityDescription(value="Lookup a string value from Couchbase Server associated with the specified key. The coordinates that are passed to the lookup must contain the key 'key'.")
public class CouchbaseKeyValueLookupService
extends AbstractCouchbaseLookupService
implements StringLookupService {
    private volatile String subDocPath;

    @Override
    protected void addProperties(List<PropertyDescriptor> properties) {
        properties.add(CouchbaseConfigurationProperties.LOOKUP_SUB_DOC_PATH);
    }

    @Override
    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws InitializationException {
        super.onEnabled(context);
        this.subDocPath = context.getProperty(CouchbaseConfigurationProperties.LOOKUP_SUB_DOC_PATH).evaluateAttributeExpressions().getValue();
    }

    public Optional<String> lookup(Map<String, Object> coordinates) throws LookupFailureException {
        try {
            Bucket bucket = this.couchbaseClusterService.openBucket(this.bucketName);
            Optional<String> docId = Optional.ofNullable(coordinates.get("key")).map(Object::toString);
            if (!StringUtils.isBlank((String)this.subDocPath)) {
                return docId.map(key -> {
                    try {
                        return bucket.lookupIn(key).get(new String[]{this.subDocPath}).execute();
                    }
                    catch (DocumentDoesNotExistException e) {
                        this.getLogger().debug("Document was not found for {}", new Object[]{key});
                        return null;
                    }
                }).map(fragment -> fragment.content(0)).map(Object::toString);
            }
            return docId.map(key -> CouchbaseUtils.getStringContent(bucket, key));
        }
        catch (CouchbaseException e) {
            throw new LookupFailureException("Failed to lookup from Couchbase using this coordinates: " + String.valueOf(coordinates));
        }
    }
}

