/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.couchbase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.couchbase.CouchbaseClusterControllerService;
import org.apache.nifi.couchbase.CouchbaseConfigurationProperties;
import org.apache.nifi.reporting.InitializationException;

public class AbstractCouchbaseLookupService
extends AbstractControllerService {
    protected static final String KEY = "key";
    protected static final Set<String> REQUIRED_KEYS = Collections.unmodifiableSet(Stream.of("key").collect(Collectors.toSet()));
    protected List<PropertyDescriptor> properties;
    protected volatile CouchbaseClusterControllerService couchbaseClusterService;
    protected volatile String bucketName;

    protected void init(ControllerServiceInitializationContext context) throws InitializationException {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(CouchbaseConfigurationProperties.COUCHBASE_CLUSTER_SERVICE);
        properties.add(CouchbaseConfigurationProperties.BUCKET_NAME);
        this.addProperties(properties);
        this.properties = Collections.unmodifiableList(properties);
    }

    protected void addProperties(List<PropertyDescriptor> properties) {
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws InitializationException {
        this.couchbaseClusterService = (CouchbaseClusterControllerService)context.getProperty(CouchbaseConfigurationProperties.COUCHBASE_CLUSTER_SERVICE).asControllerService(CouchbaseClusterControllerService.class);
        this.bucketName = context.getProperty(CouchbaseConfigurationProperties.BUCKET_NAME).evaluateAttributeExpressions().getValue();
    }

    public Set<String> getRequiredKeys() {
        return REQUIRED_KEYS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }
}

