/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.couchbase;

import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.document.BinaryDocument;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.error.CASMismatchException;
import com.couchbase.client.java.error.DocumentAlreadyExistsException;
import com.couchbase.client.java.error.DocumentDoesNotExistException;
import com.couchbase.client.java.query.Delete;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.N1qlQueryResult;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.dsl.functions.PatternMatchingFunctions;
import com.couchbase.client.java.query.dsl.path.MutateLimitPath;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.couchbase.CouchbaseClusterControllerService;
import org.apache.nifi.couchbase.CouchbaseConfigurationProperties;
import org.apache.nifi.distributed.cache.client.AtomicCacheEntry;
import org.apache.nifi.distributed.cache.client.AtomicDistributedMapCacheClient;
import org.apache.nifi.distributed.cache.client.Deserializer;
import org.apache.nifi.distributed.cache.client.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tags(value={"distributed", "cache", "map", "cluster", "couchbase"})
@CapabilityDescription(value="Provides the ability to communicate with a Couchbase Server cluster as a DistributedMapCacheServer. This can be used in order to share a Map between nodes in a NiFi cluster. Couchbase Server cluster can provide a high available and persistent cache storage.")
public class CouchbaseMapCacheClient
extends AbstractControllerService
implements AtomicDistributedMapCacheClient<Long> {
    private static final Logger logger = LoggerFactory.getLogger(CouchbaseMapCacheClient.class);
    private CouchbaseClusterControllerService clusterService;
    private Bucket bucket;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(CouchbaseConfigurationProperties.COUCHBASE_CLUSTER_SERVICE);
        descriptors.add(CouchbaseConfigurationProperties.BUCKET_NAME);
        return descriptors;
    }

    @OnEnabled
    public void configure(ConfigurationContext context) {
        this.clusterService = (CouchbaseClusterControllerService)context.getProperty(CouchbaseConfigurationProperties.COUCHBASE_CLUSTER_SERVICE).asControllerService(CouchbaseClusterControllerService.class);
        String bucketName = context.getProperty(CouchbaseConfigurationProperties.BUCKET_NAME).evaluateAttributeExpressions().getValue();
        this.bucket = this.clusterService.openBucket(bucketName);
    }

    private <V> Document toDocument(String docId, V value, Serializer<V> valueSerializer) throws IOException {
        return this.toDocument(docId, value, valueSerializer, 0L);
    }

    private <V> Document toDocument(String docId, V value, Serializer<V> valueSerializer, long revision) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        valueSerializer.serialize(value, (OutputStream)bos);
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])bos.toByteArray());
        return BinaryDocument.create((String)docId, (ByteBuf)byteBuf, (long)revision);
    }

    private <K> String toDocumentId(K key, Serializer<K> keySerializer) throws IOException {
        String docId;
        if (key instanceof String) {
            docId = (String)key;
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            keySerializer.serialize(key, (OutputStream)bos);
            byte[] keyBytes = bos.toByteArray();
            docId = new String(keyBytes);
        }
        return docId;
    }

    public <K, V> boolean putIfAbsent(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
        String docId = this.toDocumentId(key, keySerializer);
        Document doc = this.toDocument(docId, value, valueSerializer);
        try {
            this.bucket.insert(doc);
            return true;
        }
        catch (DocumentAlreadyExistsException e) {
            return false;
        }
    }

    public <K, V> AtomicCacheEntry<K, V, Long> fetch(K key, Serializer<K> keySerializer, Deserializer<V> valueDeserializer) throws IOException {
        String docId = this.toDocumentId(key, keySerializer);
        BinaryDocument doc = (BinaryDocument)this.bucket.get((Document)BinaryDocument.create((String)docId));
        if (doc == null) {
            return null;
        }
        V value = this.deserialize(doc, valueDeserializer);
        return new AtomicCacheEntry(key, value, (Object)doc.cas());
    }

    public <K, V> V getAndPutIfAbsent(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer, Deserializer<V> valueDeserializer) throws IOException {
        V existing = this.get(key, keySerializer, valueDeserializer);
        if (existing != null) {
            return existing;
        }
        if (!this.putIfAbsent(key, value, keySerializer, valueSerializer)) {
            return this.get(key, keySerializer, valueDeserializer);
        }
        return value;
    }

    public <K, V> boolean replace(AtomicCacheEntry<K, V, Long> entry, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
        Long revision = entry.getRevision().orElse(0L);
        String docId = this.toDocumentId(entry.getKey(), keySerializer);
        Document doc = this.toDocument(docId, entry.getValue(), valueSerializer, revision);
        try {
            if (revision < 0L) {
                try {
                    this.bucket.insert(doc);
                    return true;
                }
                catch (DocumentAlreadyExistsException e) {
                    return false;
                }
            }
            this.bucket.replace(doc);
            return true;
        }
        catch (CASMismatchException | DocumentDoesNotExistException e) {
            return false;
        }
    }

    public <K> boolean containsKey(K key, Serializer<K> keySerializer) throws IOException {
        return this.bucket.exists(this.toDocumentId(key, keySerializer));
    }

    public <K, V> void put(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
        String docId = this.toDocumentId(key, keySerializer);
        Document doc = this.toDocument(docId, value, valueSerializer);
        this.bucket.upsert(doc);
    }

    public <K, V> V get(K key, Serializer<K> keySerializer, Deserializer<V> valueDeserializer) throws IOException {
        String docId = this.toDocumentId(key, keySerializer);
        BinaryDocument doc = (BinaryDocument)this.bucket.get((Document)BinaryDocument.create((String)docId));
        return this.deserialize(doc, valueDeserializer);
    }

    private <V> V deserialize(BinaryDocument doc, Deserializer<V> valueDeserializer) throws IOException {
        if (doc == null) {
            return null;
        }
        ByteBuf byteBuf = (ByteBuf)doc.content();
        byte[] bytes = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(bytes);
        byteBuf.release();
        return (V)valueDeserializer.deserialize(bytes);
    }

    public void close() throws IOException {
    }

    public <K> boolean remove(K key, Serializer<K> serializer) throws IOException {
        try {
            this.bucket.remove(this.toDocumentId(key, serializer));
            return true;
        }
        catch (DocumentDoesNotExistException e) {
            return false;
        }
    }

    public long removeByPattern(String regex) throws IOException {
        MutateLimitPath statement = Delete.deleteFromCurrentBucket().where(PatternMatchingFunctions.regexpContains((String)"meta().id", (String)regex));
        N1qlQueryResult result = this.bucket.query((N1qlQuery)N1qlQuery.simple((Statement)statement));
        if (logger.isDebugEnabled()) {
            logger.debug("Deleted documents using regex {}, result={}", (Object)regex, (Object)result);
        }
        return result.info().mutationCount();
    }
}

