/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.confluent.schemaregistry;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

final class VarintUtils {
    private VarintUtils() {
    }

    static int readVarintFromStream(InputStream inputStream) throws IOException {
        int firstByte = inputStream.read();
        if (firstByte == -1) {
            throw new IOException("Unexpected end of stream while reading varint");
        }
        return VarintUtils.readVarintFromStreamAfterFirstByteConsumed(inputStream, firstByte);
    }

    static int readVarintFromStreamAfterFirstByteConsumed(InputStream inputStream, int firstByte) throws IOException {
        int value;
        block2: {
            value = 0;
            int shift = 0;
            int currentByte = firstByte;
            do {
                if (shift >= 32) {
                    throw new IOException("Varint too long (more than 32 bits)");
                }
                value |= (currentByte & 0x7F) << shift;
                if ((currentByte & 0x80) == 0) break block2;
                shift += 7;
            } while ((currentByte = inputStream.read()) != -1);
            throw new IOException("Unexpected end of stream while reading varint");
        }
        return value;
    }

    static int decodeZigZag(int encodedValue) {
        return encodedValue >>> 1 ^ -(encodedValue & 1);
    }

    static byte[] writeZigZagVarint(int value) {
        ByteArrayOutputStream output = new ByteArrayOutputStream(4);
        int encoded = value << 1 ^ value >> 31;
        while ((encoded & 0xFFFFFF80) != 0) {
            output.write(encoded & 0x7F | 0x80);
            encoded >>>= 7;
        }
        output.write(encoded & 0x7F);
        return output.toByteArray();
    }
}

