/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.confluent.schema;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.nifi.confluent.schema.ProtobufMessageSchema;
import org.apache.nifi.confluent.schema.ProtobufMessageSchemaParser;
import org.apache.nifi.confluent.schema.antlr.Protobuf3BaseVisitor;
import org.apache.nifi.confluent.schema.antlr.Protobuf3Lexer;
import org.apache.nifi.confluent.schema.antlr.Protobuf3Parser;

public class AntlrProtobufMessageSchemaParser
implements ProtobufMessageSchemaParser {
    public List<ProtobufMessageSchema> parse(String schemaText) {
        CodePointCharStream input = CharStreams.fromString((String)schemaText);
        Protobuf3Lexer lexer = new Protobuf3Lexer((CharStream)input);
        Protobuf3Parser parser = this.getProtobuf3Parser(lexer);
        Protobuf3Parser.ProtoContext tree = parser.proto();
        SchemaVisitor visitor = new SchemaVisitor();
        visitor.visit((ParseTree)tree);
        return visitor.getProtoMessages();
    }

    private Protobuf3Parser getProtobuf3Parser(Protobuf3Lexer lexer) {
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        Protobuf3Parser parser = new Protobuf3Parser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(this){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new RuntimeException(String.format("Syntax error at line %d, position %d: %s", line, charPositionInLine, msg), (Throwable)e);
            }
        });
        return parser;
    }

    private static class SchemaVisitor
    extends Protobuf3BaseVisitor<Void> {
        private final List<StandardProtobufMessageSchema> rootMessages = new ArrayList<StandardProtobufMessageSchema>();
        private final Deque<StandardProtobufMessageSchema> messageStack = new ArrayDeque<StandardProtobufMessageSchema>();
        private String currentPackage;

        private SchemaVisitor() {
        }

        @Override
        public Void visitPackageStatement(Protobuf3Parser.PackageStatementContext ctx) {
            if (ctx.fullIdent() != null) {
                this.currentPackage = ctx.fullIdent().getText();
            }
            return null;
        }

        @Override
        public Void visitMessageDef(Protobuf3Parser.MessageDefContext ctx) {
            String messageName = ctx.messageName().getText();
            StandardProtobufMessageSchema protobufMessageSchema = new StandardProtobufMessageSchema(messageName, Optional.ofNullable(this.currentPackage), new ArrayList<ProtobufMessageSchema>());
            if (this.messageStack.isEmpty()) {
                this.rootMessages.add(protobufMessageSchema);
            } else {
                StandardProtobufMessageSchema parent = this.messageStack.peek();
                parent.addChildMessage(protobufMessageSchema);
            }
            this.messageStack.push(protobufMessageSchema);
            super.visitMessageDef(ctx);
            this.messageStack.pop();
            return null;
        }

        public List<ProtobufMessageSchema> getProtoMessages() {
            return List.copyOf(this.rootMessages);
        }
    }

    private record StandardProtobufMessageSchema(String name, Optional<String> packageName, List<ProtobufMessageSchema> innerMessages) implements ProtobufMessageSchema
    {
        public String getName() {
            return this.name;
        }

        public Optional<String> getPackageName() {
            return this.packageName;
        }

        public List<ProtobufMessageSchema> getChildMessageSchemas() {
            return this.innerMessages;
        }

        public void addChildMessage(ProtobufMessageSchema childMessage) {
            this.innerMessages.add(childMessage);
        }
    }
}

