/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;

@XmlType(name="processorConfig")
public class ProcessorConfigDTO {
    private Map<String, String> properties;
    private Map<String, PropertyDescriptorDTO> descriptors;
    private Set<String> sensitiveDynamicPropertyNames;
    private String schedulingPeriod;
    private String schedulingStrategy;
    private String executionNode;
    private String penaltyDuration;
    private String yieldDuration;
    private String bulletinLevel;
    private Long runDurationMillis;
    private Integer concurrentlySchedulableTaskCount;
    private Set<String> autoTerminatedRelationships;
    private String comments;
    private String customUiUrl;
    private Boolean lossTolerant;
    private String annotationData;
    private Map<String, String> defaultConcurrentTasks;
    private Map<String, String> defaultSchedulingPeriod;
    private Integer retryCount;
    private Set<String> retriedRelationships;
    private String backoffMechanism;
    private String maxBackoffPeriod;

    @Schema(description="The frequency with which to schedule the processor. The format of the value will depend on th value of schedulingStrategy.")
    public String getSchedulingPeriod() {
        return this.schedulingPeriod;
    }

    public void setSchedulingPeriod(String setSchedulingPeriod) {
        this.schedulingPeriod = setSchedulingPeriod;
    }

    @Schema(description="Indicates how the processor should be scheduled to run.")
    public String getSchedulingStrategy() {
        return this.schedulingStrategy;
    }

    public void setSchedulingStrategy(String schedulingStrategy) {
        this.schedulingStrategy = schedulingStrategy;
    }

    @Schema(description="Indicates the node where the process will execute.")
    public String getExecutionNode() {
        return this.executionNode;
    }

    public void setExecutionNode(String executionNode) {
        this.executionNode = executionNode;
    }

    @Schema(description="The amount of time that is used when the process penalizes a flowfile.")
    public String getPenaltyDuration() {
        return this.penaltyDuration;
    }

    public void setPenaltyDuration(String penaltyDuration) {
        this.penaltyDuration = penaltyDuration;
    }

    @Schema(description="The amount of time that must elapse before this processor is scheduled again after yielding.")
    public String getYieldDuration() {
        return this.yieldDuration;
    }

    public void setYieldDuration(String yieldDuration) {
        this.yieldDuration = yieldDuration;
    }

    @Schema(description="The level at which the processor will report bulletins.")
    public String getBulletinLevel() {
        return this.bulletinLevel;
    }

    public void setBulletinLevel(String bulletinLevel) {
        this.bulletinLevel = bulletinLevel;
    }

    @Schema(description="The number of tasks that should be concurrently schedule for the processor. If the processor doesn't allow parallol processing then any positive input will be ignored.")
    public Integer getConcurrentlySchedulableTaskCount() {
        return this.concurrentlySchedulableTaskCount;
    }

    public void setConcurrentlySchedulableTaskCount(Integer concurrentlySchedulableTaskCount) {
        this.concurrentlySchedulableTaskCount = concurrentlySchedulableTaskCount;
    }

    @Schema(description="Whether the processor is loss tolerant.")
    public Boolean isLossTolerant() {
        return this.lossTolerant;
    }

    public void setLossTolerant(Boolean lossTolerant) {
        this.lossTolerant = lossTolerant;
    }

    @Schema(description="The comments for the processor.")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @Schema(description="The properties for the processor. Properties whose value is not set will only contain the property name.")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Schema(description="Descriptors for the processor's properties.")
    public Map<String, PropertyDescriptorDTO> getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(Map<String, PropertyDescriptorDTO> descriptors) {
        this.descriptors = descriptors;
    }

    @Schema(description="Set of sensitive dynamic property names")
    public Set<String> getSensitiveDynamicPropertyNames() {
        return this.sensitiveDynamicPropertyNames;
    }

    public void setSensitiveDynamicPropertyNames(Set<String> sensitiveDynamicPropertyNames) {
        this.sensitiveDynamicPropertyNames = sensitiveDynamicPropertyNames;
    }

    @Schema(description="The annotation data for the processor used to relay configuration between a custom UI and the procesosr.")
    public String getAnnotationData() {
        return this.annotationData;
    }

    public void setAnnotationData(String annotationData) {
        this.annotationData = annotationData;
    }

    @Schema(description="The URL for the processor's custom configuration UI if applicable.")
    public String getCustomUiUrl() {
        return this.customUiUrl;
    }

    public void setCustomUiUrl(String customUiUrl) {
        this.customUiUrl = customUiUrl;
    }

    @Schema(description="The names of all relationships that cause a flow file to be terminated if the relationship is not connected elsewhere. This property differs from the 'isAutoTerminate' property of the RelationshipDTO in that the RelationshipDTO is meant to depict the current configuration, whereas this property can be set in a DTO when updating a Processor in order to change which Relationships should be auto-terminated.")
    public Set<String> getAutoTerminatedRelationships() {
        return this.autoTerminatedRelationships;
    }

    public void setAutoTerminatedRelationships(Set<String> autoTerminatedRelationships) {
        this.autoTerminatedRelationships = autoTerminatedRelationships;
    }

    @Schema(description="Maps default values for concurrent tasks for each applicable scheduling strategy.")
    public Map<String, String> getDefaultConcurrentTasks() {
        return this.defaultConcurrentTasks;
    }

    public void setDefaultConcurrentTasks(Map<String, String> defaultConcurrentTasks) {
        this.defaultConcurrentTasks = defaultConcurrentTasks;
    }

    @Schema(description="The run duration for the processor in milliseconds.")
    public Long getRunDurationMillis() {
        return this.runDurationMillis;
    }

    public void setRunDurationMillis(Long runDurationMillis) {
        this.runDurationMillis = runDurationMillis;
    }

    @Schema(description="Maps default values for scheduling period for each applicable scheduling strategy.")
    public Map<String, String> getDefaultSchedulingPeriod() {
        return this.defaultSchedulingPeriod;
    }

    public void setDefaultSchedulingPeriod(Map<String, String> defaultSchedulingPeriod) {
        this.defaultSchedulingPeriod = defaultSchedulingPeriod;
    }

    @Schema(description="Overall number of retries.")
    public Integer getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
    }

    @Schema(description="All the relationships should be retried.")
    public Set<String> getRetriedRelationships() {
        return this.retriedRelationships;
    }

    public void setRetriedRelationships(Set<String> retriedRelationships) {
        this.retriedRelationships = retriedRelationships;
    }

    @Schema(description="Determines whether the FlowFile should be penalized or the processor should be yielded between retries.", allowableValues={"PENALIZE_FLOWFILE", "YIELD_PROCESSOR"})
    public String getBackoffMechanism() {
        return this.backoffMechanism;
    }

    public void setBackoffMechanism(String backoffMechanism) {
        this.backoffMechanism = backoffMechanism;
    }

    @Schema(description="Maximum amount of time to be waited during a retry period.")
    public String getMaxBackoffPeriod() {
        return this.maxBackoffPeriod;
    }

    public void setMaxBackoffPeriod(String maxBackoffPeriod) {
        this.maxBackoffPeriod = maxBackoffPeriod;
    }
}

