/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.cipher.age;

import com.exceptionfactory.jagged.RecipientStanzaReader;
import com.exceptionfactory.jagged.x25519.X25519RecipientStanzaReaderFactory;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.nifi.processors.cipher.age.AbstractAgeKeyReader;
import org.apache.nifi.processors.cipher.age.AgeKeyIndicator;

public class AgePrivateKeyReader
extends AbstractAgeKeyReader<RecipientStanzaReader> {
    public AgePrivateKeyReader() {
        super(AgeKeyIndicator.PRIVATE_KEY);
    }

    @Override
    protected List<RecipientStanzaReader> readKeys(Set<String> keys) throws IOException {
        ArrayList<RecipientStanzaReader> recipientStanzaReaders = new ArrayList<RecipientStanzaReader>();
        for (String encodedPrivateKey : keys) {
            try {
                RecipientStanzaReader recipientStanzaReader = this.getRecipientStanzaReader(encodedPrivateKey);
                recipientStanzaReaders.add(recipientStanzaReader);
            }
            catch (Exception e) {
                throw new IOException("Parsing Private Key Identities failed", e);
            }
        }
        return recipientStanzaReaders;
    }

    private RecipientStanzaReader getRecipientStanzaReader(String encodedPrivateKey) throws GeneralSecurityException {
        return X25519RecipientStanzaReaderFactory.newRecipientStanzaReader((CharSequence)encodedPrivateKey);
    }
}

