/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.mysql.processors;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.GtidSet;
import com.github.shyiko.mysql.binlog.event.DeleteRowsEventData;
import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.EventData;
import com.github.shyiko.mysql.binlog.event.EventHeaderV4;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.GtidEventData;
import com.github.shyiko.mysql.binlog.event.MySqlGtid;
import com.github.shyiko.mysql.binlog.event.QueryEventData;
import com.github.shyiko.mysql.binlog.event.RotateEventData;
import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.UpdateRowsEventData;
import com.github.shyiko.mysql.binlog.event.WriteRowsEventData;
import com.github.shyiko.mysql.binlog.network.SSLMode;
import com.github.shyiko.mysql.binlog.network.SSLSocketFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.PrimaryNodeOnly;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.annotation.notification.OnPrimaryNodeStateChange;
import org.apache.nifi.annotation.notification.PrimaryNodeState;
import org.apache.nifi.cdc.CDCException;
import org.apache.nifi.cdc.event.ColumnDefinition;
import org.apache.nifi.cdc.event.RowEventException;
import org.apache.nifi.cdc.event.TableInfo;
import org.apache.nifi.cdc.event.TableInfoCacheKey;
import org.apache.nifi.cdc.event.io.EventWriterConfiguration;
import org.apache.nifi.cdc.event.io.FlowFileEventWriteStrategy;
import org.apache.nifi.cdc.mysql.event.BinlogEventInfo;
import org.apache.nifi.cdc.mysql.event.BinlogEventListener;
import org.apache.nifi.cdc.mysql.event.BinlogLifecycleListener;
import org.apache.nifi.cdc.mysql.event.DataCaptureState;
import org.apache.nifi.cdc.mysql.event.RawBinlogEvent;
import org.apache.nifi.cdc.mysql.event.handler.BeginEventHandler;
import org.apache.nifi.cdc.mysql.event.handler.CommitEventHandler;
import org.apache.nifi.cdc.mysql.event.handler.DDLEventHandler;
import org.apache.nifi.cdc.mysql.event.handler.DeleteEventHandler;
import org.apache.nifi.cdc.mysql.event.handler.InsertEventHandler;
import org.apache.nifi.cdc.mysql.event.handler.UpdateEventHandler;
import org.apache.nifi.cdc.mysql.event.io.AbstractBinlogEventWriter;
import org.apache.nifi.cdc.mysql.processors.ssl.BinaryLogSSLSocketFactory;
import org.apache.nifi.cdc.mysql.processors.ssl.StandardConnectionPropertiesProvider;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.distributed.cache.client.DistributedMapCacheClient;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.ssl.SSLContextService;

@TriggerSerially
@PrimaryNodeOnly
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@Tags(value={"sql", "jdbc", "cdc", "mysql", "transaction", "event"})
@CapabilityDescription(value="Retrieves Change Data Capture (CDC) events from a MySQL database. CDC Events include INSERT, UPDATE, DELETE operations. Events are output as either a group of a specified number of events (the default is 1 so each event becomes its own flow file) or grouped as a full transaction (BEGIN to COMMIT). All events are ordered by the time at which the operation occurred. NOTE: If the processor is stopped before the specified number of events have been written to a flow file, the partial flow file will be output in order to maintain the consistency of the event stream.")
@Stateful(scopes={Scope.CLUSTER}, description="Information such as a 'pointer' to the current CDC event in the database is stored by this processor, such that it can continue from the same location if restarted.")
@WritesAttributes(value={@WritesAttribute(attribute="cdc.sequence.id", description="A sequence identifier (i.e. strictly increasing integer value) specifying the order of the CDC event flow file relative to the other event flow file(s)."), @WritesAttribute(attribute="cdc.event.type", description="A string indicating the type of CDC event that occurred, including (but not limited to) 'begin', 'insert', 'update', 'delete', 'ddl' and 'commit'."), @WritesAttribute(attribute="mime.type", description="The processor outputs flow file content in JSON format, and sets the mime.type attribute to application/json")})
@RequiresInstanceClassLoading
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.REFERENCE_REMOTE_RESOURCES, explanation="Database Driver Location can reference resources over HTTP")})
public class CaptureChangeMySQL
extends AbstractSessionFactoryProcessor {
    private static final int DO_NOT_SET = -1000;
    private static final int DEFAULT_MYSQL_PORT = 3306;
    private static final Pattern MULTI_COMMENT_PATTERN = Pattern.compile("/\\*.*?\\*/", 32);
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Successfully created FlowFile from SQL query result set.").build();
    protected static Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS);
    private static final AllowableValue SSL_MODE_DISABLED = new AllowableValue(SSLMode.DISABLED.toString(), SSLMode.DISABLED.toString(), "Connect without TLS");
    private static final AllowableValue SSL_MODE_PREFERRED = new AllowableValue(SSLMode.PREFERRED.toString(), SSLMode.PREFERRED.toString(), "Connect with TLS when server support enabled, otherwise connect without TLS");
    private static final AllowableValue SSL_MODE_REQUIRED = new AllowableValue(SSLMode.REQUIRED.toString(), SSLMode.REQUIRED.toString(), "Connect with TLS or fail when server support not enabled");
    private static final AllowableValue SSL_MODE_VERIFY_IDENTITY = new AllowableValue(SSLMode.VERIFY_IDENTITY.toString(), SSLMode.VERIFY_IDENTITY.toString(), "Connect with TLS or fail when server support not enabled. Verify server hostname matches presented X.509 certificate names or fail when not matched");
    public static final PropertyDescriptor DATABASE_NAME_PATTERN = new PropertyDescriptor.Builder().name("capture-change-mysql-db-name-pattern").displayName("Database/Schema Name Pattern").description("A regular expression (regex) for matching databases (or schemas, depending on your RDBMS' terminology) against the list of CDC events. The regex must match the database name as it is stored in the RDBMS. If the property is not set, the database name will not be used to filter the CDC events. NOTE: DDL events, even if they affect different databases, are associated with the database used by the session to execute the DDL. This means if a connection is made to one database, but the DDL is issued against another, then the connected database will be the one matched against the specified pattern.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor TABLE_NAME_PATTERN = new PropertyDescriptor.Builder().name("capture-change-mysql-name-pattern").displayName("Table Name Pattern").description("A regular expression (regex) for matching CDC events affecting matching tables. The regex must match the table name as it is stored in the database. If the property is not set, no events will be filtered based on table name.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor CONNECT_TIMEOUT = new PropertyDescriptor.Builder().name("capture-change-mysql-max-wait-time").displayName("Max Wait Time").description("The maximum amount of time allowed for a connection to be established, zero means there is effectively no limit.").defaultValue("30 seconds").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor HOSTS = new PropertyDescriptor.Builder().name("capture-change-mysql-hosts").displayName("MySQL Nodes").description("A list of hostname (and optional port) entries corresponding to nodes in a MySQL cluster. The entries should be comma separated using a colon (if the port is to be specified) such as host1:port,host2:port,....  For example mysql.myhost.com:3306. The port need not be specified, when omitted the default MySQL port value of 3306 will be used. This processor will attempt to connect to the hosts in the list in order. If one node goes down and failover is enabled for the cluster, then the processor will connect to the active node (assuming its node entry is specified in this property).").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor DRIVER_NAME = new PropertyDescriptor.Builder().name("capture-change-mysql-driver-class").displayName("MySQL Driver Class Name").description("The class name of the MySQL database driver class").defaultValue("com.mysql.jdbc.Driver").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor DRIVER_LOCATION = new PropertyDescriptor.Builder().name("capture-change-mysql-driver-locations").displayName("MySQL Driver Location(s)").description("Comma-separated list of files/folders and/or URLs containing the MySQL driver JAR and its dependencies (if any). For example '/var/tmp/mysql-connector-java-5.1.38-bin.jar'").required(false).identifiesExternalResource(ResourceCardinality.MULTIPLE, ResourceType.FILE, new ResourceType[]{ResourceType.DIRECTORY, ResourceType.URL}).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dynamicallyModifiesClasspath(true).build();
    public static final PropertyDescriptor USERNAME = new PropertyDescriptor.Builder().name("capture-change-mysql-username").displayName("Username").description("Username to access the MySQL cluster").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("capture-change-mysql-password").displayName("Password").description("Password to access the MySQL cluster").required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor EVENTS_PER_FLOWFILE_STRATEGY = new PropertyDescriptor.Builder().name("events-per-flowfile-strategy").displayName("Event Processing Strategy").description("Specifies the strategy to use when writing events to FlowFile(s), such as '" + FlowFileEventWriteStrategy.MAX_EVENTS_PER_FLOWFILE.getDisplayName() + "'").required(true).sensitive(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).allowableValues(FlowFileEventWriteStrategy.class).defaultValue((DescribedValue)FlowFileEventWriteStrategy.MAX_EVENTS_PER_FLOWFILE).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final PropertyDescriptor NUMBER_OF_EVENTS_PER_FLOWFILE = new PropertyDescriptor.Builder().name("number-of-events-per-flowfile").displayName("Events Per FlowFile").description("Specifies how many events should be written to a single FlowFile. If the processor is stopped before the specified number of events has been written,the events will still be written as a FlowFile before stopping.").required(true).sensitive(false).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("1").expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dependsOn(EVENTS_PER_FLOWFILE_STRATEGY, (DescribedValue)FlowFileEventWriteStrategy.MAX_EVENTS_PER_FLOWFILE, new DescribedValue[0]).build();
    public static final PropertyDescriptor SERVER_ID = new PropertyDescriptor.Builder().name("capture-change-mysql-server-id").displayName("Server ID").description("The client connecting to the MySQL replication group is actually a simplified replica (server), and the Server ID value must be unique across the whole replication group (i.e. different from any other Server ID being used by any primary or replica). Thus, each instance of CaptureChangeMySQL must have a Server ID unique across the replication group. If the Server ID is not specified, it defaults to 65535.").required(false).addValidator(StandardValidators.POSITIVE_LONG_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor DIST_CACHE_CLIENT = new PropertyDescriptor.Builder().name("capture-change-mysql-dist-map-cache-client").displayName("Distributed Map Cache Client - unused").description("This is a legacy property that is no longer used to store table information, the processor will handle the table information (column names, types, etc.)").identifiesControllerService(DistributedMapCacheClient.class).required(false).build();
    public static final PropertyDescriptor RETRIEVE_ALL_RECORDS = new PropertyDescriptor.Builder().name("capture-change-mysql-retrieve-all-records").displayName("Retrieve All Records").description("Specifies whether to get all available CDC events, regardless of the current binlog filename and/or position. If binlog filename and position values are present in the processor's State, this property's value is ignored. This allows for 4 different configurations: 1) If binlog data is available in processor State, that is used to determine the start location and the value of Retrieve All Records is ignored. 2) If no binlog data is in processor State, then Retrieve All Records set to true means start at the beginning of the binlog history. 3) If no binlog data is in processor State and Initial Binlog Filename/Position are not set, then Retrieve All Records set to false means start at the end of the binlog history. 4) If no binlog data is in processor State and Initial Binlog Filename/Position are set, then Retrieve All Records set to false means start at the specified initial binlog file/position. To reset the behavior, clear the processor state (refer to the State Management section of the processor's documentation).").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor INCLUDE_BEGIN_COMMIT = new PropertyDescriptor.Builder().name("capture-change-mysql-include-begin-commit").displayName("Include Begin/Commit Events").description("Specifies whether to emit events corresponding to a BEGIN or COMMIT event in the binary log. Set to true if the BEGIN/COMMIT events are necessary in the downstream flow, otherwise set to false, which suppresses generation of these events and can increase flow performance.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor INCLUDE_DDL_EVENTS = new PropertyDescriptor.Builder().name("capture-change-mysql-include-ddl-events").displayName("Include DDL Events").description("Specifies whether to emit events corresponding to Data Definition Language (DDL) events such as ALTER TABLE, TRUNCATE TABLE, e.g. in the binary log. Set to true if the DDL events are desired/necessary in the downstream flow, otherwise set to false, which suppresses generation of these events and can increase flow performance.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor INIT_SEQUENCE_ID = new PropertyDescriptor.Builder().name("capture-change-mysql-init-seq-id").displayName("Initial Sequence ID").description("Specifies an initial sequence identifier to use if this processor's State does not have a current sequence identifier. If a sequence identifier is present in the processor's State, this property is ignored. Sequence identifiers are monotonically increasing integers that record the order of flow files generated by the processor. They can be used with the EnforceOrder processor to guarantee ordered delivery of CDC events.").required(false).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor INIT_BINLOG_FILENAME = new PropertyDescriptor.Builder().name("capture-change-mysql-init-binlog-filename").displayName("Initial Binlog Filename").description("Specifies an initial binlog filename to use if this processor's State does not have a current binlog filename. If a filename is present in the processor's State or \"Use GTID\" property is set to false, this property is ignored. This can be used along with Initial Binlog Position to \"skip ahead\" if previous events are not desired. Note that NiFi Expression Language is supported, but this property is evaluated when the processor is configured, so FlowFile attributes may not be used. Expression Language is supported to enable the use of the environment properties.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor INIT_BINLOG_POSITION = new PropertyDescriptor.Builder().name("capture-change-mysql-init-binlog-position").displayName("Initial Binlog Position").description("Specifies an initial offset into a binlog (specified by Initial Binlog Filename) to use if this processor's State does not have a current binlog filename. If a filename is present in the processor's State or \"Use GTID\" property is false, this property is ignored. This can be used along with Initial Binlog Filename to \"skip ahead\" if previous events are not desired. Note that NiFi Expression Language is supported, but this property is evaluated when the processor is configured, so FlowFile attributes may not be used. Expression Language is supported to enable the use of the environment properties.").required(false).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor USE_BINLOG_GTID = new PropertyDescriptor.Builder().name("capture-change-mysql-use-gtid").displayName("Use Binlog GTID").description("Specifies whether to use Global Transaction ID (GTID) for binlog tracking. If set to true, processor's state of binlog file name and position is ignored. The main benefit of using GTID is to have much reliable failover than using binlog filename/position.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor INIT_BINLOG_GTID = new PropertyDescriptor.Builder().name("capture-change-mysql-init-gtid").displayName("Initial Binlog GTID").description("Specifies an initial GTID to use if this processor's State does not have a current GTID. If a GTID is present in the processor's State or \"Use GTID\" property is set to false, this property is ignored. This can be used to \"skip ahead\" if previous events are not desired. Note that NiFi Expression Language is supported, but this property is evaluated when the processor is configured, so FlowFile attributes may not be used. Expression Language is supported to enable the use of the environment properties.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor SSL_MODE = new PropertyDescriptor.Builder().name("SSL Mode").displayName("SSL Mode").description("SSL Mode used when SSL Context Service configured supporting certificate verification options").required(true).defaultValue((DescribedValue)SSL_MODE_DISABLED).allowableValues(new DescribedValue[]{SSL_MODE_DISABLED, SSL_MODE_PREFERRED, SSL_MODE_REQUIRED, SSL_MODE_VERIFY_IDENTITY}).build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").displayName("SSL Context Service").description("SSL Context Service supporting encrypted socket communication").required(false).identifiesControllerService(SSLContextService.class).dependsOn(SSL_MODE, new AllowableValue[]{SSL_MODE_PREFERRED, SSL_MODE_REQUIRED, SSL_MODE_VERIFY_IDENTITY}).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(HOSTS, DRIVER_NAME, DRIVER_LOCATION, USERNAME, PASSWORD, EVENTS_PER_FLOWFILE_STRATEGY, NUMBER_OF_EVENTS_PER_FLOWFILE, SERVER_ID, DATABASE_NAME_PATTERN, TABLE_NAME_PATTERN, CONNECT_TIMEOUT, DIST_CACHE_CLIENT, RETRIEVE_ALL_RECORDS, INCLUDE_BEGIN_COMMIT, INCLUDE_DDL_EVENTS, INIT_SEQUENCE_ID, INIT_BINLOG_FILENAME, INIT_BINLOG_POSITION, USE_BINLOG_GTID, INIT_BINLOG_GTID, SSL_MODE, SSL_CONTEXT_SERVICE);
    private volatile BinaryLogClient binlogClient;
    private volatile BinlogEventListener eventListener;
    private volatile BinlogLifecycleListener lifecycleListener;
    private volatile GtidSet gtidSet;
    private final BlockingQueue<RawBinlogEvent> queue = new LinkedBlockingQueue<RawBinlogEvent>(1000);
    private final Map<TableInfoCacheKey, TableInfo> tableInfoCache = new HashMap<TableInfoCacheKey, TableInfo>();
    private volatile ProcessSession currentSession;
    private DataCaptureState currentDataCaptureState = new DataCaptureState();
    private volatile BinlogResourceInfo binlogResourceInfo = new BinlogResourceInfo();
    private volatile Pattern databaseNamePattern;
    private volatile Pattern tableNamePattern;
    private volatile boolean skipTable = false;
    private int currentHost = 0;
    private volatile JDBCConnectionHolder jdbcConnectionHolder = null;
    private final BinlogEventState binlogEventState = new BinlogEventState();
    private final BeginEventHandler beginEventHandler = new BeginEventHandler();
    private final CommitEventHandler commitEventHandler = new CommitEventHandler();
    private final DDLEventHandler ddlEventHandler = new DDLEventHandler();
    private final InsertEventHandler insertEventHandler = new InsertEventHandler();
    private final DeleteEventHandler deleteEventHandler = new DeleteEventHandler();
    private final UpdateEventHandler updateEventHandler = new UpdateEventHandler();
    private volatile EventWriterConfiguration eventWriterConfiguration;

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.removeProperty("capture-change-mysql-state-update-interval");
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        Map properties = validationContext.getProperties();
        String sslContextServiceProperty = (String)properties.get(SSL_CONTEXT_SERVICE);
        String sslModeProperty = (String)properties.get(SSL_MODE);
        if (StringUtils.isBlank((CharSequence)sslModeProperty) || SSLMode.DISABLED.toString().equals(sslModeProperty)) {
            results.add(new ValidationResult.Builder().subject(SSL_MODE.getDisplayName()).valid(true).build());
        } else if (StringUtils.isBlank((CharSequence)sslContextServiceProperty)) {
            String explanation = String.format("SSL Context Service is required for SSL Mode [%s]", sslModeProperty);
            results.add(new ValidationResult.Builder().subject(SSL_CONTEXT_SERVICE.getDisplayName()).valid(false).explanation(explanation).build());
        }
        return results;
    }

    @OnPrimaryNodeStateChange
    public synchronized void onPrimaryNodeChange(PrimaryNodeState state) throws CDCException {
        if (state == PrimaryNodeState.PRIMARY_NODE_REVOKED) {
            this.stop();
        }
    }

    public void setup(ProcessContext context) {
        StateMap stateMap;
        ComponentLog logger = this.getLogger();
        StateManager stateManager = context.getStateManager();
        try {
            stateMap = stateManager.getState(Scope.CLUSTER);
        }
        catch (IOException ioe) {
            logger.error("Failed to retrieve observed maximum values from the State Manager. Will not attempt connection until this is accomplished.", (Throwable)ioe);
            context.yield();
            return;
        }
        this.binlogResourceInfo.setInTransaction("true".equals(stateMap.get("inTransaction")));
        FlowFileEventWriteStrategy flowFileEventWriteStrategy = (FlowFileEventWriteStrategy)context.getProperty(EVENTS_PER_FLOWFILE_STRATEGY).asAllowableValue(FlowFileEventWriteStrategy.class);
        int numberOfEventsPerFlowFile = flowFileEventWriteStrategy == FlowFileEventWriteStrategy.MAX_EVENTS_PER_FLOWFILE ? context.getProperty(NUMBER_OF_EVENTS_PER_FLOWFILE).evaluateAttributeExpressions().asInteger() : 1;
        this.eventWriterConfiguration = new EventWriterConfiguration(flowFileEventWriteStrategy, numberOfEventsPerFlowFile);
        PropertyValue dbNameValue = context.getProperty(DATABASE_NAME_PATTERN);
        this.databaseNamePattern = dbNameValue.isSet() ? Pattern.compile(dbNameValue.getValue()) : null;
        PropertyValue tableNameValue = context.getProperty(TABLE_NAME_PATTERN);
        this.tableNamePattern = tableNameValue.isSet() ? Pattern.compile(tableNameValue.getValue()) : null;
        boolean getAllRecords = context.getProperty(RETRIEVE_ALL_RECORDS).asBoolean();
        if (this.binlogResourceInfo == null) {
            this.binlogResourceInfo = new BinlogResourceInfo();
        }
        this.currentDataCaptureState.setUseGtid(context.getProperty(USE_BINLOG_GTID).asBoolean());
        if (this.currentDataCaptureState.isUseGtid()) {
            this.currentDataCaptureState.setGtidSet(stateMap.get("binlog.gtidset"));
            if (this.currentDataCaptureState.getGtidSet() == null) {
                if (!getAllRecords && context.getProperty(INIT_BINLOG_GTID).isSet()) {
                    this.currentDataCaptureState.setGtidSet(context.getProperty(INIT_BINLOG_GTID).evaluateAttributeExpressions().getValue());
                } else {
                    this.currentDataCaptureState.setGtidSet("");
                }
            }
            this.currentDataCaptureState.setBinlogFile("");
            this.currentDataCaptureState.setBinlogPosition(-1000L);
        } else {
            String binlogPosition;
            String currentBinlogFile = stateMap.get("binlog.filename");
            if (currentBinlogFile == null) {
                if (!getAllRecords) {
                    if (context.getProperty(INIT_BINLOG_FILENAME).isSet()) {
                        this.currentDataCaptureState.setBinlogFile(context.getProperty(INIT_BINLOG_FILENAME).evaluateAttributeExpressions().getValue());
                    }
                } else {
                    this.currentDataCaptureState.setBinlogFile("");
                }
            } else {
                this.currentDataCaptureState.setBinlogFile(currentBinlogFile);
            }
            if ((binlogPosition = stateMap.get("binlog.position")) != null) {
                this.currentDataCaptureState.setBinlogPosition(Long.parseLong(binlogPosition));
            } else if (!getAllRecords) {
                if (context.getProperty(INIT_BINLOG_POSITION).isSet()) {
                    this.currentDataCaptureState.setBinlogPosition(context.getProperty(INIT_BINLOG_POSITION).evaluateAttributeExpressions().asLong());
                } else {
                    this.currentDataCaptureState.setBinlogPosition(-1000L);
                }
            } else {
                this.currentDataCaptureState.setBinlogPosition(-1L);
            }
        }
        String seqIdString = stateMap.get("cdc.sequence.id");
        if (StringUtils.isEmpty((CharSequence)seqIdString)) {
            PropertyValue seqIdProp = context.getProperty(INIT_SEQUENCE_ID);
            if (seqIdProp.isSet()) {
                this.currentDataCaptureState.setSequenceId(seqIdProp.evaluateAttributeExpressions().asInteger().intValue());
            }
        } else {
            this.currentDataCaptureState.setSequenceId(Long.parseLong(seqIdString));
        }
        SSLMode sslMode = SSLMode.valueOf((String)context.getProperty(SSL_MODE).getValue());
        SSLContextService sslContextService = sslMode == SSLMode.DISABLED ? null : (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        try {
            List<InetSocketAddress> hosts = this.getHosts(context.getProperty(HOSTS).evaluateAttributeExpressions().getValue());
            String username = context.getProperty(USERNAME).evaluateAttributeExpressions().getValue();
            String password = context.getProperty(PASSWORD).evaluateAttributeExpressions().getValue();
            if (password == null) {
                password = "";
            }
            long connectTimeout = context.getProperty(CONNECT_TIMEOUT).evaluateAttributeExpressions().asTimePeriod(TimeUnit.MILLISECONDS);
            String driverLocation = context.getProperty(DRIVER_LOCATION).evaluateAttributeExpressions().getValue();
            String driverName = context.getProperty(DRIVER_NAME).evaluateAttributeExpressions().getValue();
            Long serverId = context.getProperty(SERVER_ID).evaluateAttributeExpressions().asLong();
            this.connect(hosts, username, password, serverId, driverLocation, driverName, connectTimeout, sslContextService, sslMode);
        }
        catch (IOException | IllegalStateException e) {
            if (this.eventListener != null) {
                this.eventListener.stop();
                if (this.binlogClient != null) {
                    this.binlogClient.unregisterEventListener((BinaryLogClient.EventListener)this.eventListener);
                }
            }
            context.yield();
            this.binlogClient = null;
            throw new ProcessException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        ComponentLog log = this.getLogger();
        if (this.binlogClient == null) {
            this.setup(context);
        }
        if (this.binlogClient == null) {
            return;
        }
        if (!this.binlogClient.isConnected()) {
            Exception e = this.lifecycleListener.getException();
            if (e != null) {
                log.error("Binlog connector communications failure", (Throwable)e);
                try {
                    this.stop();
                }
                catch (CDCException ioe) {
                    throw new ProcessException((Throwable)ioe);
                }
            }
            context.yield();
            return;
        }
        if (this.currentSession == null) {
            this.currentSession = sessionFactory.createSession();
        }
        try {
            this.outputEvents(this.currentSession, context, log);
        }
        catch (Exception eventException) {
            this.getLogger().error("Exception during event processing at file={} pos={}", new Object[]{this.currentDataCaptureState.getBinlogFile(), this.currentDataCaptureState.getBinlogPosition(), eventException});
            try {
                this.binlogResourceInfo.setInTransaction(false);
                this.stop();
            }
            catch (Exception e) {
                log.error("Error stopping CDC client", (Throwable)e);
            }
            finally {
                this.queue.clear();
                this.currentSession.rollback();
            }
            context.yield();
        }
    }

    private List<InetSocketAddress> getHosts(String hostsString) {
        if (hostsString == null) {
            return null;
        }
        String[] hostsSplit = hostsString.split(",");
        ArrayList<InetSocketAddress> hostsList = new ArrayList<InetSocketAddress>();
        for (String item : hostsSplit) {
            String[] addresses = item.split(":");
            if (addresses.length > 2 || addresses.length == 0) {
                throw new ArrayIndexOutOfBoundsException("Not in host:port format");
            }
            if (addresses.length > 1) {
                hostsList.add(new InetSocketAddress(addresses[0].trim(), Integer.parseInt(addresses[1].trim())));
                continue;
            }
            hostsList.add(new InetSocketAddress(addresses[0].trim(), 3306));
        }
        return hostsList;
    }

    protected void connect(List<InetSocketAddress> hosts, String username, String password, Long serverId, String driverLocation, String driverName, long connectTimeout, SSLContextService sslContextService, SSLMode sslMode) throws IOException {
        int connectionAttempts = 0;
        int numHosts = hosts.size();
        InetSocketAddress connectedHost = null;
        Exception lastConnectException = new Exception("Unknown connection error");
        try {
            this.registerDriver(driverLocation, driverName);
        }
        catch (InitializationException e) {
            throw new RuntimeException("Failed to register JDBC driver. Ensure MySQL Driver Location(s) and MySQL Driver Class Name are configured correctly. " + String.valueOf((Object)e), e);
        }
        while (connectedHost == null && connectionAttempts < numHosts) {
            if (this.binlogClient == null) {
                connectedHost = hosts.get(this.currentHost);
                this.binlogClient = this.createBinlogClient(connectedHost.getHostString(), connectedHost.getPort(), username, password);
            }
            if (this.eventListener == null) {
                this.eventListener = this.createBinlogEventListener(this.binlogClient, this.queue);
            }
            this.eventListener.start();
            this.binlogClient.registerEventListener((BinaryLogClient.EventListener)this.eventListener);
            if (this.lifecycleListener == null) {
                this.lifecycleListener = this.createBinlogLifecycleListener();
            }
            this.binlogClient.registerLifecycleListener((BinaryLogClient.LifecycleListener)this.lifecycleListener);
            this.binlogClient.setBinlogFilename(this.currentDataCaptureState.getBinlogFile());
            if (this.currentDataCaptureState.getBinlogPosition() != -1000L) {
                this.binlogClient.setBinlogPosition(this.currentDataCaptureState.getBinlogPosition());
            }
            this.binlogClient.setGtidSet(this.currentDataCaptureState.getGtidSet());
            this.binlogClient.setGtidSetFallbackToPurged(true);
            if (serverId != null) {
                this.binlogClient.setServerId(serverId.longValue());
            }
            this.binlogClient.setSSLMode(sslMode);
            if (sslContextService != null) {
                SSLContext sslContext = sslContextService.createContext();
                BinaryLogSSLSocketFactory sslSocketFactory = new BinaryLogSSLSocketFactory(sslContext.getSocketFactory());
                this.binlogClient.setSslSocketFactory((SSLSocketFactory)sslSocketFactory);
            }
            try {
                if (connectTimeout == 0L) {
                    connectTimeout = Long.MAX_VALUE;
                }
                this.binlogClient.connect(connectTimeout);
                this.binlogResourceInfo.setTransitUri("mysql://" + connectedHost.getHostString() + ":" + connectedHost.getPort());
            }
            catch (IOException | TimeoutException te) {
                connectedHost = null;
                this.binlogResourceInfo.setTransitUri("<unknown>");
                this.currentHost = (this.currentHost + 1) % numHosts;
                ++connectionAttempts;
                lastConnectException = te;
            }
        }
        if (!this.binlogClient.isConnected()) {
            if (this.eventListener != null) {
                this.eventListener.stop();
                if (this.binlogClient != null) {
                    this.binlogClient.unregisterEventListener((BinaryLogClient.EventListener)this.eventListener);
                }
            }
            this.binlogClient.disconnect();
            this.binlogClient = null;
            throw new IOException("Could not connect binlog client to any of the specified hosts due to: " + lastConnectException.getMessage(), lastConnectException);
        }
        TlsConfiguration tlsConfiguration = sslContextService == null ? null : sslContextService.createTlsConfiguration();
        StandardConnectionPropertiesProvider connectionPropertiesProvider = new StandardConnectionPropertiesProvider(sslMode, tlsConfiguration);
        Map<String, String> jdbcConnectionProperties = connectionPropertiesProvider.getConnectionProperties();
        this.jdbcConnectionHolder = new JDBCConnectionHolder(connectedHost, username, password, jdbcConnectionProperties, connectTimeout);
        try {
            this.getJdbcConnection();
        }
        catch (SQLException e) {
            this.getLogger().error("Error creating binlog enrichment JDBC connection to any of the specified hosts", (Throwable)e);
            if (this.eventListener != null) {
                this.eventListener.stop();
                if (this.binlogClient != null) {
                    this.binlogClient.unregisterEventListener((BinaryLogClient.EventListener)this.eventListener);
                }
            }
            if (this.binlogClient != null) {
                this.binlogClient.disconnect();
                this.binlogClient = null;
            }
            return;
        }
        this.gtidSet = new GtidSet(this.binlogClient.getGtidSet());
    }

    public void outputEvents(ProcessSession session, ProcessContext context, ComponentLog log) throws IOException {
        RawBinlogEvent rawBinlogEvent;
        DataCaptureState dataCaptureState = this.currentDataCaptureState.copy();
        boolean includeBeginCommit = context.getProperty(INCLUDE_BEGIN_COMMIT).asBoolean();
        boolean includeDDLEvents = context.getProperty(INCLUDE_DDL_EVENTS).asBoolean();
        while (this.isScheduled() && (rawBinlogEvent = (RawBinlogEvent)this.queue.poll()) != null) {
            Event event = rawBinlogEvent.getEvent();
            EventHeaderV4 header = (EventHeaderV4)event.getHeader();
            long timestamp = header.getTimestamp();
            EventType eventType = header.getEventType();
            if (eventType != EventType.ROTATE && eventType != EventType.FORMAT_DESCRIPTION && !this.currentDataCaptureState.isUseGtid()) {
                dataCaptureState.setBinlogPosition(header.getPosition());
            }
            log.debug("Message event, type={} pos={} file={}", new Object[]{eventType, dataCaptureState.getBinlogPosition(), dataCaptureState.getBinlogFile()});
            switch (eventType) {
                case TABLE_MAP: {
                    TableMapEventData data = (TableMapEventData)event.getData();
                    boolean bl = this.skipTable = this.databaseNamePattern != null && !this.databaseNamePattern.matcher(data.getDatabase()).matches() || this.tableNamePattern != null && !this.tableNamePattern.matcher(data.getTable()).matches();
                    if (!this.skipTable) {
                        TableInfoCacheKey key = new TableInfoCacheKey(this.getIdentifier(), data.getDatabase(), data.getTable(), data.getTableId());
                        this.binlogResourceInfo.setCurrentTable(this.tableInfoCache.get(key));
                        if (this.binlogResourceInfo.getCurrentTable() != null) break;
                        try {
                            this.binlogResourceInfo.setCurrentTable(this.loadTableInfo(key));
                            this.tableInfoCache.put(key, this.binlogResourceInfo.getCurrentTable());
                            break;
                        }
                        catch (SQLException se) {
                            throw new IOException(se.getMessage(), se);
                        }
                    }
                    this.binlogResourceInfo.setCurrentTable(null);
                    break;
                }
                case QUERY: {
                    FlowFile flowFile;
                    QueryEventData queryEventData = (QueryEventData)event.getData();
                    this.binlogResourceInfo.setCurrentDatabase(queryEventData.getDatabase());
                    String sql = queryEventData.getSql();
                    if ("BEGIN".equals(sql)) {
                        if (this.binlogResourceInfo.isInTransaction()) {
                            this.getLogger().debug("BEGIN event received at pos={} file={} while already processing a transaction. This could indicate that your binlog position is invalid or the event stream is out of sync or there was an issue with the processor state.", new Object[]{dataCaptureState.getBinlogPosition(), dataCaptureState.getBinlogFile()});
                        }
                        if (this.databaseNamePattern == null || this.databaseNamePattern.matcher(this.binlogResourceInfo.getCurrentDatabase()).matches()) {
                            this.beginEventHandler.handleEvent(queryEventData, includeBeginCommit, this.currentDataCaptureState, this.binlogResourceInfo, this.binlogEventState, sql, this.eventWriterConfiguration, this.currentSession, timestamp);
                        }
                        this.binlogResourceInfo.setInTransaction(true);
                        this.updateState(session, dataCaptureState);
                        break;
                    }
                    if ("COMMIT".equals(sql)) {
                        if (!this.binlogResourceInfo.isInTransaction()) {
                            this.getLogger().debug("COMMIT event received at pos={} file={} while not processing a transaction (i.e. no corresponding BEGIN event). This could indicate that your binlog position is invalid or the event stream is out of sync or there was an issue with the processor state or there was an issue with the processor state.", new Object[]{dataCaptureState.getBinlogPosition(), dataCaptureState.getBinlogFile()});
                        }
                        if (this.databaseNamePattern == null || this.databaseNamePattern.matcher(this.binlogResourceInfo.getCurrentDatabase()).matches()) {
                            this.commitEventHandler.handleEvent((EventData)queryEventData, includeBeginCommit, this.currentDataCaptureState, this.binlogResourceInfo, this.binlogEventState, sql, this.eventWriterConfiguration, this.currentSession, timestamp);
                        }
                        this.binlogResourceInfo.setInTransaction(false);
                        this.updateState(session, dataCaptureState);
                        if (this.eventWriterConfiguration.getCurrentFlowFile() == null) {
                            session.commitAsync();
                        }
                        this.binlogResourceInfo.setCurrentTable(null);
                        this.binlogResourceInfo.setCurrentDatabase(null);
                        break;
                    }
                    String normalizedQuery = this.normalizeQuery(sql);
                    if (!this.isQueryDDL(normalizedQuery)) break;
                    if (this.databaseNamePattern == null || this.databaseNamePattern.matcher(this.binlogResourceInfo.getCurrentDatabase()).matches()) {
                        if (queryEventData.getDatabase() == null) {
                            queryEventData.setDatabase(this.binlogResourceInfo.getCurrentDatabase());
                        }
                        this.ddlEventHandler.handleEvent(queryEventData, includeDDLEvents, this.currentDataCaptureState, this.binlogResourceInfo, this.binlogEventState, sql, this.eventWriterConfiguration, this.currentSession, timestamp);
                        this.tableInfoCache.clear();
                    }
                    if (!includeDDLEvents || this.binlogResourceInfo.isInTransaction()) break;
                    this.updateState(session, dataCaptureState);
                    if (FlowFileEventWriteStrategy.ONE_TRANSACTION_PER_FLOWFILE.equals((Object)this.eventWriterConfiguration.getFlowFileEventWriteStrategy()) && this.currentSession != null && (flowFile = this.eventWriterConfiguration.getCurrentFlowFile()) != null && this.binlogEventState.getCurrentEventWriter() != null) {
                        this.binlogEventState.getCurrentEventWriter().finishAndTransferFlowFile(this.currentSession, this.eventWriterConfiguration, this.binlogResourceInfo.getTransitUri(), dataCaptureState.getSequenceId(), this.binlogEventState.getCurrentEventInfo(), REL_SUCCESS);
                    }
                    if (this.eventWriterConfiguration.getCurrentFlowFile() != null) break;
                    session.commitAsync();
                    break;
                }
                case XID: {
                    if (!this.binlogResourceInfo.isInTransaction()) {
                        this.getLogger().debug("COMMIT (XID) event received at pos={} file={} /while not processing a transaction (i.e. no corresponding BEGIN event). This could indicate that your binlog position is invalid or the event stream is out of sync or there was an issue with the processor state.", new Object[]{dataCaptureState.getBinlogPosition(), dataCaptureState.getBinlogFile()});
                    }
                    if (this.databaseNamePattern == null || this.databaseNamePattern.matcher(this.binlogResourceInfo.getCurrentDatabase()).matches()) {
                        this.commitEventHandler.handleEvent(event.getData(), includeBeginCommit, this.currentDataCaptureState, this.binlogResourceInfo, this.binlogEventState, (String)null, this.eventWriterConfiguration, this.currentSession, timestamp);
                    }
                    this.binlogResourceInfo.setInTransaction(false);
                    dataCaptureState.setBinlogPosition(header.getNextPosition());
                    this.updateState(session, dataCaptureState);
                    if (this.eventWriterConfiguration.getCurrentFlowFile() == null) {
                        session.commitAsync();
                    }
                    this.binlogResourceInfo.setCurrentTable(null);
                    this.binlogResourceInfo.setCurrentDatabase(null);
                    break;
                }
                case WRITE_ROWS: 
                case EXT_WRITE_ROWS: 
                case PRE_GA_WRITE_ROWS: 
                case UPDATE_ROWS: 
                case EXT_UPDATE_ROWS: 
                case PRE_GA_UPDATE_ROWS: 
                case DELETE_ROWS: 
                case EXT_DELETE_ROWS: 
                case PRE_GA_DELETE_ROWS: {
                    if (this.skipTable) break;
                    if (!this.binlogResourceInfo.isInTransaction()) {
                        log.info("Event {} occurred outside of a transaction, which is unexpected.", new Object[]{eventType.name()});
                    }
                    if (this.binlogResourceInfo.getCurrentTable() == null) {
                        throw new RowEventException("No table information is available for this event, cannot process further.");
                    }
                    if (eventType == EventType.WRITE_ROWS || eventType == EventType.EXT_WRITE_ROWS || eventType == EventType.PRE_GA_WRITE_ROWS) {
                        this.insertEventHandler.handleEvent((WriteRowsEventData)event.getData(), true, this.currentDataCaptureState, this.binlogResourceInfo, this.binlogEventState, (String)null, this.eventWriterConfiguration, this.currentSession, timestamp);
                        break;
                    }
                    if (eventType == EventType.DELETE_ROWS || eventType == EventType.EXT_DELETE_ROWS || eventType == EventType.PRE_GA_DELETE_ROWS) {
                        this.deleteEventHandler.handleEvent((DeleteRowsEventData)event.getData(), true, this.currentDataCaptureState, this.binlogResourceInfo, this.binlogEventState, (String)null, this.eventWriterConfiguration, this.currentSession, timestamp);
                        break;
                    }
                    this.updateEventHandler.handleEvent((UpdateRowsEventData)event.getData(), true, this.currentDataCaptureState, this.binlogResourceInfo, this.binlogEventState, (String)null, this.eventWriterConfiguration, this.currentSession, timestamp);
                    break;
                }
                case ROTATE: {
                    if (!this.currentDataCaptureState.isUseGtid()) {
                        RotateEventData rotateEventData = (RotateEventData)event.getData();
                        dataCaptureState.setBinlogFile(rotateEventData.getBinlogFilename());
                        dataCaptureState.setBinlogPosition(rotateEventData.getBinlogPosition());
                    }
                    this.updateState(session, dataCaptureState);
                    break;
                }
                case GTID: {
                    GtidEventData gtidEventData;
                    MySqlGtid mySqlGtid;
                    if (!this.currentDataCaptureState.isUseGtid() || (mySqlGtid = (gtidEventData = (GtidEventData)event.getData()).getMySqlGtid()) == null) break;
                    this.gtidSet.add(mySqlGtid.toString());
                    dataCaptureState.setGtidSet(this.gtidSet.toString());
                    this.updateState(session, dataCaptureState);
                    break;
                }
            }
            if (eventType == EventType.ROTATE || eventType == EventType.FORMAT_DESCRIPTION || this.currentDataCaptureState.isUseGtid() || eventType == EventType.XID) continue;
            dataCaptureState.setBinlogPosition(header.getNextPosition());
        }
    }

    private boolean isQueryDDL(String sql) {
        return sql.startsWith("alter table") || sql.startsWith("alter ignore table") || sql.startsWith("create table") || sql.startsWith("truncate table") || sql.startsWith("rename table") || sql.startsWith("drop table") || sql.startsWith("drop database");
    }

    protected void clearState() throws IOException {
        if (this.currentSession == null) {
            throw new IllegalStateException("No current session");
        }
        this.currentSession.clearState(Scope.CLUSTER);
    }

    protected String normalizeQuery(String sql) {
        String normalizedQuery = sql.toLowerCase().trim().replaceAll(" {2,}", " ");
        normalizedQuery = MULTI_COMMENT_PATTERN.matcher(normalizedQuery).replaceAll("").trim();
        normalizedQuery = normalizedQuery.replaceAll("#.*", "");
        normalizedQuery = normalizedQuery.replaceAll("-{2}.*", "");
        return normalizedQuery;
    }

    @OnStopped
    public void stop() throws CDCException {
        try {
            if (this.eventListener != null) {
                this.eventListener.stop();
                if (this.binlogClient != null) {
                    this.binlogClient.unregisterEventListener((BinaryLogClient.EventListener)this.eventListener);
                }
            }
            if (this.binlogClient != null) {
                this.binlogClient.disconnect();
            }
            if (this.currentSession != null) {
                FlowFile flowFile = this.eventWriterConfiguration.getCurrentFlowFile();
                if (flowFile != null && this.binlogEventState.getCurrentEventWriter() != null) {
                    this.binlogEventState.getCurrentEventWriter().finishAndTransferFlowFile(this.currentSession, this.eventWriterConfiguration, this.binlogResourceInfo.getTransitUri(), this.currentDataCaptureState.getSequenceId(), this.binlogEventState.getCurrentEventInfo(), REL_SUCCESS);
                }
                this.currentSession.commitAsync();
            }
            this.currentDataCaptureState.setBinlogPosition(-1L);
        }
        catch (IOException e) {
            throw new CDCException("Error closing CDC connection", (Throwable)e);
        }
        finally {
            this.binlogClient = null;
            if (this.jdbcConnectionHolder != null) {
                this.jdbcConnectionHolder.close();
            }
        }
    }

    private void updateState(ProcessSession session, DataCaptureState dataCaptureState) throws IOException {
        this.updateState(session, dataCaptureState, this.binlogResourceInfo.isInTransaction());
    }

    private void updateState(ProcessSession session, DataCaptureState dataCaptureState, boolean inTransaction) throws IOException {
        HashMap<String, String> newStateMap = new HashMap<String, String>(session.getState(Scope.CLUSTER).toMap());
        if (dataCaptureState.getBinlogFile() != null) {
            newStateMap.put("binlog.filename", dataCaptureState.getBinlogFile());
        }
        newStateMap.put("binlog.position", Long.toString(dataCaptureState.getBinlogPosition()));
        newStateMap.put("cdc.sequence.id", String.valueOf(dataCaptureState.getSequenceId()));
        newStateMap.put("inTransaction", inTransaction ? "true" : "false");
        if (dataCaptureState.getGtidSet() != null) {
            newStateMap.put("binlog.gtidset", dataCaptureState.getGtidSet());
        }
        session.setState(newStateMap, Scope.CLUSTER);
        this.currentDataCaptureState = dataCaptureState;
    }

    BinlogEventListener createBinlogEventListener(BinaryLogClient client, BlockingQueue<RawBinlogEvent> q) {
        return new BinlogEventListener(client, q);
    }

    BinlogLifecycleListener createBinlogLifecycleListener() {
        return new BinlogLifecycleListener();
    }

    protected BinaryLogClient createBinlogClient(String hostname, int port, String username, String password) {
        return new BinaryLogClient(hostname, port, username, password);
    }

    protected TableInfo loadTableInfo(TableInfoCacheKey key) throws SQLException {
        TableInfo tableInfo = null;
        if (this.jdbcConnectionHolder != null) {
            try (Statement s = this.getJdbcConnection().createStatement();){
                s.execute("USE `" + key.getDatabaseName() + "`");
                ResultSet rs = s.executeQuery("SELECT * FROM `" + key.getTableName() + "` LIMIT 0");
                ResultSetMetaData rsmd = rs.getMetaData();
                int numCols = rsmd.getColumnCount();
                ArrayList<ColumnDefinition> columnDefinitions = new ArrayList<ColumnDefinition>();
                for (int i = 1; i <= numCols; ++i) {
                    String columnLabel = rsmd.getColumnLabel(i);
                    columnDefinitions.add(new ColumnDefinition(rsmd.getColumnType(i), columnLabel != null ? columnLabel : rsmd.getColumnName(i)));
                }
                tableInfo = new TableInfo(key.getDatabaseName(), key.getTableName(), Long.valueOf(key.getTableId()), columnDefinitions);
            }
        }
        return tableInfo;
    }

    protected Connection getJdbcConnection() throws SQLException {
        return this.jdbcConnectionHolder.getConnection();
    }

    protected void registerDriver(String locationString, String drvName) throws InitializationException {
        if (locationString != null && locationString.length() > 0) {
            try {
                Class<?> clazz = Class.forName(drvName);
                if (clazz == null) {
                    throw new InitializationException("Can't load Database Driver " + drvName);
                }
                Driver driver = (Driver)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                DriverManager.registerDriver(new DriverShim(driver));
            }
            catch (InitializationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InitializationException("Can't load Database Driver", (Throwable)e);
            }
        }
    }

    public static class BinlogResourceInfo {
        private TableInfo currentTable = null;
        private String currentDatabase = null;
        private boolean inTransaction = false;
        private String transitUri = "<unknown>";

        public TableInfo getCurrentTable() {
            return this.currentTable;
        }

        public void setCurrentTable(TableInfo currentTable) {
            this.currentTable = currentTable;
        }

        public String getCurrentDatabase() {
            return this.currentDatabase;
        }

        public void setCurrentDatabase(String currentDatabase) {
            this.currentDatabase = currentDatabase;
        }

        public boolean isInTransaction() {
            return this.inTransaction;
        }

        public void setInTransaction(boolean inTransaction) {
            this.inTransaction = inTransaction;
        }

        public String getTransitUri() {
            return this.transitUri;
        }

        public void setTransitUri(String transitUri) {
            this.transitUri = transitUri;
        }
    }

    private class JDBCConnectionHolder {
        private final String connectionUrl;
        private final Properties connectionProps = new Properties();
        private final long connectionTimeoutMillis;
        private Connection connection;

        private JDBCConnectionHolder(InetSocketAddress host, String username, String password, Map<String, String> customProperties, long connectionTimeoutMillis) {
            this.connectionUrl = "jdbc:mysql://" + host.getHostString() + ":" + host.getPort();
            this.connectionProps.putAll(customProperties);
            if (username != null) {
                this.connectionProps.put("user", username);
                if (password != null) {
                    this.connectionProps.put("password", password);
                }
            }
            this.connectionTimeoutMillis = connectionTimeoutMillis;
        }

        private Connection getConnection() throws SQLException {
            if (this.connection != null && this.connection.isValid((int)(this.connectionTimeoutMillis / 1000L))) {
                CaptureChangeMySQL.this.getLogger().trace("Returning the pooled JDBC connection.");
                return this.connection;
            }
            this.close();
            CaptureChangeMySQL.this.getLogger().trace("Creating a new JDBC connection.");
            this.connection = DriverManager.getConnection(this.connectionUrl, this.connectionProps);
            return this.connection;
        }

        private void close() {
            if (this.connection != null) {
                try {
                    CaptureChangeMySQL.this.getLogger().trace("Closing the pooled JDBC connection.");
                    this.connection.close();
                }
                catch (SQLException e) {
                    CaptureChangeMySQL.this.getLogger().warn("Failed to close JDBC connection", (Throwable)e);
                }
            }
        }
    }

    public static class BinlogEventState {
        private BinlogEventInfo currentEventInfo;
        private AbstractBinlogEventWriter<? extends BinlogEventInfo> currentEventWriter;

        public BinlogEventInfo getCurrentEventInfo() {
            return this.currentEventInfo;
        }

        public void setCurrentEventInfo(BinlogEventInfo currentEventInfo) {
            this.currentEventInfo = currentEventInfo;
        }

        public AbstractBinlogEventWriter<? extends BinlogEventInfo> getCurrentEventWriter() {
            return this.currentEventWriter;
        }

        public void setCurrentEventWriter(AbstractBinlogEventWriter<? extends BinlogEventInfo> currentEventWriter) {
            this.currentEventWriter = currentEventWriter;
        }
    }

    private static class DriverShim
    implements Driver {
        private final Driver driver;

        DriverShim(Driver d) {
            this.driver = d;
        }

        @Override
        public boolean acceptsURL(String u) throws SQLException {
            return this.driver.acceptsURL(u);
        }

        @Override
        public Connection connect(String u, Properties p) throws SQLException {
            return this.driver.connect(u, p);
        }

        @Override
        public int getMajorVersion() {
            return this.driver.getMajorVersion();
        }

        @Override
        public int getMinorVersion() {
            return this.driver.getMinorVersion();
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfo(String u, Properties p) throws SQLException {
            return this.driver.getPropertyInfo(u, p);
        }

        @Override
        public boolean jdbcCompliant() {
            return this.driver.jdbcCompliant();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return this.driver.getParentLogger();
        }
    }
}

