/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.sql;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.util.Pair;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.sql.ColumnSchema;
import org.apache.nifi.sql.NiFiTableSchema;
import org.apache.nifi.sql.ResettableDataSource;
import org.apache.nifi.sql.internal.CalciteTable;
import org.apache.nifi.sql.internal.NiFiTableEnumerator;

public class NiFiTable
implements Closeable {
    private final String name;
    private final NiFiTableSchema tableSchema;
    private final ComponentLog logger;
    private final Set<NiFiTableEnumerator> enumerators = Collections.synchronizedSet(new HashSet());
    private volatile ResettableDataSource dataSource;
    private volatile int maxRecordsRead;

    public NiFiTable(String name, ResettableDataSource dataSource, ComponentLog logger) {
        this(name, dataSource.getSchema(), logger);
        this.dataSource = dataSource;
    }

    public NiFiTable(String name, NiFiTableSchema schema, ComponentLog logger) {
        this.name = name;
        this.tableSchema = schema;
        this.logger = logger;
    }

    public String getName() {
        return this.name;
    }

    public void setDataSource(ResettableDataSource dataSource) {
        if (!this.tableSchema.equals(dataSource.getSchema())) {
            throw new IllegalArgumentException("Cannot update data source because the newly provided data source [%s] has a different schema than the current data source [%s]".formatted(dataSource, this.dataSource));
        }
        this.dataSource = dataSource;
        this.maxRecordsRead = 0;
    }

    public int getRecordsRead() {
        return this.maxRecordsRead;
    }

    CalciteTable createCalciteTable() {
        return new CalciteTable(this::createTableDefinition, x$0 -> new NiFiTableEnumerable((int[])x$0));
    }

    private RelDataType createTableDefinition(RelDataTypeFactory typeFactory) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        JavaTypeFactory javaTypeFactory = (JavaTypeFactory)typeFactory;
        for (ColumnSchema column : this.tableSchema.columns()) {
            names.add(column.getName());
            types.add(column.toRelationalDataType(javaTypeFactory));
        }
        return typeFactory.createStructType(Pair.zip(names, types));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NiFiTable nifiTable = (NiFiTable)o;
        return Objects.equals(this.name, nifiTable.name) && Objects.equals(this.tableSchema, nifiTable.tableSchema);
    }

    public int hashCode() {
        return Objects.hash(this.tableSchema);
    }

    public String toString() {
        return "NiFiTable[name=" + this.name + "]";
    }

    @Override
    public void close() {
        for (NiFiTableEnumerator enumerator : this.enumerators) {
            enumerator.close();
        }
    }

    private class NiFiTableEnumerable
    extends AbstractEnumerable<Object> {
        private final int[] fields;

        public NiFiTableEnumerable(int[] fields) {
            this.fields = fields;
        }

        public Enumerator<Object> enumerator() {
            NiFiTableEnumerator flowFileEnumerator = new NiFiTableEnumerator(NiFiTable.this.dataSource, NiFiTable.this.logger, this.fields, this::onFinish, NiFiTable.this.enumerators::remove);
            NiFiTable.this.enumerators.add(flowFileEnumerator);
            return flowFileEnumerator;
        }

        private void onFinish() {
            int recordCount = NiFiTable.this.maxRecordsRead;
            if (recordCount > NiFiTable.this.maxRecordsRead) {
                NiFiTable.this.maxRecordsRead = recordCount;
            }
        }
    }
}

