/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.sql;

import java.util.Objects;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.nifi.sql.ColumnType;
import org.apache.nifi.sql.ScalarType;

public class ColumnSchema {
    private final String name;
    private final ColumnType columnType;
    private final boolean nullable;

    public ColumnSchema(String name, Class<?> type, boolean nullable) {
        this(name, new ScalarType(type), nullable);
    }

    public ColumnSchema(String name, ColumnType type, boolean nullable) {
        this.name = Objects.requireNonNull(name);
        this.columnType = type;
        this.nullable = nullable;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    RelDataType toRelationalDataType(JavaTypeFactory typeFactory) {
        RelDataType javaType = this.columnType.getRelationalDataType(typeFactory);
        return typeFactory.createTypeWithNullability(javaType, this.nullable);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ColumnSchema that = (ColumnSchema)other;
        return this.nullable == that.nullable && Objects.equals(this.name, that.name) && Objects.equals(this.columnType, that.columnType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.columnType, this.nullable);
    }

    public String toString() {
        return "ColumnSchema[name='" + this.name + "', columnType=" + String.valueOf(this.columnType) + ", nullable=" + this.nullable + "]";
    }
}

