/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.sql;

import java.util.Iterator;
import java.util.function.Function;
import org.apache.nifi.sql.RowStream;

public class IterableRowStream<T>
implements RowStream {
    private final Iterator<T> iterator;
    private final Function<T, Object[]> transform;

    public IterableRowStream(Iterable<T> iterable, Function<T, Object[]> transform) {
        this.iterator = iterable.iterator();
        this.transform = transform;
    }

    @Override
    public Object[] nextRow() {
        if (!this.iterator.hasNext()) {
            return null;
        }
        T value = this.iterator.next();
        return this.transform.apply(value);
    }

    @Override
    public void close() {
    }
}

