/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.sql.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.sql.ResettableDataSource;
import org.apache.nifi.sql.RowStream;

public class NiFiTableEnumerator
implements Enumerator<Object> {
    private final ResettableDataSource dataSource;
    private final ComponentLog logger;
    private final int[] fields;
    private final Runnable onFinishCallback;
    private final Consumer<NiFiTableEnumerator> onCloseCallback;
    private RowStream rowStream;
    private Object currentRow;
    private int recordsRead = 0;

    public NiFiTableEnumerator(ResettableDataSource dataSource, ComponentLog logger, int[] fields, Runnable onFinishCallback, Consumer<NiFiTableEnumerator> onCloseCallback) {
        this.dataSource = dataSource;
        this.logger = logger;
        this.fields = fields;
        this.onFinishCallback = onFinishCallback;
        this.onCloseCallback = onCloseCallback;
        this.reset();
    }

    public Object current() {
        return this.currentRow;
    }

    public boolean moveNext() {
        this.currentRow = null;
        try {
            Object[] row = this.rowStream.nextRow();
            if (row == null) {
                this.close();
                try {
                    this.onFinish();
                }
                catch (Exception e) {
                    this.logger.error("Failed to perform tasks when enumerator was finished", (Throwable)e);
                }
                return false;
            }
            this.currentRow = this.filterColumns(row);
        }
        catch (Exception e) {
            throw new ProcessException("Failed to read next row in stream", (Throwable)e);
        }
        ++this.recordsRead;
        return true;
    }

    public int getRecordsRead() {
        return this.recordsRead;
    }

    private void onFinish() {
        if (this.onFinishCallback != null) {
            this.onFinishCallback.run();
        }
    }

    private Object filterColumns(Object[] row) {
        if (row == null) {
            return null;
        }
        if (this.fields == null) {
            return row;
        }
        if (this.fields.length == 1) {
            int desiredCellIndex = this.fields[0];
            return this.cast(row[desiredCellIndex]);
        }
        Object[] filtered = new Object[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            int indexToKeep = this.fields[i];
            filtered[i] = this.cast(row[indexToKeep]);
        }
        return filtered;
    }

    private Object cast(Object toCast) {
        if (toCast == null) {
            return null;
        }
        if (toCast.getClass().isArray()) {
            ArrayList<Object> list = new ArrayList<Object>(Array.getLength(toCast));
            for (int i = 0; i < Array.getLength(toCast); ++i) {
                list.add(Array.get(toCast, i));
            }
            return list;
        }
        return toCast;
    }

    public void reset() {
        if (this.rowStream != null) {
            try {
                this.rowStream.close();
            }
            catch (Exception e) {
                this.logger.warn("Could not close data stream {}", new Object[]{this.rowStream, e});
            }
        }
        try {
            this.rowStream = this.dataSource.reset();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to data stream from " + String.valueOf(this.dataSource), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void close() {
        try {
            if (this.onCloseCallback != null) {
                this.onCloseCallback.accept(this);
            }
            if (this.rowStream == null) return;
        }
        catch (Throwable throwable) {
            if (this.rowStream == null) throw throwable;
            try {
                this.rowStream.close();
                throw throwable;
            }
            catch (Exception e) {
                this.logger.warn("Failed to close {}", new Object[]{this.rowStream, e});
            }
            throw throwable;
        }
        try {
            this.rowStream.close();
            return;
        }
        catch (Exception e) {
            this.logger.warn("Failed to close {}", new Object[]{this.rowStream, e});
        }
    }
}

