/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.box.controllerservices;

import com.box.sdk.BoxAPIConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.box.controllerservices.BoxClientService;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.VerifiableControllerService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.StandardValidators;

@CapabilityDescription(value="Provides Box client objects through which Box API calls can be used. This using a developer token and is for testing only.")
@Tags(value={"box", "client", "provider"})
public class DeveloperBoxClientService
extends AbstractControllerService
implements BoxClientService,
VerifiableControllerService {
    public static final PropertyDescriptor DEVELOPER_TOKEN = new PropertyDescriptor.Builder().name("Developer Token").description("The Developer Token to use to interact with the Box API. This is for testing only and should not be used in production.").required(true).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(DEVELOPER_TOKEN);
    private volatile BoxAPIConnection boxAPIConnection;

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public List<ConfigVerificationResult> verify(ConfigurationContext configurationContext, ComponentLog componentLog, Map<String, String> map) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        try {
            this.createBoxApiConnection(configurationContext);
            results.add(new ConfigVerificationResult.Builder().verificationStepName("Authentication").outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation("Developer Token verified").build());
        }
        catch (Exception e) {
            results.add(new ConfigVerificationResult.Builder().verificationStepName("Authentication").outcome(ConfigVerificationResult.Outcome.FAILED).explanation("Developer Token failed to verify: " + e.getMessage()).build());
        }
        return results;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.boxAPIConnection = this.createBoxApiConnection(context);
    }

    public BoxAPIConnection getBoxApiConnection() {
        return this.boxAPIConnection;
    }

    private BoxAPIConnection createBoxApiConnection(ConfigurationContext context) {
        String devToken = context.getProperty(DEVELOPER_TOKEN).evaluateAttributeExpressions().getValue();
        return new BoxAPIConnection(devToken);
    }
}

