/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.box;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.util.list.ListableEntity;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public class BoxFileInfo
implements ListableEntity {
    private static final RecordSchema SCHEMA;
    private final String id;
    private final String fileName;
    private final String path;
    private final long size;
    private final long createdTime;
    private final long modifiedTime;

    public String getId() {
        return this.id;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPath() {
        return this.path;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public long getModifiedTime() {
        return this.modifiedTime;
    }

    public Record toRecord() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("box.id", this.getId());
        values.put(CoreAttributes.FILENAME.key(), this.getName());
        values.put(CoreAttributes.PATH.key(), this.getPath());
        values.put("box.size", this.getSize());
        values.put("box.timestamp", this.getTimestamp());
        return new MapRecord(SCHEMA, values);
    }

    public static RecordSchema getRecordSchema() {
        return SCHEMA;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoxFileInfo other = (BoxFileInfo)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    private BoxFileInfo(Builder builder) {
        this.id = builder.id;
        this.fileName = builder.fileName;
        this.path = builder.path;
        this.size = builder.size;
        this.createdTime = builder.createdTime;
        this.modifiedTime = builder.modifiedTime;
    }

    public String getName() {
        return this.getFileName();
    }

    public String getIdentifier() {
        return this.getId();
    }

    public long getTimestamp() {
        long timestamp = Math.max(this.getCreatedTime(), this.getModifiedTime());
        return timestamp;
    }

    public long getSize() {
        return this.size;
    }

    static {
        ArrayList<RecordField> recordFields = new ArrayList<RecordField>();
        recordFields.add(new RecordField("box.id", RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField(CoreAttributes.FILENAME.key(), RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField(CoreAttributes.PATH.key(), RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField("box.size", RecordFieldType.LONG.getDataType(), false));
        recordFields.add(new RecordField("box.timestamp", RecordFieldType.LONG.getDataType(), false));
        SCHEMA = new SimpleRecordSchema(recordFields);
    }

    public static final class Builder {
        private String id;
        private String fileName;
        private String path;
        private long size;
        private long createdTime;
        private long modifiedTime;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public Builder createdTime(long createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public Builder modifiedTime(long modifiedTime) {
            this.modifiedTime = modifiedTime;
            return this;
        }

        public BoxFileInfo build() {
            return new BoxFileInfo(this);
        }
    }
}

