/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.box;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIResponseException;
import com.box.sdk.BoxFile;
import com.box.sdk.Metadata;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.box.controllerservices.BoxClientService;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.box.AbstractBoxProcessor;
import org.apache.nifi.processors.box.BoxMetadataJsonArrayWriter;
import org.apache.nifi.processors.box.FetchBoxFile;
import org.apache.nifi.processors.box.FetchBoxFileInfo;
import org.apache.nifi.processors.box.ListBoxFile;
import org.apache.nifi.processors.box.ListBoxFileMetadataInstances;
import org.apache.nifi.processors.box.utils.BoxMetadataUtils;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"box", "storage", "metadata", "instance", "template"})
@CapabilityDescription(value="Retrieves specific metadata instance associated with a Box file using template key and scope.")
@SeeAlso(value={ListBoxFileMetadataInstances.class, ListBoxFile.class, FetchBoxFile.class, FetchBoxFileInfo.class})
@WritesAttributes(value={@WritesAttribute(attribute="box.id", description="The ID of the file from which metadata was fetched"), @WritesAttribute(attribute="box.metadata.template.key", description="The metadata template key"), @WritesAttribute(attribute="box.metadata.template.scope", description="The metadata template scope"), @WritesAttribute(attribute="mime.type", description="The MIME Type of the FlowFile content"), @WritesAttribute(attribute="error.code", description="The error code returned by Box"), @WritesAttribute(attribute="error.message", description="The error message returned by Box")})
public class FetchBoxFileMetadataInstance
extends AbstractBoxProcessor {
    public static final PropertyDescriptor FILE_ID = new PropertyDescriptor.Builder().name("File ID").description("The ID of the file for which to fetch metadata.").required(true).defaultValue("${box.id}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor TEMPLATE_KEY = new PropertyDescriptor.Builder().name("Template Key").description("The metadata template key to retrieve.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor TEMPLATE_SCOPE = new PropertyDescriptor.Builder().name("Template Scope").description("The metadata template scope (e.g., 'enterprise', 'global').").required(true).defaultValue("enterprise").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile containing the metadata instance will be routed to this relationship upon successful processing.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile will be routed here if there is an error fetching metadata instance from the file.").build();
    public static final Relationship REL_FILE_NOT_FOUND = new Relationship.Builder().name("file not found").description("FlowFiles for which the specified Box file was not found will be routed to this relationship.").build();
    public static final Relationship REL_TEMPLATE_NOT_FOUND = new Relationship.Builder().name("template not found").description("FlowFiles for which the specified metadata template was not found will be routed to this relationship.").build();
    public static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE, REL_FILE_NOT_FOUND, REL_TEMPLATE_NOT_FOUND);
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BOX_CLIENT_SERVICE, FILE_ID, TEMPLATE_KEY, TEMPLATE_SCOPE);
    private volatile BoxAPIConnection boxAPIConnection;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        BoxClientService boxClientService = (BoxClientService)context.getProperty(BOX_CLIENT_SERVICE).asControllerService(BoxClientService.class);
        this.boxAPIConnection = boxClientService.getBoxApiConnection();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String fileId = context.getProperty(FILE_ID).evaluateAttributeExpressions(flowFile).getValue();
        String templateKey = context.getProperty(TEMPLATE_KEY).evaluateAttributeExpressions(flowFile).getValue();
        String templateScope = context.getProperty(TEMPLATE_SCOPE).evaluateAttributeExpressions(flowFile).getValue();
        try {
            BoxFile boxFile = this.getBoxFile(fileId);
            Metadata metadata = boxFile.getMetadata(templateKey, templateScope);
            HashMap<String, Object> instanceFields = new HashMap<String, Object>();
            BoxMetadataUtils.processBoxMetadataInstance(fileId, metadata, instanceFields);
            try {
                try (OutputStream out = session.write(flowFile);
                     BoxMetadataJsonArrayWriter writer = BoxMetadataJsonArrayWriter.create(out);){
                    writer.write(instanceFields);
                }
                HashMap<String, String> recordAttributes = new HashMap<String, String>();
                recordAttributes.put(CoreAttributes.MIME_TYPE.key(), "application/json");
                recordAttributes.put("box.id", fileId);
                recordAttributes.put("box.metadata.template.key", templateKey);
                recordAttributes.put("box.metadata.template.scope", templateScope);
                flowFile = session.putAllAttributes(flowFile, recordAttributes);
                session.getProvenanceReporter().receive(flowFile, String.format("%s/%s/metadata/%s", "https://app.box.com/file/", fileId, templateKey));
                session.transfer(flowFile, REL_SUCCESS);
            }
            catch (IOException e) {
                this.getLogger().error("Failed writing metadata instance from file [{}] with template key [{}] and scope [{}]", new Object[]{fileId, templateKey, templateScope, e});
                flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
                session.transfer(flowFile, REL_FAILURE);
            }
        }
        catch (BoxAPIResponseException e) {
            flowFile = session.putAttribute(flowFile, "error.code", String.valueOf(e.getResponseCode()));
            flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
            if (e.getResponseCode() == 404) {
                String errorBody = e.getResponse();
                if (errorBody != null && errorBody.toLowerCase().contains("instance_not_found")) {
                    this.getLogger().warn("Box metadata template with key {} and scope {} was not found.", new Object[]{templateKey, templateScope});
                    session.transfer(flowFile, REL_TEMPLATE_NOT_FOUND);
                } else {
                    this.getLogger().warn("Box file with ID {} was not found.", new Object[]{fileId});
                    session.transfer(flowFile, REL_FILE_NOT_FOUND);
                }
            } else {
                this.getLogger().error("Couldn't fetch metadata instance from file with id [{}] with template key [{}] and scope [{}]", new Object[]{fileId, templateKey, templateScope, e});
                session.transfer(flowFile, REL_FAILURE);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Failed to process metadata instance for file [{}] with template key [{}] and scope [{}]", new Object[]{fileId, templateKey, templateScope, e});
            flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    BoxFile getBoxFile(String fileId) {
        return new BoxFile(this.boxAPIConnection, fileId);
    }
}

