/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.box;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIResponseException;
import com.box.sdk.BoxFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.box.controllerservices.BoxClientService;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.VerifiableProcessor;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.box.AbstractBoxProcessor;
import org.apache.nifi.processors.box.FetchBoxFile;
import org.apache.nifi.processors.box.ListBoxFile;

@Tags(value={"box", "cloud", "storage", "file", "representation", "content", "download"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Fetches a Box file representation using a representation hint and writes it to the FlowFile content.")
@WritesAttributes(value={@WritesAttribute(attribute="box.id", description="The ID of the Box file."), @WritesAttribute(attribute="box.file.name", description="The name of the Box file."), @WritesAttribute(attribute="box.file.size", description="The size of the Box file in bytes."), @WritesAttribute(attribute="box.file.created.time", description="The timestamp when the file was created."), @WritesAttribute(attribute="box.file.modified.time", description="The timestamp when the file was last modified."), @WritesAttribute(attribute="box.file.mime.type", description="The MIME type of the file."), @WritesAttribute(attribute="box.file.representation.type", description="The representation type that was fetched."), @WritesAttribute(attribute="box.error.message", description="The error message returned by Box if the operation fails."), @WritesAttribute(attribute="box.error.code", description="The error code returned by Box if the operation fails.")})
@SeeAlso(value={FetchBoxFile.class, ListBoxFile.class})
public class FetchBoxFileRepresentation
extends AbstractBoxProcessor
implements VerifiableProcessor {
    private static final String BOX_FILE_URI = "https://api.box.com/2.0/files/%s/content?representation=%s";
    static final PropertyDescriptor FILE_ID = new PropertyDescriptor.Builder().name("File ID").defaultValue("${box.id}").description("The ID of the Box file to retrieve.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor REPRESENTATION_TYPE = new PropertyDescriptor.Builder().name("Representation Type").description("The type of representation to fetch. Common values include 'pdf', 'text', 'jpg', 'png', etc.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles that are successfully processed will be routed to this relationship.").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles that encounter errors during processing will be routed to this relationship.").build();
    static final Relationship REL_FILE_NOT_FOUND = new Relationship.Builder().name("file.not.found").description("FlowFiles for which the specified Box file was not found.").build();
    static final Relationship REL_REPRESENTATION_NOT_FOUND = new Relationship.Builder().name("representation.not.found").description("FlowFiles for which the specified Box file's requested representation was not found.").build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BOX_CLIENT_SERVICE, FILE_ID, REPRESENTATION_TYPE);
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE, REL_FILE_NOT_FOUND, REL_REPRESENTATION_NOT_FOUND);
    private static final int MAX_RETRIES = 50;
    private volatile BoxAPIConnection boxAPIConnection;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        BoxClientService boxClientService = (BoxClientService)context.getProperty(BOX_CLIENT_SERVICE).asControllerService(BoxClientService.class);
        this.boxAPIConnection = boxClientService.getBoxApiConnection();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ComponentLog logger = this.getLogger();
        String fileId = context.getProperty(FILE_ID).evaluateAttributeExpressions(flowFile).getValue();
        String representationType = context.getProperty(REPRESENTATION_TYPE).evaluateAttributeExpressions(flowFile).getValue();
        try {
            BoxFile boxFile = this.getBoxFile(fileId);
            BoxFile.Info fileInfo = boxFile.getInfo(new String[0]);
            flowFile = session.write(flowFile, outputStream -> boxFile.getRepresentationContent("[" + representationType + "]", "", outputStream, 50));
            flowFile = session.putAllAttributes(flowFile, Map.of("box.id", fileId, "box.file.name", fileInfo.getName(), "box.file.size", String.valueOf(fileInfo.getSize()), "box.file.created.time", fileInfo.getCreatedAt().toString(), "box.file.modified.time", fileInfo.getModifiedAt().toString(), "box.file.mime.type", fileInfo.getType(), "box.file.representation.type", representationType));
            session.getProvenanceReporter().fetch(flowFile, BOX_FILE_URI.formatted(fileId, representationType));
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (BoxAPIResponseException e) {
            flowFile = session.putAttribute(flowFile, "box.error.message", e.getMessage());
            flowFile = session.putAttribute(flowFile, "box.error.code", String.valueOf(e.getResponseCode()));
            if (e.getResponseCode() == 404) {
                logger.warn("Box file with ID {} was not found or representation {} is not available", new Object[]{fileId, representationType});
                session.transfer(flowFile, REL_FILE_NOT_FOUND);
            } else {
                logger.error("Failed to retrieve Box file representation for file [{}]", new Object[]{fileId, e});
                session.transfer(flowFile, REL_FAILURE);
            }
        }
        catch (BoxAPIException e) {
            flowFile = session.putAttribute(flowFile, "box.error.message", e.getMessage());
            flowFile = session.putAttribute(flowFile, "box.error.code", String.valueOf(e.getResponseCode()));
            if (e.getMessage() != null && e.getMessage().toLowerCase().startsWith("no matching representations found for requested")) {
                logger.warn("Representation {} is not available for file {}: {}", new Object[]{representationType, fileId, e.getMessage()});
                session.transfer(flowFile, REL_REPRESENTATION_NOT_FOUND);
            }
            logger.error("BoxAPIException while retrieving file [{}]", new Object[]{fileId, e});
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    protected BoxFile getBoxFile(String fileId) {
        return new BoxFile(this.boxAPIConnection, fileId);
    }

    public List<ConfigVerificationResult> verify(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        BoxClientService boxClientService = (BoxClientService)context.getProperty(BOX_CLIENT_SERVICE).asControllerService(BoxClientService.class);
        BoxAPIConnection boxAPIConnection = boxClientService.getBoxApiConnection();
        try {
            boxAPIConnection.refresh();
            results.add(new ConfigVerificationResult.Builder().verificationStepName("Box API Connection").outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation("Successfully validated Box connection").build());
        }
        catch (Exception e) {
            verificationLogger.warn("Failed to verify configuration", (Throwable)e);
            results.add(new ConfigVerificationResult.Builder().verificationStepName("Box API Connection").outcome(ConfigVerificationResult.Outcome.FAILED).explanation(String.format("Failed to validate Box connection: %s", e.getMessage())).build());
        }
        return results;
    }
}

