/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.box;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIResponseException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxItem;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.box.controllerservices.BoxClientService;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.box.BoxFileUtils;
import org.apache.nifi.processors.box.FetchBoxFile;
import org.apache.nifi.processors.box.ListBoxFile;
import org.apache.nifi.processors.box.PutBoxFile;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"box", "storage", "fetch", "folder", "files"})
@CapabilityDescription(value="Fetches file metadata for each file in a Box Folder. Takes a flowFile with a folder ID attribute and outputs flowFiles with records containing all file metadata.")
@SeeAlso(value={ListBoxFile.class, FetchBoxFile.class, PutBoxFile.class})
@WritesAttributes(value={@WritesAttribute(attribute="box.folder.id", description="The ID of the folder from which files were fetched"), @WritesAttribute(attribute="record.count", description="The number of records in the FlowFile"), @WritesAttribute(attribute="mime.type", description="The MIME Type specified by the Record Writer"), @WritesAttribute(attribute="error.code", description="The error code returned by Box"), @WritesAttribute(attribute="error.message", description="The error message returned by Box")})
public class ListBoxFileInfo
extends AbstractProcessor {
    public static final PropertyDescriptor FOLDER_ID = new PropertyDescriptor.Builder().name("Folder ID").description("The ID of the folder from which to fetch files.").required(true).defaultValue("${box.folder.id}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor RECURSIVE_SEARCH = new PropertyDescriptor.Builder().name("Search Recursively").description("When 'true', will include files from sub-folders. Otherwise, will return only files that are within the folder defined by the 'Folder ID' property.").required(true).defaultValue("true").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor MIN_AGE = new PropertyDescriptor.Builder().name("Minimum File Age").description("The minimum age a file must be in order to be considered; any files younger than this will be ignored.").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").build();
    public static final PropertyDescriptor RECORD_WRITER = new PropertyDescriptor.Builder().name("Record Writer").description("Specifies the Controller Service to use for writing the metadata records. Must be set.").identifiesControllerService(RecordSetWriterFactory.class).required(true).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile containing the file metadata records will be routed to this relationship upon successful processing.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile will be routed here if there is an error fetching file metadata from the folder.").build();
    public static final Relationship REL_NOT_FOUND = new Relationship.Builder().name("not.found").description("FlowFiles for which the specified Box folder was not found will be routed to this relationship.").build();
    public static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE, REL_NOT_FOUND);
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BoxClientService.BOX_CLIENT_SERVICE, FOLDER_ID, RECURSIVE_SEARCH, MIN_AGE, RECORD_WRITER);
    private static final RecordSchema RECORD_SCHEMA = new SimpleRecordSchema(List.of(new RecordField("id", RecordFieldType.STRING.getDataType(), false), new RecordField("filename", RecordFieldType.STRING.getDataType(), false), new RecordField("path", RecordFieldType.STRING.getDataType(), false), new RecordField("size", RecordFieldType.LONG.getDataType(), false), new RecordField("timestamp", RecordFieldType.TIMESTAMP.getDataType(), false)));
    private volatile BoxAPIConnection boxAPIConnection;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        BoxClientService boxClientService = (BoxClientService)context.getProperty(BoxClientService.BOX_CLIENT_SERVICE).asControllerService(BoxClientService.class);
        this.boxAPIConnection = boxClientService.getBoxApiConnection();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String folderId = context.getProperty(FOLDER_ID).evaluateAttributeExpressions(flowFile).getValue();
        Boolean recursive = context.getProperty(RECURSIVE_SEARCH).asBoolean();
        Long minAge = context.getProperty(MIN_AGE).asTimePeriod(TimeUnit.MILLISECONDS);
        RecordSetWriterFactory writerFactory = (RecordSetWriterFactory)context.getProperty(RECORD_WRITER).asControllerService(RecordSetWriterFactory.class);
        try {
            long startNanos = System.nanoTime();
            long createdAtMax = Instant.now().toEpochMilli() - minAge;
            ArrayList<BoxFile.Info> fileInfos = new ArrayList<BoxFile.Info>();
            this.listFolder(fileInfos, folderId, recursive, createdAtMax);
            if (fileInfos.isEmpty()) {
                flowFile = session.putAttribute(flowFile, "box.folder.id", folderId);
                session.transfer(flowFile, REL_SUCCESS);
                return;
            }
            flowFile = session.putAttribute(flowFile, "box.folder.id", folderId);
            try {
                String mimeType;
                WriteResult writeResult;
                try (OutputStream out = session.write(flowFile);
                     RecordSetWriter writer = writerFactory.createWriter(this.getLogger(), RECORD_SCHEMA, out, flowFile);){
                    writer.beginRecordSet();
                    for (BoxFile.Info fileInfo : fileInfos) {
                        Map<String, Timestamp> values = Map.of("id", fileInfo.getID(), "filename", fileInfo.getName(), "path", BoxFileUtils.getParentPath((BoxItem.Info)fileInfo), "size", fileInfo.getSize(), "timestamp", new Timestamp(fileInfo.getModifiedAt().getTime()));
                        MapRecord record = new MapRecord(RECORD_SCHEMA, values);
                        writer.write((Record)record);
                    }
                    writeResult = writer.finishRecordSet();
                    mimeType = writer.getMimeType();
                }
                HashMap<String, String> recordAttributes = new HashMap<String, String>(writeResult.getAttributes());
                recordAttributes.put("record.count", String.valueOf(writeResult.getRecordCount()));
                recordAttributes.put(CoreAttributes.MIME_TYPE.key(), mimeType);
                flowFile = session.putAllAttributes(flowFile, recordAttributes);
                long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                session.getProvenanceReporter().receive(flowFile, "https://app.box.com/file/" + folderId, transferMillis);
                session.transfer(flowFile, REL_SUCCESS);
            }
            catch (IOException | SchemaNotFoundException e) {
                this.getLogger().error("Failed writing records for files from folder [{}]", new Object[]{folderId, e});
                flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
                flowFile = session.penalize(flowFile);
                session.transfer(flowFile, REL_FAILURE);
            }
        }
        catch (BoxAPIResponseException e) {
            flowFile = session.putAttribute(flowFile, "error.code", String.valueOf(e.getResponseCode()));
            flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
            if (e.getResponseCode() == 404) {
                this.getLogger().warn("Box folder with ID {} was not found.", new Object[]{folderId});
                session.transfer(flowFile, REL_NOT_FOUND);
            }
            this.getLogger().error("Couldn't fetch files from folder with id [{}]", new Object[]{folderId, e});
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private void listFolder(List<BoxFile.Info> fileInfos, String folderId, Boolean recursive, long createdAtMax) {
        BoxFolder folder = this.getFolder(folderId);
        for (BoxItem.Info itemInfo : folder.getChildren(new String[]{"id", "name", "item_status", "size", "created_at", "modified_at", "content_created_at", "content_modified_at", "path_collection"})) {
            if (itemInfo instanceof BoxFile.Info) {
                BoxFile.Info fileInfo = (BoxFile.Info)itemInfo;
                long createdAt = itemInfo.getCreatedAt().getTime();
                if (createdAt > createdAtMax) continue;
                fileInfos.add(fileInfo);
                continue;
            }
            if (!recursive.booleanValue() || !(itemInfo instanceof BoxFolder.Info)) continue;
            BoxFolder.Info subFolderInfo = (BoxFolder.Info)itemInfo;
            this.listFolder(fileInfos, subFolderInfo.getID(), recursive, createdAtMax);
        }
    }

    BoxFolder getFolder(String folderId) {
        return new BoxFolder(this.boxAPIConnection, folderId);
    }
}

