/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.box;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxGroup;
import com.box.sdk.BoxGroupMembership;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxUser;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.ReadsAttributes;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.box.controllerservices.BoxClientService;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@SideEffectFree
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"box", "storage", "metadata"})
@CapabilityDescription(value="Retrieves members for a Box Group and writes their details in FlowFile attributes.")
@ReadsAttributes(value={@ReadsAttribute(attribute="box.group.id", description="The ID of the Group to retrieve members for.")})
@WritesAttributes(value={@WritesAttribute(attribute="box.group.user.ids", description="A comma-separated list of user IDs in the group."), @WritesAttribute(attribute="box.group.user.logins", description="A comma-separated list of user Logins (emails) in the group."), @WritesAttribute(attribute="error.code", description="An http error code returned by Box."), @WritesAttribute(attribute="error.message", description="An error message returned by Box.")})
public class GetBoxGroupMembers
extends AbstractProcessor {
    static final PropertyDescriptor GROUP_ID = new PropertyDescriptor.Builder().name("Group ID").description("The ID of the Group to retrieve members for").required(true).defaultValue("${%s}".formatted("box.group.id")).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BoxClientService.BOX_CLIENT_SERVICE, GROUP_ID);
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("The FlowFile will be routed here after successfully retrieving Group members.").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("The FlowFile will be routed here when Group memberships retrieval was attempted but failed.").build();
    static final Relationship REL_NOT_FOUND = new Relationship.Builder().name("not.found").description("The FlowFile will be routed here when the Group was not found.").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE, REL_NOT_FOUND);
    private volatile BoxAPIConnection boxAPIConnection;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        BoxClientService boxClientService = (BoxClientService)context.getProperty(BoxClientService.BOX_CLIENT_SERVICE).asControllerService(BoxClientService.class);
        this.boxAPIConnection = boxClientService.getBoxApiConnection();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String groupId = context.getProperty(GROUP_ID).evaluateAttributeExpressions(flowFile).getValue();
        try {
            Collection<BoxGroupMembership.Info> memberships = this.retrieveGroupMemberships(groupId);
            String userIDs = this.extractUserProperty(memberships, BoxResource.Info::getID);
            String userLogins = this.extractUserProperty(memberships, BoxUser.Info::getLogin);
            session.putAttribute(flowFile, "box.group.user.ids", userIDs);
            session.putAttribute(flowFile, "box.group.user.logins", userLogins);
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (BoxAPIException e) {
            session.putAttribute(flowFile, "error.message", e.getMessage());
            session.putAttribute(flowFile, "error.code", String.valueOf(e.getResponseCode()));
            if (e.getResponseCode() == 404) {
                this.getLogger().warn("Box Group with ID {} was not found.", new Object[]{groupId});
                session.transfer(flowFile, REL_NOT_FOUND);
            } else {
                this.getLogger().error("Failed to retrieve Box Group for ID: {}, file [{}]", new Object[]{groupId, flowFile, e});
                session.transfer(flowFile, REL_FAILURE);
            }
        }
        catch (ProcessException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.getLogger().error("Failed to retrieve Box Group for ID: {}, file [{}]", new Object[]{groupId, flowFile, e});
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private String extractUserProperty(Collection<BoxGroupMembership.Info> memberships, Function<BoxUser.Info, String> userPropertyExtractor) {
        return memberships.stream().map(BoxGroupMembership.Info::getUser).map(userPropertyExtractor).collect(Collectors.joining(","));
    }

    Collection<BoxGroupMembership.Info> retrieveGroupMemberships(String groupId) {
        return new BoxGroup(this.boxAPIConnection, groupId).getMemberships();
    }
}

