/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.box;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIResponseException;
import com.box.sdk.BoxCollaboration;
import com.box.sdk.BoxCollaborator;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxResourceIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.box.controllerservices.BoxClientService;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.box.FetchBoxFile;
import org.apache.nifi.processors.box.ListBoxFile;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"box", "storage", "collaboration", "permissions", "sharing"})
@CapabilityDescription(value="Retrieves all collaborators on a Box file and adds the collaboration information to the FlowFile's attributes.")
@SeeAlso(value={FetchBoxFile.class, ListBoxFile.class})
@WritesAttributes(value={@WritesAttribute(attribute="box.id", description="The id of the file"), @WritesAttribute(attribute="box.collaborations.<status>.users.ids", description="Comma-separated list of user collaborator IDs by status"), @WritesAttribute(attribute="box.collaborations.<status>.groups.ids", description="Comma-separated list of group collaborator IDs by status"), @WritesAttribute(attribute="box.collaborations.<status>.users.emails", description="Comma-separated list of user collaborator emails by status"), @WritesAttribute(attribute="box.collaborations.<status>.groups.emails", description="Comma-separated list of group collaborator emails by status"), @WritesAttribute(attribute="box.collaborations.<status>.<role>.users.ids", description="Comma-separated list of user collaborator IDs by status and role. Only present when both Roles and Statuses properties are set."), @WritesAttribute(attribute="box.collaborations.<status>.<role>.users.logins", description="Comma-separated list of user collaborator logins by status and role. Only present when both Roles and Statuses properties are set."), @WritesAttribute(attribute="box.collaborations.<status>.<role>.groups.ids", description="Comma-separated list of group collaborator IDs by status and role. Only present when both Roles and Statuses properties are set."), @WritesAttribute(attribute="box.collaborations.<status>.<role>.groups.emails", description="Comma-separated list of group collaborator emails by status and role. Only present when both Roles and Statuses properties are set."), @WritesAttribute(attribute="box.collaborations.count", description="Total number of collaborations on the file"), @WritesAttribute(attribute="error.code", description="The error code returned by Box"), @WritesAttribute(attribute="error.message", description="The error message returned by Box")})
public class GetBoxFileCollaborators
extends AbstractProcessor {
    public static final PropertyDescriptor FILE_ID = new PropertyDescriptor.Builder().name("File ID").description("The ID of the Box file to retrieve collaborators for").required(true).defaultValue("${box.id}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor ROLES = new PropertyDescriptor.Builder().name("Roles").description("A comma-separated list of collaboration roles to retrieve. Available roles: editor, viewer, previewer, uploader, previewer uploader, viewer uploader, co-owner, owner. If not specified, no filtering by role will be applied.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor STATUSES = new PropertyDescriptor.Builder().name("Statuses").description("A comma-separated list of collaboration statuses to retrieve. Available statuses: accepted, pending, rejected. If not specified, no filtering by status will be applied.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles that have been successfully processed will be routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles that encounter errors during processing will be routed to this relationship").build();
    public static final Relationship REL_NOT_FOUND = new Relationship.Builder().name("not.found").description("FlowFiles for which the specified Box file was not found").build();
    public static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE, REL_NOT_FOUND);
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BoxClientService.BOX_CLIENT_SERVICE, FILE_ID, ROLES, STATUSES);
    private volatile BoxAPIConnection boxAPIConnection;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        BoxClientService boxClientService = (BoxClientService)context.getProperty(BoxClientService.BOX_CLIENT_SERVICE).asControllerService(BoxClientService.class);
        this.boxAPIConnection = boxClientService.getBoxApiConnection();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String fileId = context.getProperty(FILE_ID).evaluateAttributeExpressions(flowFile).getValue();
        String roles = null;
        if (context.getProperty(ROLES).isSet()) {
            roles = context.getProperty(ROLES).evaluateAttributeExpressions(flowFile).getValue();
        }
        String statuses = null;
        if (context.getProperty(STATUSES).isSet()) {
            statuses = context.getProperty(STATUSES).evaluateAttributeExpressions(flowFile).getValue();
        }
        try {
            flowFile = this.fetchCollaborations(fileId, roles, statuses, session, flowFile);
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (BoxAPIResponseException e) {
            flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
            flowFile = session.putAttribute(flowFile, "error.code", String.valueOf(e.getResponseCode()));
            if (e.getResponseCode() == 404) {
                this.getLogger().warn("Box file with ID {} was not found.", new Object[]{fileId});
                session.transfer(flowFile, REL_NOT_FOUND);
            } else {
                this.getLogger().error("Failed to retrieve Box file collaborations for file [{}]", new Object[]{fileId, e});
                session.transfer(flowFile, REL_FAILURE);
            }
        }
        catch (BoxAPIException e) {
            flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
            flowFile = session.putAttribute(flowFile, "error.code", String.valueOf(e.getResponseCode()));
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    protected BoxFile getBoxFile(String fileId) {
        return new BoxFile(this.boxAPIConnection, fileId);
    }

    private FlowFile fetchCollaborations(String fileId, String roleFilter, String statusFilter, ProcessSession session, FlowFile flowFile) {
        BoxFile boxFile = this.getBoxFile(fileId);
        BoxResourceIterable collaborations = boxFile.getAllFileCollaborations(new String[0]);
        Set<String> allowedRoles = this.parseFilter(roleFilter);
        Set<String> allowedStatuses = this.parseFilter(statusFilter);
        HashMap<String, List<String>> attributeValues = new HashMap<String, List<String>>();
        int count = this.processCollaborations((Iterable<BoxCollaboration.Info>)collaborations, allowedRoles, allowedStatuses, attributeValues);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("box.id", fileId);
        attributes.put("box.collaborations.count", String.valueOf(count));
        attributeValues.forEach((key, values) -> this.addAttributeIfNotEmpty((Map<String, String>)attributes, "box.collaborations." + key, (List<String>)values));
        return session.putAllAttributes(flowFile, attributes);
    }

    private Set<String> parseFilter(String filter) {
        if (filter == null) {
            return null;
        }
        return Arrays.stream(filter.toLowerCase().split(",")).map(String::trim).collect(Collectors.toSet());
    }

    private int processCollaborations(Iterable<BoxCollaboration.Info> collaborations, Set<String> allowedRoles, Set<String> allowedStatuses, Map<String, List<String>> attributeValues) {
        int count = 0;
        for (BoxCollaboration.Info collab : collaborations) {
            ++count;
            String status = collab.getStatus().toString().toLowerCase();
            String role = GetBoxFileCollaborators.roleToJsonValue(collab.getRole());
            if (allowedRoles != null && !allowedRoles.contains(role) || allowedStatuses != null && !allowedStatuses.contains(status)) continue;
            this.processCollaboration(collab, status, role, allowedRoles != null && allowedStatuses != null, attributeValues);
        }
        return count;
    }

    private void processCollaboration(BoxCollaboration.Info collab, String status, String role, boolean useNewFormat, Map<String, List<String>> attributeValues) {
        String loginKey;
        boolean isUser = collab.getAccessibleBy().getType().equals((Object)BoxCollaborator.CollaboratorType.USER);
        String entityType = isUser ? "users" : "groups";
        String collabId = collab.getAccessibleBy().getID();
        String login = collab.getAccessibleBy().getLogin();
        this.addToMap(attributeValues, status + "." + entityType + ".ids", collabId);
        if (login != null) {
            loginKey = isUser ? status + ".users.emails" : status + ".groups.emails";
            this.addToMap(attributeValues, loginKey, login);
        }
        if (useNewFormat) {
            this.addToMap(attributeValues, status + "." + role + "." + entityType + ".ids", collabId);
            if (login != null) {
                loginKey = isUser ? status + "." + role + ".users.logins" : status + "." + role + ".groups.emails";
                this.addToMap(attributeValues, loginKey, login);
            }
        }
    }

    private void addToMap(Map<String, List<String>> map, String key, String value) {
        map.computeIfAbsent(key, k -> new ArrayList()).add(value);
    }

    private void addAttributeIfNotEmpty(Map<String, String> attributes, String key, List<String> values) {
        if (values != null && !values.isEmpty()) {
            attributes.put(key, String.join((CharSequence)",", values));
        }
    }

    private static String roleToJsonValue(BoxCollaboration.Role role) {
        return switch (role) {
            default -> throw new MatchException(null, null);
            case BoxCollaboration.Role.EDITOR -> "editor";
            case BoxCollaboration.Role.VIEWER -> "viewer";
            case BoxCollaboration.Role.PREVIEWER -> "previewer";
            case BoxCollaboration.Role.UPLOADER -> "uploader";
            case BoxCollaboration.Role.PREVIEWER_UPLOADER -> "previewer uploader";
            case BoxCollaboration.Role.VIEWER_UPLOADER -> "viewer uploader";
            case BoxCollaboration.Role.CO_OWNER -> "co-owner";
            case BoxCollaboration.Role.OWNER -> "owner";
        };
    }
}

