/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.box;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIResponseException;
import com.box.sdk.MetadataTemplate;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.box.controllerservices.BoxClientService;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.box.ListBoxFileMetadataTemplates;
import org.apache.nifi.processors.box.UpdateBoxFileMetadataInstance;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.record.Record;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"box", "storage", "metadata", "templates", "create"})
@CapabilityDescription(value=" Creates a Box metadata template using field specifications from the flowFile content. Expects a schema with fields: \n \"'type' (required), 'key' (required), 'displayName' (optional), 'description' (optional), 'hidden' (optional, boolean).\n")
@SeeAlso(value={ListBoxFileMetadataTemplates.class, UpdateBoxFileMetadataInstance.class})
@WritesAttributes(value={@WritesAttribute(attribute="box.template.name", description="The template name that was created"), @WritesAttribute(attribute="box.template.key", description="The template key that was created"), @WritesAttribute(attribute="box.template.scope", description="The template scope."), @WritesAttribute(attribute="box.template.fields.count", description="Number of fields created for the template"), @WritesAttribute(attribute="error.code", description="The error code returned by Box"), @WritesAttribute(attribute="error.message", description="The error message returned by Box")})
public class CreateBoxMetadataTemplate
extends AbstractProcessor {
    public static final String SCOPE_ENTERPRISE = "enterprise";
    private static final Set<String> VALID_FIELD_TYPES = new HashSet<String>(Arrays.asList("string", "float", "date", "enum", "multiSelect"));
    public static final PropertyDescriptor TEMPLATE_NAME = new PropertyDescriptor.Builder().name("Template Name").description("The display name of the metadata template to create.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor TEMPLATE_KEY = new PropertyDescriptor.Builder().name("Template Key").description("The key of the metadata template to create (used for API calls).").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor HIDDEN = new PropertyDescriptor.Builder().name("Hidden").description("Whether the template should be hidden in the Box UI.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor RECORD_READER = new PropertyDescriptor.Builder().name("Record Reader").description("The Record Reader to use for parsing the incoming data").required(true).identifiesControllerService(RecordReaderFactory.class).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile is routed to this relationship after a template has been successfully created.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile is routed to this relationship if an error occurs during template creation.").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BoxClientService.BOX_CLIENT_SERVICE, TEMPLATE_NAME, TEMPLATE_KEY, HIDDEN, RECORD_READER);
    private volatile BoxAPIConnection boxAPIConnection;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.boxAPIConnection = this.getBoxAPIConnection(context);
    }

    protected BoxAPIConnection getBoxAPIConnection(ProcessContext context) {
        BoxClientService boxClientService = (BoxClientService)context.getProperty(BoxClientService.BOX_CLIENT_SERVICE).asControllerService(BoxClientService.class);
        return boxClientService.getBoxApiConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String templateName = context.getProperty(TEMPLATE_NAME).evaluateAttributeExpressions(flowFile).getValue();
        String templateKey = context.getProperty(TEMPLATE_KEY).evaluateAttributeExpressions(flowFile).getValue();
        boolean hidden = Boolean.parseBoolean(context.getProperty(HIDDEN).evaluateAttributeExpressions(flowFile).getValue());
        RecordReaderFactory recordReaderFactory = (RecordReaderFactory)context.getProperty(RECORD_READER).asControllerService(RecordReaderFactory.class);
        try (InputStream inputStream = session.read(flowFile);
             RecordReader recordReader = recordReaderFactory.createRecordReader(flowFile, inputStream, this.getLogger());){
            ArrayList<MetadataTemplate.Field> fields = new ArrayList<MetadataTemplate.Field>();
            ArrayList<String> errors = new ArrayList<String>();
            HashSet<String> processedKeys = new HashSet<String>();
            try {
                Record record;
                while ((record = recordReader.nextRecord()) != null) {
                    this.processRecord(record, fields, processedKeys, errors);
                }
            }
            catch (Exception e) {
                this.getLogger().error("Error processing record: {}", new Object[]{e.getMessage(), e});
                errors.add("Error processing record: " + e.getMessage());
            }
            if (!errors.isEmpty()) {
                flowFile = session.putAttribute(flowFile, "error.message", String.join((CharSequence)", ", errors));
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
            if (fields.isEmpty()) {
                flowFile = session.putAttribute(flowFile, "error.message", "No valid metadata field specifications found in the input");
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
            this.createBoxMetadataTemplate(this.boxAPIConnection, templateKey, templateName, hidden, fields);
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("box.template.name", templateName);
            attributes.put("box.template.key", templateKey);
            attributes.put("box.template.scope", SCOPE_ENTERPRISE);
            attributes.put("box.template.fields.count", String.valueOf(fields.size()));
            flowFile = session.putAllAttributes(flowFile, attributes);
            session.getProvenanceReporter().create(flowFile, "Created Box metadata template: " + templateName);
            session.transfer(flowFile, REL_SUCCESS);
            return;
        }
        catch (BoxAPIResponseException e) {
            flowFile = session.putAttribute(flowFile, "error.code", String.valueOf(e.getResponseCode()));
            flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
            this.getLogger().error("Couldn't create metadata template with name [{}]", new Object[]{templateName, e});
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        catch (Exception e) {
            this.getLogger().error("Error processing metadata template creation", (Throwable)e);
            flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private void processRecord(Record record, List<MetadataTemplate.Field> fields, Set<String> processedKeys, List<String> errors) {
        Object optionsObj;
        Object descriptionObj;
        Object hiddenObj;
        Object keyObj = record.getValue("key");
        if (keyObj == null) {
            errors.add("Record is missing a key field");
            return;
        }
        String key = keyObj.toString();
        if (processedKeys.contains(key)) {
            errors.add("Duplicate key '" + key + "' found in record, failing template creation");
            return;
        }
        Object typeObj = record.getValue("type");
        if (typeObj == null) {
            errors.add("Record with key '" + key + "' is missing a type field");
            return;
        }
        String normalizedType = typeObj.toString().toLowerCase();
        if (!VALID_FIELD_TYPES.contains(normalizedType)) {
            errors.add("Record with key '" + key + "' has an invalid type: '" + normalizedType + "'. Valid types are: " + String.join((CharSequence)", ", VALID_FIELD_TYPES));
            return;
        }
        MetadataTemplate.Field metadataField = new MetadataTemplate.Field();
        metadataField.setKey(key);
        metadataField.setType(normalizedType);
        Object displayNameObj = record.getValue("displayName");
        if (displayNameObj != null) {
            metadataField.setDisplayName(displayNameObj.toString());
        }
        if ((hiddenObj = record.getValue("hidden")) != null) {
            metadataField.setIsHidden(Boolean.parseBoolean(hiddenObj.toString()));
        }
        if ((descriptionObj = record.getValue("description")) != null) {
            metadataField.setDescription(descriptionObj.toString());
        }
        if (("enum".equals(normalizedType) || "multiSelect".equals(normalizedType)) && (optionsObj = record.getValue("options")) instanceof List) {
            List optionsList = (List)optionsObj;
            List<String> options = optionsList.stream().map(obj -> {
                if (obj == null) {
                    throw new IllegalArgumentException("Null option value found for field '" + key + "'");
                }
                return obj.toString();
            }).toList();
            metadataField.setOptions(options);
        }
        fields.add(metadataField);
        processedKeys.add(key);
    }

    protected void createBoxMetadataTemplate(BoxAPIConnection boxAPIConnection, String templateKey, String templateName, boolean isHidden, List<MetadataTemplate.Field> fields) {
        MetadataTemplate.createMetadataTemplate((BoxAPIConnection)boxAPIConnection, (String)SCOPE_ENTERPRISE, (String)templateKey, (String)templateName, (boolean)isHidden, fields);
    }
}

