/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.box;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;

final class BoxMetadataJsonArrayWriter
implements Closeable {
    private final Writer writer;
    private boolean hasBegun;
    private boolean hasEntries;
    private boolean closed;

    private BoxMetadataJsonArrayWriter(Writer writer) {
        this.writer = writer;
        this.hasBegun = false;
        this.hasEntries = false;
        this.closed = false;
    }

    static BoxMetadataJsonArrayWriter create(OutputStream outputStream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        return new BoxMetadataJsonArrayWriter(writer);
    }

    void write(Map<String, Object> templateFields) throws IOException {
        if (this.closed) {
            throw new IOException("The Writer is closed");
        }
        if (!this.hasBegun) {
            this.beginArray();
            this.hasBegun = true;
        }
        if (this.hasEntries) {
            this.writer.write(44);
        }
        JsonObject json = this.toRecord(templateFields);
        json.writeTo(this.writer);
        this.hasEntries = true;
    }

    private JsonObject toRecord(Map<String, Object> templateFields) {
        JsonObject json = Json.object();
        for (Map.Entry<String, Object> entry : templateFields.entrySet()) {
            Object value = entry.getValue();
            if (value == null) {
                json.add(entry.getKey(), Json.NULL);
                continue;
            }
            json.add(entry.getKey(), Json.value((String)value.toString()));
        }
        return json;
    }

    private void beginArray() throws IOException {
        this.writer.write(91);
    }

    private void endArray() throws IOException {
        this.writer.write(93);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.hasBegun) {
            this.beginArray();
        }
        this.endArray();
        this.writer.close();
    }
}

