/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.box;

import com.box.sdk.BoxFile;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxResource;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.flowfile.attributes.CoreAttributes;

public final class BoxFileUtils {
    public static final String BOX_URL = "https://app.box.com/file/";

    public static String getParentIds(BoxItem.Info info) {
        return info.getPathCollection().stream().map(BoxResource.Info::getID).collect(Collectors.joining(","));
    }

    public static String getParentPath(BoxItem.Info info) {
        return "/" + info.getPathCollection().stream().filter(pathItemInfo -> !pathItemInfo.getID().equals("0")).map(BoxItem.Info::getName).collect(Collectors.joining("/"));
    }

    public static String getFolderPath(BoxFolder.Info folderInfo) {
        String parentFolderPath = BoxFileUtils.getParentPath((BoxItem.Info)folderInfo);
        return "/".equals(parentFolderPath) ? parentFolderPath + folderInfo.getName() : parentFolderPath + "/" + folderInfo.getName();
    }

    public static Map<String, String> createAttributeMap(BoxFile.Info fileInfo) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("box.id", fileInfo.getID());
        attributes.put(CoreAttributes.FILENAME.key(), fileInfo.getName());
        attributes.put(CoreAttributes.PATH.key(), BoxFileUtils.getParentPath((BoxItem.Info)fileInfo));
        attributes.put("box.timestamp", String.valueOf(fileInfo.getModifiedAt()));
        attributes.put("box.size", String.valueOf(fileInfo.getSize()));
        return attributes;
    }
}

