/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.box;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIResponseException;
import com.box.sdk.BoxFile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.box.controllerservices.BoxClientService;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.box.BoxFileUtils;
import org.apache.nifi.processors.box.FetchBoxFile;
import org.apache.nifi.processors.box.ListBoxFile;
import org.apache.nifi.processors.box.PutBoxFile;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"box", "storage", "metadata", "fetch"})
@CapabilityDescription(value="Fetches metadata for files from Box and adds it to the FlowFile's attributes.")
@SeeAlso(value={ListBoxFile.class, FetchBoxFile.class, PutBoxFile.class})
@WritesAttributes(value={@WritesAttribute(attribute="box.id", description="The id of the file"), @WritesAttribute(attribute="filename", description="The name of the file"), @WritesAttribute(attribute="path", description="The folder path where the file is located"), @WritesAttribute(attribute="box.size", description="The size of the file"), @WritesAttribute(attribute="box.timestamp", description="The last modified time of the file"), @WritesAttribute(attribute="box.created.at", description="The creation date of the file"), @WritesAttribute(attribute="box.owner", description="The owner of the file"), @WritesAttribute(attribute="box.description", description="The description of the file"), @WritesAttribute(attribute="box.etag", description="The etag of the file"), @WritesAttribute(attribute="box.sha1", description="The SHA-1 hash of the file"), @WritesAttribute(attribute="box.content.created.at", description="The date the content was created"), @WritesAttribute(attribute="box.content.modified.at", description="The date the content was modified"), @WritesAttribute(attribute="box.item.status", description="The status of the file (active, trashed, etc.)"), @WritesAttribute(attribute="box.sequence_id", description="The sequence ID of the file"), @WritesAttribute(attribute="box.parent.folder.id", description="The ID of the parent folder"), @WritesAttribute(attribute="box.trashed.at", description="The date the file was trashed, if applicable"), @WritesAttribute(attribute="box.purged.at", description="The date the file was purged, if applicable"), @WritesAttribute(attribute="box.shared.link", description="The shared link of the file, if any"), @WritesAttribute(attribute="error.code", description="The error code returned by Box"), @WritesAttribute(attribute="error.message", description="The error message returned by Box")})
public class FetchBoxFileInfo
extends AbstractProcessor {
    public static final PropertyDescriptor FILE_ID = new PropertyDescriptor.Builder().name("File ID").description("The ID of the File to fetch metadata for").required(true).defaultValue("${box.id}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile will be routed here after successfully fetching the file metadata.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile will be routed here if fetching the file metadata fails.").build();
    static final Relationship REL_NOT_FOUND = new Relationship.Builder().name("not.found").description("FlowFiles for which the specified Box file was not found.").build();
    public static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE, REL_NOT_FOUND);
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BoxClientService.BOX_CLIENT_SERVICE, FILE_ID);
    private volatile BoxAPIConnection boxAPIConnection;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        BoxClientService boxClientService = (BoxClientService)context.getProperty(BoxClientService.BOX_CLIENT_SERVICE).asControllerService(BoxClientService.class);
        this.boxAPIConnection = boxClientService.getBoxApiConnection();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String fileId = context.getProperty(FILE_ID).evaluateAttributeExpressions(flowFile).getValue();
        try {
            flowFile = this.fetchFileMetadata(fileId, session, flowFile);
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (BoxAPIResponseException e) {
            flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
            flowFile = session.putAttribute(flowFile, "error.code", String.valueOf(e.getResponseCode()));
            if (e.getResponseCode() == 404) {
                this.getLogger().warn("Box file with ID {} was not found.", new Object[]{fileId});
                session.transfer(flowFile, REL_NOT_FOUND);
            } else {
                this.getLogger().error("Failed to retrieve Box file representation for file [{}]", new Object[]{fileId, e});
                session.transfer(flowFile, REL_FAILURE);
            }
        }
        catch (BoxAPIException e) {
            flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
            flowFile = session.putAttribute(flowFile, "error.code", String.valueOf(e.getResponseCode()));
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    protected BoxFile getBoxFile(String fileId) {
        return new BoxFile(this.boxAPIConnection, fileId);
    }

    private FlowFile fetchFileMetadata(String fileId, ProcessSession session, FlowFile flowFile) {
        BoxFile boxFile = this.getBoxFile(fileId);
        BoxFile.Info fileInfo = boxFile.getInfo(new String[]{"name", "description", "size", "created_at", "modified_at", "owned_by", "parent", "etag", "sha1", "item_status", "sequence_id", "path_collection", "content_created_at", "content_modified_at", "trashed_at", "purged_at", "shared_link"});
        HashMap<String, String> attributes = new HashMap<String, String>(BoxFileUtils.createAttributeMap(fileInfo));
        this.addAttributeIfNotNull(attributes, "box.description", fileInfo.getDescription());
        this.addAttributeIfNotNull(attributes, "box.etag", fileInfo.getEtag());
        this.addAttributeIfNotNull(attributes, "box.sha1", fileInfo.getSha1());
        this.addAttributeIfNotNull(attributes, "box.content.created.at", fileInfo.getContentCreatedAt());
        this.addAttributeIfNotNull(attributes, "box.content.modified.at", fileInfo.getContentModifiedAt());
        this.addAttributeIfNotNull(attributes, "box.item.status", fileInfo.getItemStatus());
        this.addAttributeIfNotNull(attributes, "box.sequence.id", fileInfo.getSequenceID());
        this.addAttributeIfNotNull(attributes, "box.created.at", fileInfo.getCreatedAt());
        this.addAttributeIfNotNull(attributes, "box.trashed.at", fileInfo.getTrashedAt());
        this.addAttributeIfNotNull(attributes, "box.purged.at", fileInfo.getPurgedAt());
        if (fileInfo.getOwnedBy() != null && fileInfo.getOwnedBy().getName() != null) {
            attributes.put("box.owner", fileInfo.getOwnedBy().getName());
        }
        if (fileInfo.getParent() != null) {
            attributes.put("box.parent.folder.id", fileInfo.getParent().getID());
        }
        if (fileInfo.getSharedLink() != null && fileInfo.getSharedLink().getURL() != null) {
            attributes.put("box.shared.link", fileInfo.getSharedLink().getURL());
        }
        return session.putAllAttributes(flowFile, attributes);
    }

    private void addAttributeIfNotNull(Map<String, String> attributes, String key, Object value) {
        if (value != null) {
            attributes.put(key, String.valueOf(value));
        }
    }
}

