/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.nifi.bootstrap.process.AvailableLocalPorts;
import org.apache.nifi.bootstrap.process.FileHandles;
import org.apache.nifi.bootstrap.process.ForkedProcesses;
import org.apache.nifi.bootstrap.process.RuntimeValidator;
import org.apache.nifi.bootstrap.process.RuntimeValidatorResult;
import org.apache.nifi.bootstrap.process.SocketTimedWaitDuration;
import org.apache.nifi.bootstrap.process.Swappiness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeValidatorExecutor {
    private final List<RuntimeValidator> configurationClasses;
    private static final Logger logger = LoggerFactory.getLogger(RuntimeValidatorExecutor.class);

    public RuntimeValidatorExecutor() {
        this.configurationClasses = Arrays.asList(new AvailableLocalPorts(), new FileHandles(), new ForkedProcesses(), new Swappiness(), new SocketTimedWaitDuration());
    }

    RuntimeValidatorExecutor(List<RuntimeValidator> configurationClasses) {
        this.configurationClasses = configurationClasses;
    }

    public List<RuntimeValidatorResult> execute() {
        ArrayList<RuntimeValidatorResult> results = new ArrayList<RuntimeValidatorResult>();
        for (RuntimeValidator configuration : this.configurationClasses) {
            results.addAll(configuration.validate());
        }
        List<RuntimeValidatorResult> failures = results.stream().filter(result -> result.getOutcome().equals((Object)RuntimeValidatorResult.Outcome.FAILED)).collect(Collectors.toList());
        if (!failures.isEmpty()) {
            this.logWarnings(failures);
        }
        return results;
    }

    private void logWarnings(List<RuntimeValidatorResult> results) {
        for (RuntimeValidatorResult result : results) {
            logger.warn("Runtime Configuration [{}] validation failed: {}", (Object)result.getSubject(), (Object)result.getExplanation());
        }
    }
}

