/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.command;

import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.bootstrap.command.BootstrapCommand;
import org.apache.nifi.bootstrap.command.CommandStatus;
import org.apache.nifi.bootstrap.command.io.HttpRequestMethod;
import org.apache.nifi.bootstrap.command.io.ResponseStreamHandler;
import org.apache.nifi.bootstrap.command.process.ManagementServerAddressProvider;
import org.apache.nifi.bootstrap.command.process.ProcessHandleManagementServerAddressProvider;
import org.apache.nifi.bootstrap.command.process.ProcessHandleProvider;
import org.apache.nifi.bootstrap.command.process.VirtualMachineManagementServerAddressProvider;
import org.apache.nifi.bootstrap.configuration.ApplicationClassName;
import org.apache.nifi.bootstrap.configuration.ManagementServerPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ManagementServerBootstrapCommand
implements BootstrapCommand {
    private static final Logger commandLogger = LoggerFactory.getLogger((String)ApplicationClassName.BOOTSTRAP_COMMAND.getName());
    private static final Duration CONNECT_TIMEOUT = Duration.ofSeconds(5L);
    private static final Duration READ_TIMEOUT = Duration.ofSeconds(15L);
    private static final String SERVER_URI = "http://%s%s";
    private static final char QUERY_SEPARATOR = '?';
    private final ProcessHandleProvider processHandleProvider;
    private final HttpRequestMethod httpRequestMethod;
    private final ManagementServerPath managementServerPath;
    private final String managementServerQuery;
    private final int successStatusCode;
    private final ResponseStreamHandler responseStreamHandler;
    private CommandStatus commandStatus = CommandStatus.ERROR;

    ManagementServerBootstrapCommand(ProcessHandleProvider processHandleProvider, ManagementServerPath managementServerPath, ResponseStreamHandler responseStreamHandler) {
        this(processHandleProvider, HttpRequestMethod.GET, managementServerPath, null, 200, responseStreamHandler);
    }

    ManagementServerBootstrapCommand(ProcessHandleProvider processHandleProvider, HttpRequestMethod httpRequestMethod, ManagementServerPath managementServerPath, String managementServerQuery, int successStatusCode, ResponseStreamHandler responseStreamHandler) {
        this.processHandleProvider = Objects.requireNonNull(processHandleProvider);
        this.httpRequestMethod = Objects.requireNonNull(httpRequestMethod);
        this.managementServerPath = Objects.requireNonNull(managementServerPath);
        this.managementServerQuery = managementServerQuery;
        this.successStatusCode = successStatusCode;
        this.responseStreamHandler = Objects.requireNonNull(responseStreamHandler);
    }

    @Override
    public CommandStatus getCommandStatus() {
        return this.commandStatus;
    }

    @Override
    public void run() {
        Optional<ProcessHandle> applicationProcessHandle = this.processHandleProvider.findApplicationProcessHandle();
        if (applicationProcessHandle.isEmpty()) {
            this.commandStatus = CommandStatus.STOPPED;
            this.getCommandLogger().info("Application Process STOPPED");
        } else {
            this.run(applicationProcessHandle.get());
        }
    }

    protected void run(ProcessHandle applicationProcessHandle) {
        ManagementServerAddressProvider managementServerAddressProvider = this.getManagementServerAddressProvider(applicationProcessHandle);
        Optional<String> managementServerAddress = managementServerAddressProvider.getAddress();
        long pid = applicationProcessHandle.pid();
        if (managementServerAddress.isEmpty()) {
            this.getCommandLogger().info("Application Process [{}] Management Server address not found", (Object)pid);
            this.commandStatus = CommandStatus.ERROR;
        } else {
            URI managementServerUri = this.getManagementServerUri(managementServerAddress.get());
            try (HttpClient httpClient = this.getHttpClient();){
                HttpRequest httpRequest = this.getHttpRequest(managementServerUri);
                HttpResponse<InputStream> response = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofInputStream());
                int statusCode = response.statusCode();
                try (InputStream responseStream = response.body();){
                    this.onResponseStatus(applicationProcessHandle, statusCode, responseStream);
                }
            }
            catch (Exception e) {
                this.commandStatus = CommandStatus.COMMUNICATION_FAILED;
                this.getCommandLogger().info("Application Process [{}] Management Server [{}] communication failed", (Object)pid, (Object)managementServerUri);
            }
        }
    }

    protected void onResponseStatus(ProcessHandle applicationProcessHandle, int statusCode, InputStream responseStream) {
        long pid = applicationProcessHandle.pid();
        if (this.successStatusCode == statusCode) {
            this.commandStatus = CommandStatus.SUCCESS;
            this.getCommandLogger().info("Application Process [{}] Command Status [{}] HTTP {}", new Object[]{pid, this.commandStatus, statusCode});
            this.responseStreamHandler.onResponseStream(responseStream);
        } else {
            this.commandStatus = CommandStatus.COMMUNICATION_FAILED;
            this.getCommandLogger().warn("Application Process [{}] Command Status [{}] HTTP {}", new Object[]{pid, this.commandStatus, statusCode});
            this.responseStreamHandler.onResponseStream(responseStream);
        }
    }

    protected Logger getCommandLogger() {
        return commandLogger;
    }

    protected HttpRequest getHttpRequest(URI managementServerUri) {
        return HttpRequest.newBuilder().method(this.httpRequestMethod.name(), HttpRequest.BodyPublishers.noBody()).uri(managementServerUri).timeout(READ_TIMEOUT).build();
    }

    protected URI getManagementServerUri(String managementServerAddress) {
        StringBuilder builder = new StringBuilder();
        String serverUri = SERVER_URI.formatted(managementServerAddress, this.managementServerPath.getPath());
        builder.append(serverUri);
        if (this.managementServerQuery != null) {
            builder.append('?');
            builder.append(this.managementServerQuery);
        }
        return URI.create(builder.toString());
    }

    protected HttpClient getHttpClient() {
        HttpClient.Builder builder = HttpClient.newBuilder();
        builder.connectTimeout(CONNECT_TIMEOUT);
        return builder.build();
    }

    private ManagementServerAddressProvider getManagementServerAddressProvider(ProcessHandle applicationProcessHandle) {
        ProcessHandle.Info applicationProcessHandleInfo = applicationProcessHandle.info();
        Optional<String[]> arguments = applicationProcessHandleInfo.arguments();
        ManagementServerAddressProvider managementServerAddressProvider = arguments.isPresent() ? new ProcessHandleManagementServerAddressProvider(applicationProcessHandle) : new VirtualMachineManagementServerAddressProvider(applicationProcessHandle);
        return managementServerAddressProvider;
    }
}

