/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.command;

import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.bootstrap.command.BootstrapCommand;
import org.apache.nifi.bootstrap.command.CommandStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApplicationProcessStatusBootstrapCommand
implements BootstrapCommand {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationProcessStatusBootstrapCommand.class);
    private final ProcessHandle processHandle;
    private CommandStatus commandStatus = CommandStatus.ERROR;

    ApplicationProcessStatusBootstrapCommand(ProcessHandle processHandle) {
        this.processHandle = Objects.requireNonNull(processHandle);
    }

    @Override
    public CommandStatus getCommandStatus() {
        return this.commandStatus;
    }

    @Override
    public void run() {
        Optional<ProcessHandle> childProcessHandleFound = this.processHandle.children().findFirst();
        if (childProcessHandleFound.isEmpty()) {
            logger.info("Application Process not found");
            this.commandStatus = CommandStatus.STOPPED;
        } else {
            ProcessHandle childProcessHandle = childProcessHandleFound.get();
            if (childProcessHandle.isAlive()) {
                logger.info("Application Process [{}] running", (Object)childProcessHandle.pid());
                this.commandStatus = CommandStatus.SUCCESS;
            } else {
                logger.info("Application Process [{}] stopped", (Object)childProcessHandle.pid());
                this.commandStatus = CommandStatus.COMMUNICATION_FAILED;
            }
        }
    }
}

