/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.util;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;

public final class OSUtils {
    private static Long getUnicesPid(Process process, Logger logger) {
        try {
            Class<?> procClass = process.getClass();
            Field pidField = procClass.getDeclaredField("pid");
            pidField.setAccessible(true);
            Object pidObject = pidField.get(process);
            logger.debug("PID Object = {}", pidObject);
            if (pidObject instanceof Number) {
                return ((Number)pidObject).longValue();
            }
            return null;
        }
        catch (IllegalAccessException | NoSuchFieldException nsfe) {
            logger.debug("Could not find PID for child process due to {}", (Throwable)nsfe);
            return null;
        }
    }

    private static Long getWindowsProcessId(Process process, Logger logger) {
        try {
            Field f = process.getClass().getDeclaredField("handle");
            f.setAccessible(true);
            long handl = f.getLong(process);
            Kernel32 kernel = Kernel32.INSTANCE;
            WinNT.HANDLE handle = new WinNT.HANDLE();
            handle.setPointer(Pointer.createConstant((long)handl));
            int ret = kernel.GetProcessId(handle);
            logger.debug("Detected pid: {}", (Object)ret);
            return ret;
        }
        catch (IllegalAccessException | NoSuchFieldException nsfe) {
            logger.debug("Could not find PID for child process due to {}", (Throwable)nsfe);
            return null;
        }
    }

    public static Long getProcessId(Process process, Logger logger) {
        Long pid;
        block8: {
            pid = null;
            if (!System.getProperty("java.version").startsWith("1.")) {
                try {
                    Method pidMethod = process.getClass().getMethod("pid", new Class[0]);
                    pidMethod.setAccessible(true);
                    Object pidMethodResult = pidMethod.invoke((Object)process, new Object[0]);
                    if (Long.class.isAssignableFrom(pidMethodResult.getClass())) {
                        pid = (Long)pidMethodResult;
                        break block8;
                    }
                    logger.debug("Could not determine PID for child process because returned PID was not assignable to type " + Long.class.getName());
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    logger.debug("Could not find PID for child process due to {}", (Throwable)e);
                }
            } else if (process.getClass().getName().equals("java.lang.UNIXProcess")) {
                pid = OSUtils.getUnicesPid(process, logger);
            } else if (process.getClass().getName().equals("java.lang.Win32Process") || process.getClass().getName().equals("java.lang.ProcessImpl")) {
                pid = OSUtils.getWindowsProcessId(process, logger);
            }
        }
        return pid;
    }
}

