/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.notification.email;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.nifi.bootstrap.notification.AbstractNotificationService;
import org.apache.nifi.bootstrap.notification.NotificationContext;
import org.apache.nifi.bootstrap.notification.NotificationFailedException;
import org.apache.nifi.bootstrap.notification.NotificationType;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

public class EmailNotificationService
extends AbstractNotificationService {
    public static final PropertyDescriptor SMTP_HOSTNAME = new PropertyDescriptor.Builder().name("SMTP Hostname").description("The hostname of the SMTP Server that is used to send Email Notifications").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).build();
    public static final PropertyDescriptor SMTP_PORT = new PropertyDescriptor.Builder().name("SMTP Port").description("The Port used for SMTP communications").required(true).defaultValue("25").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.PORT_VALIDATOR).build();
    public static final PropertyDescriptor SMTP_USERNAME = new PropertyDescriptor.Builder().name("SMTP Username").description("Username for the SMTP account").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).build();
    public static final PropertyDescriptor SMTP_PASSWORD = new PropertyDescriptor.Builder().name("SMTP Password").description("Password for the SMTP account").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).sensitive(true).build();
    public static final PropertyDescriptor SMTP_AUTH = new PropertyDescriptor.Builder().name("SMTP Auth").description("Flag indicating whether authentication should be used").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.BOOLEAN_VALIDATOR).defaultValue("true").build();
    public static final PropertyDescriptor SMTP_TLS = new PropertyDescriptor.Builder().name("SMTP TLS").description("Flag indicating whether TLS should be enabled").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.BOOLEAN_VALIDATOR).defaultValue("false").build();
    public static final PropertyDescriptor SMTP_SOCKET_FACTORY = new PropertyDescriptor.Builder().name("SMTP Socket Factory").description("Socket Factory to use for SMTP Connection").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("javax.net.ssl.SSLSocketFactory").build();
    public static final PropertyDescriptor HEADER_XMAILER = new PropertyDescriptor.Builder().name("SMTP X-Mailer Header").description("X-Mailer used in the header of the outgoing email").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("NiFi").build();
    public static final PropertyDescriptor CONTENT_TYPE = new PropertyDescriptor.Builder().name("Content Type").description("Mime Type used to interpret the contents of the email, such as text/plain or text/html").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("text/plain").build();
    public static final PropertyDescriptor FROM = new PropertyDescriptor.Builder().name("From").description("Specifies the Email address to use as the sender").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor TO = new PropertyDescriptor.Builder().name("To").description("The recipients to include in the To-Line of the email").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor CC = new PropertyDescriptor.Builder().name("CC").description("The recipients to include in the CC-Line of the email").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor BCC = new PropertyDescriptor.Builder().name("BCC").description("The recipients to include in the BCC-Line of the email").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private static final Map<String, PropertyDescriptor> propertyToContext = new HashMap<String, PropertyDescriptor>();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(SMTP_HOSTNAME);
        properties.add(SMTP_PORT);
        properties.add(SMTP_USERNAME);
        properties.add(SMTP_PASSWORD);
        properties.add(SMTP_AUTH);
        properties.add(SMTP_TLS);
        properties.add(SMTP_SOCKET_FACTORY);
        properties.add(HEADER_XMAILER);
        properties.add(CONTENT_TYPE);
        properties.add(FROM);
        properties.add(TO);
        properties.add(CC);
        properties.add(BCC);
        return properties;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> errors = new ArrayList<ValidationResult>(super.customValidate(context));
        String to = context.getProperty(TO).getValue();
        String cc = context.getProperty(CC).getValue();
        String bcc = context.getProperty(BCC).getValue();
        if (to == null && cc == null && bcc == null) {
            errors.add(new ValidationResult.Builder().subject("To, CC, BCC").valid(false).explanation("Must specify at least one To/CC/BCC address").build());
        }
        return errors;
    }

    @Override
    public void notify(NotificationContext context, NotificationType notificationType, String subject, String messageText) throws NotificationFailedException {
        Properties properties = this.getMailProperties(context);
        Session mailSession = this.createMailSession(properties);
        MimeMessage message = new MimeMessage(mailSession);
        try {
            message.setFrom((Address)InternetAddress.parse((String)context.getProperty(FROM).evaluateAttributeExpressions().getValue())[0]);
            InternetAddress[] toAddresses = EmailNotificationService.toInetAddresses(context.getProperty(TO).evaluateAttributeExpressions().getValue());
            message.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
            InternetAddress[] ccAddresses = EmailNotificationService.toInetAddresses(context.getProperty(CC).evaluateAttributeExpressions().getValue());
            message.setRecipients(Message.RecipientType.CC, (Address[])ccAddresses);
            InternetAddress[] bccAddresses = EmailNotificationService.toInetAddresses(context.getProperty(BCC).evaluateAttributeExpressions().getValue());
            message.setRecipients(Message.RecipientType.BCC, (Address[])bccAddresses);
            message.setHeader("X-Mailer", context.getProperty(HEADER_XMAILER).evaluateAttributeExpressions().getValue());
            message.setSubject(subject);
            String contentType = context.getProperty(CONTENT_TYPE).evaluateAttributeExpressions().getValue();
            message.setContent((Object)messageText, contentType);
            message.setSentDate(new Date());
            Transport.send((Message)message);
        }
        catch (MessagingException | ProcessException e) {
            throw new NotificationFailedException("Failed to send E-mail Notification", e);
        }
    }

    private static InternetAddress[] toInetAddresses(String val) throws AddressException {
        if (val == null) {
            return new InternetAddress[0];
        }
        return InternetAddress.parse((String)val);
    }

    private Properties getMailProperties(NotificationContext context) {
        Properties properties = new Properties();
        for (Map.Entry<String, PropertyDescriptor> entry : propertyToContext.entrySet()) {
            String property = entry.getKey();
            String propValue = context.getProperty(entry.getValue()).evaluateAttributeExpressions().getValue();
            if (null == propValue) continue;
            properties.setProperty(property, propValue);
        }
        return properties;
    }

    private Session createMailSession(final Properties properties) {
        String authValue = properties.getProperty("mail.smtp.auth");
        Boolean auth = Boolean.valueOf(authValue);
        Session mailSession = auth != false ? Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                String username = properties.getProperty("mail.smtp.user");
                String password = properties.getProperty("mail.smtp.password");
                return new PasswordAuthentication(username, password);
            }
        }) : Session.getInstance((Properties)properties);
        return mailSession;
    }

    static {
        propertyToContext.put("mail.smtp.host", SMTP_HOSTNAME);
        propertyToContext.put("mail.smtp.port", SMTP_PORT);
        propertyToContext.put("mail.smtp.socketFactory.port", SMTP_PORT);
        propertyToContext.put("mail.smtp.socketFactory.class", SMTP_SOCKET_FACTORY);
        propertyToContext.put("mail.smtp.auth", SMTP_AUTH);
        propertyToContext.put("mail.smtp.starttls.enable", SMTP_TLS);
        propertyToContext.put("mail.smtp.user", SMTP_USERNAME);
        propertyToContext.put("mail.smtp.password", SMTP_PASSWORD);
    }
}

