/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.bootstrap.BootstrapCodec;
import org.apache.nifi.bootstrap.RunNiFi;
import org.apache.nifi.bootstrap.util.LimitingInputStream;

public class NiFiListener {
    private ServerSocket serverSocket;
    private volatile Listener listener;

    int start(RunNiFi runner) throws IOException {
        this.serverSocket = new ServerSocket();
        this.serverSocket.bind(new InetSocketAddress("localhost", 0));
        int localPort = this.serverSocket.getLocalPort();
        this.listener = new Listener(this.serverSocket, runner);
        Thread listenThread = new Thread(this.listener);
        listenThread.setName("Listen to NiFi");
        listenThread.setDaemon(true);
        listenThread.start();
        return localPort;
    }

    public void stop() throws IOException {
        Listener listener = this.listener;
        if (listener == null) {
            return;
        }
        listener.stop();
    }

    private class Listener
    implements Runnable {
        private final ServerSocket serverSocket;
        private final ExecutorService executor;
        private final RunNiFi runner;
        private volatile boolean stopped = false;

        public Listener(ServerSocket serverSocket, RunNiFi runner) {
            this.serverSocket = serverSocket;
            this.executor = Executors.newFixedThreadPool(2, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread t = Executors.defaultThreadFactory().newThread(runnable);
                    t.setDaemon(true);
                    t.setName("NiFi Bootstrap Command Listener");
                    return t;
                }
            });
            this.runner = runner;
        }

        public void stop() throws IOException {
            this.stopped = true;
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.serverSocket.close();
        }

        @Override
        public void run() {
            while (!this.serverSocket.isClosed()) {
                try {
                    Socket socket;
                    if (this.stopped) {
                        return;
                    }
                    try {
                        socket = this.serverSocket.accept();
                    }
                    catch (IOException ioe) {
                        if (this.stopped) {
                            return;
                        }
                        throw ioe;
                    }
                    this.executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                LimitingInputStream limitingIn = new LimitingInputStream(socket.getInputStream(), 4096L);
                                BootstrapCodec codec = new BootstrapCodec(Listener.this.runner, limitingIn, socket.getOutputStream());
                                codec.communicate();
                            }
                            catch (Throwable t) {
                                System.out.println("Failed to communicate with NiFi due to " + t);
                                t.printStackTrace();
                            }
                            finally {
                                try {
                                    socket.close();
                                }
                                catch (IOException limitingIn) {}
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    System.err.println("Failed to receive information from NiFi due to " + t);
                    t.printStackTrace();
                }
            }
        }
    }
}

