/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.notification.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.nifi.bootstrap.notification.AbstractNotificationService;
import org.apache.nifi.bootstrap.notification.NotificationContext;
import org.apache.nifi.bootstrap.notification.NotificationFailedException;
import org.apache.nifi.bootstrap.notification.NotificationInitializationContext;
import org.apache.nifi.bootstrap.notification.NotificationType;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.util.Tuple;

public class HttpNotificationService
extends AbstractNotificationService {
    public static final String NOTIFICATION_TYPE_KEY = "notification.type";
    public static final String NOTIFICATION_SUBJECT_KEY = "notification.subject";
    public static final String STORE_TYPE_JKS = "JKS";
    public static final String STORE_TYPE_PKCS12 = "PKCS12";
    public static final PropertyDescriptor PROP_URL = new PropertyDescriptor.Builder().name("URL").description("The URL to send the notification to.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.URL_VALIDATOR).build();
    public static final PropertyDescriptor PROP_CONNECTION_TIMEOUT = new PropertyDescriptor.Builder().name("Connection timeout").description("Max wait time for connection to remote service.").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("10s").build();
    public static final PropertyDescriptor PROP_WRITE_TIMEOUT = new PropertyDescriptor.Builder().name("Write timeout").description("Max wait time for remote service to read the request sent.").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("10s").build();
    public static final PropertyDescriptor PROP_TRUSTSTORE = new PropertyDescriptor.Builder().name("Truststore Filename").description("The fully-qualified filename of the Truststore").addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor PROP_TRUSTSTORE_TYPE = new PropertyDescriptor.Builder().name("Truststore Type").description("The Type of the Truststore. Either JKS or PKCS12").allowableValues(new String[]{"JKS", "PKCS12"}).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor PROP_TRUSTSTORE_PASSWORD = new PropertyDescriptor.Builder().name("Truststore Password").description("The password for the Truststore").defaultValue(null).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor PROP_KEYSTORE = new PropertyDescriptor.Builder().name("Keystore Filename").description("The fully-qualified filename of the Keystore").defaultValue(null).addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor PROP_KEYSTORE_TYPE = new PropertyDescriptor.Builder().name("Keystore Type").description("The Type of the Keystore").allowableValues(new String[]{"JKS", "PKCS12"}).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor PROP_KEYSTORE_PASSWORD = new PropertyDescriptor.Builder().name("Keystore Password").defaultValue(null).description("The password for the Keystore").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor PROP_KEY_PASSWORD = new PropertyDescriptor.Builder().name("Key Password").displayName("Key Password").description("The password for the key. If this is not specified, but the Keystore Filename, Password, and Type are specified, then the Keystore Password will be assumed to be the same as the Key Password.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor SSL_ALGORITHM = new PropertyDescriptor.Builder().name("SSL Protocol").defaultValue("TLS").allowableValues(new String[]{"SSL", "TLS"}).description("The algorithm to use for this SSL context.").sensitive(false).build();
    private final AtomicReference<OkHttpClient> httpClientReference = new AtomicReference();
    private final AtomicReference<String> urlReference = new AtomicReference();
    private static final List<PropertyDescriptor> supportedProperties = new ArrayList<PropertyDescriptor>();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return supportedProperties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().required(false).name(propertyDescriptorName).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).dynamic(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    }

    @Override
    protected void init(NotificationInitializationContext context) {
        String url = context.getProperty(PROP_URL).evaluateAttributeExpressions().getValue();
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("Property, \"" + PROP_URL.getDisplayName() + "\", for the URL to POST notifications to must be set.");
        }
        this.urlReference.set(url);
        this.httpClientReference.set(null);
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        Long connectTimeout = context.getProperty(PROP_CONNECTION_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS);
        Long writeTimeout = context.getProperty(PROP_WRITE_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS);
        okHttpClientBuilder.connectTimeout(connectTimeout.longValue(), TimeUnit.MILLISECONDS);
        okHttpClientBuilder.writeTimeout(writeTimeout.longValue(), TimeUnit.MILLISECONDS);
        if (url.toLowerCase().startsWith("https")) {
            try {
                Tuple sslContextTuple = SslContextFactory.createTrustSslContextWithTrustManagers((String)context.getProperty(PROP_KEYSTORE).getValue(), (char[])(context.getProperty(PROP_KEYSTORE_PASSWORD).isSet() ? context.getProperty(PROP_KEYSTORE_PASSWORD).getValue().toCharArray() : null), (char[])(context.getProperty(PROP_KEY_PASSWORD).isSet() ? context.getProperty(PROP_KEY_PASSWORD).getValue().toCharArray() : null), (String)context.getProperty(PROP_KEYSTORE_TYPE).getValue(), (String)context.getProperty(PROP_TRUSTSTORE).getValue(), (char[])(context.getProperty(PROP_TRUSTSTORE_PASSWORD).isSet() ? context.getProperty(PROP_TRUSTSTORE_PASSWORD).getValue().toCharArray() : null), (String)context.getProperty(PROP_TRUSTSTORE_TYPE).getValue(), (SslContextFactory.ClientAuth)SslContextFactory.ClientAuth.REQUIRED, (String)context.getProperty(SSL_ALGORITHM).getValue());
                List x509TrustManagers = Arrays.stream((Object[])sslContextTuple.getValue()).filter(trustManager -> trustManager instanceof X509TrustManager).map(trustManager -> (X509TrustManager)trustManager).collect(Collectors.toList());
                okHttpClientBuilder.sslSocketFactory(((SSLContext)sslContextTuple.getKey()).getSocketFactory(), (X509TrustManager)x509TrustManagers.get(0));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        this.httpClientReference.set(okHttpClientBuilder.build());
    }

    @Override
    public void notify(NotificationContext context, NotificationType notificationType, String subject, String message) throws NotificationFailedException {
        try {
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)message);
            Request.Builder requestBuilder = new Request.Builder().post(requestBody).url(this.urlReference.get());
            Map<PropertyDescriptor, String> configuredProperties = context.getProperties();
            for (PropertyDescriptor propertyDescriptor : configuredProperties.keySet()) {
                if (!propertyDescriptor.isDynamic()) continue;
                String propertyValue = context.getProperty(propertyDescriptor).evaluateAttributeExpressions().getValue();
                requestBuilder = requestBuilder.addHeader(propertyDescriptor.getDisplayName(), propertyValue);
            }
            Request request = requestBuilder.addHeader(NOTIFICATION_SUBJECT_KEY, subject).addHeader(NOTIFICATION_TYPE_KEY, notificationType.name()).build();
            OkHttpClient httpClient = this.httpClientReference.get();
            Call call = httpClient.newCall(request);
            try (Response response = call.execute();){
                if (!response.isSuccessful()) {
                    throw new NotificationFailedException("Failed to send Http Notification. Received an unsuccessful status code response '" + response.code() + "'. The message was '" + response.message() + "'");
                }
            }
        }
        catch (NotificationFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NotificationFailedException("Failed to send Http Notification", e);
        }
    }

    static {
        supportedProperties.add(PROP_URL);
        supportedProperties.add(PROP_CONNECTION_TIMEOUT);
        supportedProperties.add(PROP_WRITE_TIMEOUT);
        supportedProperties.add(PROP_TRUSTSTORE);
        supportedProperties.add(PROP_TRUSTSTORE_PASSWORD);
        supportedProperties.add(PROP_TRUSTSTORE_TYPE);
        supportedProperties.add(PROP_KEYSTORE);
        supportedProperties.add(PROP_KEYSTORE_PASSWORD);
        supportedProperties.add(PROP_KEYSTORE_TYPE);
        supportedProperties.add(PROP_KEY_PASSWORD);
    }
}

