/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util.bin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.bin.Bin;
import org.apache.nifi.processor.util.bin.BinManager;
import org.apache.nifi.processor.util.bin.BinProcessingResult;
import org.apache.nifi.processor.util.bin.EvictionReason;

public abstract class BinFiles
extends AbstractSessionFactoryProcessor {
    public static final PropertyDescriptor MIN_SIZE = new PropertyDescriptor.Builder().name("Minimum Group Size").description("The minimum size for the bundle").required(true).defaultValue("0 B").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    public static final PropertyDescriptor MAX_SIZE = new PropertyDescriptor.Builder().name("Maximum Group Size").description("The maximum size for the bundle. If not specified, there is no maximum.").required(false).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    public static final PropertyDescriptor MIN_ENTRIES = new PropertyDescriptor.Builder().name("Minimum Number of Entries").description("The minimum number of files to include in a bundle").required(true).defaultValue("1").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor MAX_ENTRIES = new PropertyDescriptor.Builder().name("Maximum Number of Entries").description("The maximum number of files to include in a bundle").defaultValue("1000").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor MAX_BIN_COUNT = new PropertyDescriptor.Builder().name("Maximum Number of Bins").description("Specifies the maximum number of bins that can be held in memory at any one time").defaultValue("5").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor MAX_BIN_AGE = new PropertyDescriptor.Builder().name("Max Bin Age").description("The maximum age of a Bin that will trigger a Bin to be complete. Expected format is <duration> <time unit> where <duration> is a positive integer and time unit is one of seconds, minutes, hours").required(false).addValidator(StandardValidators.createTimePeriodValidator((long)1L, (TimeUnit)TimeUnit.SECONDS, (long)Integer.MAX_VALUE, (TimeUnit)TimeUnit.SECONDS)).build();
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("The FlowFiles that were used to create the bundle").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("If the bundle cannot be created, all FlowFiles that would have been used to created the bundle will be transferred to failure").build();
    private final BinManager binManager = new BinManager();
    private final Queue<Bin> readyBins = new LinkedBlockingQueue<Bin>();

    @OnStopped
    public final void resetState() {
        Bin bin;
        this.binManager.purge();
        while ((bin = this.readyBins.poll()) != null) {
            bin.getSession().rollback();
        }
    }

    protected abstract FlowFile preprocessFlowFile(ProcessContext var1, ProcessSession var2, FlowFile var3);

    protected abstract String getGroupId(ProcessContext var1, FlowFile var2, ProcessSession var3);

    protected abstract void setUpBinManager(BinManager var1, ProcessContext var2);

    protected abstract BinProcessingResult processBin(Bin var1, ProcessContext var2) throws ProcessException;

    protected Collection<ValidationResult> additionalCustomValidation(ValidationContext context) {
        return new ArrayList<ValidationResult>();
    }

    public final void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        BinningResult binningResult;
        int maxBinCount;
        int totalBinCount = this.binManager.getBinCount() + this.readyBins.size();
        if (totalBinCount <= (maxBinCount = context.getProperty(MAX_BIN_COUNT).asInteger().intValue())) {
            binningResult = this.binFlowFiles(context, sessionFactory);
            this.getLogger().debug("Binned {} FlowFiles", new Object[]{binningResult.getFlowFilesBinned()});
        } else {
            binningResult = BinningResult.EMPTY;
            this.getLogger().debug("Will not bin any FlowFiles because {} bins already exist; will wait until bins have been emptied before any more are created", new Object[]{totalBinCount});
        }
        if (!this.isScheduled()) {
            return;
        }
        int binsMigrated = this.migrateBins(context, binningResult.getFlowFilesBinned() == 0, binningResult.isNewBinNeeded());
        int binsProcessed = this.processBins(context, sessionFactory);
        if (binningResult.getFlowFilesBinned() == 0 && binsMigrated == 0 && binsProcessed == 0) {
            context.yield();
        }
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("Maximum number of Bins", MAX_BIN_COUNT.getName());
    }

    private int migrateBins(ProcessContext context, boolean relaxFullnessConstraint, boolean newBinNeeded) {
        Bin bin;
        int added = 0;
        for (Bin bin2 : this.binManager.removeReadyBins(relaxFullnessConstraint)) {
            this.readyBins.add(bin2);
            ++added;
        }
        int currentBinCount = this.binManager.getBinCount();
        int maxBinCount = context.getProperty(MAX_BIN_COUNT).asInteger();
        if (added == 0 && (currentBinCount > maxBinCount || currentBinCount == maxBinCount && newBinNeeded) && (bin = this.binManager.removeOldestBin()) != null) {
            ++added;
            bin.setEvictionReason(EvictionReason.BIN_MANAGER_FULL);
            this.readyBins.add(bin);
        }
        return added;
    }

    protected Queue<Bin> getReadyBins() {
        return this.readyBins;
    }

    protected int processBins(ProcessContext context, ProcessSessionFactory sessionFactory) {
        Bin bin;
        ComponentLog logger = this.getLogger();
        int processedBins = 0;
        while (this.isScheduled() && (bin = this.readyBins.poll()) != null) {
            BinProcessingResult binProcessingResult;
            try {
                binProcessingResult = this.processBin(bin, context);
            }
            catch (ProcessException e) {
                logger.error("Failed to process bundle of {} files", new Object[]{bin.getContents().size(), e});
                ProcessSession binSession = bin.getSession();
                for (FlowFile flowFile : bin.getContents()) {
                    binSession.transfer(flowFile, REL_FAILURE);
                }
                binSession.commitAsync();
                continue;
            }
            catch (Exception e) {
                logger.error("Rolling back sessions since failed to process bundle of {} files", new Object[]{bin.getContents().size(), e});
                bin.getSession().rollback();
                continue;
            }
            if (!binProcessingResult.isCommitted()) {
                ProcessSession binSession = bin.getSession();
                if (!context.isAutoTerminated(REL_ORIGINAL)) {
                    bin.getContents().forEach(ff -> binSession.putAllAttributes(ff, binProcessingResult.getAttributes()));
                }
                binSession.transfer(bin.getContents(), REL_ORIGINAL);
                binSession.commitAsync();
            }
            ++processedBins;
        }
        return processedBins;
    }

    private BinningResult binFlowFiles(ProcessContext context, ProcessSessionFactory sessionFactory) {
        List flowFiles;
        int flowFilesBinned = 0;
        ProcessSession session = sessionFactory.createSession();
        int maxBinCount = context.getProperty(MAX_BIN_COUNT).asInteger();
        boolean newBinNeeded = false;
        while (this.binManager.getBinCount() <= maxBinCount && this.isScheduled() && !(flowFiles = session.get(1000)).isEmpty()) {
            LinkedHashMap<String, List> flowFileGroups = new LinkedHashMap<String, List>();
            for (FlowFile flowFile : flowFiles) {
                FlowFile flowFile2 = this.preprocessFlowFile(context, session, flowFile);
                try {
                    String groupingIdentifier = this.getGroupId(context, flowFile2, session);
                    flowFileGroups.computeIfAbsent(groupingIdentifier, id -> new ArrayList()).add(flowFile2);
                }
                catch (Exception e) {
                    this.getLogger().error("Could not determine which Bin to add {} to; will route to failure", new Object[]{flowFile2, e});
                    session.transfer(flowFile2, REL_FAILURE);
                    session.commitAsync();
                }
            }
            for (Map.Entry entry : flowFileGroups.entrySet()) {
                Set<FlowFile> unbinned = this.binManager.offer((String)entry.getKey(), (Collection)entry.getValue(), session, sessionFactory);
                if (!unbinned.isEmpty()) {
                    newBinNeeded = true;
                }
                for (FlowFile flowFile : unbinned) {
                    Bin bin = new Bin(sessionFactory.createSession(), 0L, Long.MAX_VALUE, 0, Integer.MAX_VALUE, null);
                    bin.offer(flowFile, session);
                    this.readyBins.add(bin);
                }
                flowFilesBinned += ((List)entry.getValue()).size();
            }
        }
        return new BinningResult(flowFilesBinned, newBinNeeded);
    }

    @OnScheduled
    public final void onScheduled(ProcessContext context) throws IOException {
        this.binManager.setMinimumSize(this.getMinBytes((PropertyContext)context));
        this.binManager.setMaximumSize(this.getMaxBytes((PropertyContext)context));
        this.binManager.setMaxBinAge(this.getMaxBinAgeSeconds((PropertyContext)context));
        this.binManager.setMinimumEntries(this.getMinEntries((PropertyContext)context));
        this.binManager.setMaximumEntries(this.getMaxEntries((PropertyContext)context));
        this.setUpBinManager(this.binManager, context);
    }

    protected int getMaxBinAgeSeconds(PropertyContext context) {
        if (context.getProperty(MAX_BIN_AGE).isSet()) {
            return context.getProperty(MAX_BIN_AGE).asTimePeriod(TimeUnit.SECONDS).intValue();
        }
        return Integer.MAX_VALUE;
    }

    protected long getMinBytes(PropertyContext context) {
        return context.getProperty(MIN_SIZE).asDataSize(DataUnit.B).longValue();
    }

    protected long getMaxBytes(PropertyContext context) {
        if (context.getProperty(MAX_SIZE).isSet()) {
            return context.getProperty(MAX_SIZE).asDataSize(DataUnit.B).longValue();
        }
        return Long.MAX_VALUE;
    }

    protected int getMinEntries(PropertyContext context) {
        return context.getProperty(MIN_ENTRIES).asInteger();
    }

    protected int getMaxEntries(PropertyContext context) {
        if (context.getProperty(MAX_ENTRIES).isSet()) {
            return context.getProperty(MAX_ENTRIES).asInteger();
        }
        return Integer.MAX_VALUE;
    }

    protected final Collection<ValidationResult> customValidate(ValidationContext context) {
        Collection<ValidationResult> otherProblems;
        int maxEntries;
        int minEntries;
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>(super.customValidate(context));
        long minBytes = this.getMinBytes((PropertyContext)context);
        long maxBytes = this.getMaxBytes((PropertyContext)context);
        if (maxBytes < minBytes) {
            problems.add(new ValidationResult.Builder().subject(MIN_SIZE.getName()).input(context.getProperty(MIN_SIZE).getValue()).valid(false).explanation("Min Size must be less than or equal to Max Size").build());
        }
        if ((minEntries = this.getMinEntries((PropertyContext)context)) > (maxEntries = this.getMaxEntries((PropertyContext)context))) {
            problems.add(new ValidationResult.Builder().subject(MIN_ENTRIES.getName()).input(context.getProperty(MIN_ENTRIES).getValue()).valid(false).explanation("Min Entries must be less than or equal to Max Entries").build());
        }
        if ((otherProblems = this.additionalCustomValidation(context)) != null) {
            problems.addAll(otherProblems);
        }
        return problems;
    }

    private static class BinningResult {
        private final int flowFilesBinned;
        private final boolean newBinNeeded;
        public static BinningResult EMPTY = new BinningResult(0, false);

        public BinningResult(int flowFilesBinned, boolean newBinNeeded) {
            this.flowFilesBinned = flowFilesBinned;
            this.newBinNeeded = newBinNeeded;
        }

        public int getFlowFilesBinned() {
            return this.flowFilesBinned;
        }

        public boolean isNewBinNeeded() {
            return this.newBinNeeded;
        }
    }
}

