/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util.bin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.util.bin.Bin;
import org.apache.nifi.processor.util.bin.EvictionReason;
import org.apache.nifi.processor.util.bin.InsertionLocation;

public class BinManager {
    private final AtomicLong minSizeBytes = new AtomicLong(0L);
    private final AtomicLong maxSizeBytes = new AtomicLong(Long.MAX_VALUE);
    private final AtomicInteger minEntries = new AtomicInteger(0);
    private final AtomicInteger maxEntries = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicReference<String> fileCountAttribute = new AtomicReference<Object>(null);
    private volatile Predicate<FlowFile> binTerminationCheck = ff -> false;
    private volatile InsertionLocation insertionLocation = InsertionLocation.LAST_IN_BIN;
    private final AtomicInteger maxBinAgeSeconds = new AtomicInteger(Integer.MAX_VALUE);
    private final Map<String, List<Bin>> groupBinMap = new HashMap<String, List<Bin>>();
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock rLock = this.rwLock.readLock();
    private final Lock wLock = this.rwLock.writeLock();
    private int binCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        this.wLock.lock();
        try {
            for (List<Bin> binList : this.groupBinMap.values()) {
                for (Bin bin : binList) {
                    bin.getSession().rollback();
                }
            }
            this.groupBinMap.clear();
            this.binCount = 0;
        }
        finally {
            this.wLock.unlock();
        }
    }

    public void setFileCountAttribute(String fileCountAttribute) {
        this.fileCountAttribute.set(fileCountAttribute);
    }

    public String getFileCountAttribute() {
        return this.fileCountAttribute.get();
    }

    public void setMinimumEntries(int minimumEntries) {
        this.minEntries.set(minimumEntries);
    }

    public void setMaximumEntries(int maximumEntries) {
        this.maxEntries.set(maximumEntries);
    }

    public void setBinTermination(Predicate<FlowFile> binTerminationCheck, InsertionLocation insertionLocation) {
        this.binTerminationCheck = binTerminationCheck;
        this.insertionLocation = insertionLocation;
    }

    public int getBinCount() {
        this.rLock.lock();
        try {
            int n = this.binCount;
            return n;
        }
        finally {
            this.rLock.unlock();
        }
    }

    public void setMinimumSize(long numBytes) {
        this.minSizeBytes.set(numBytes);
    }

    public void setMaximumSize(long numBytes) {
        this.maxSizeBytes.set(numBytes);
    }

    public void setMaxBinAge(int seconds) {
        this.maxBinAgeSeconds.set(seconds);
    }

    public boolean offer(String groupIdentifier, FlowFile flowFile, ProcessSession session, ProcessSessionFactory sessionFactory) {
        Set<FlowFile> unbinned = this.offer(groupIdentifier, List.of(flowFile), session, sessionFactory);
        return unbinned.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<FlowFile> offer(String groupIdentifier, Collection<FlowFile> flowFiles, ProcessSession session, ProcessSessionFactory sessionFactory) {
        long currentMaxSizeBytes = this.maxSizeBytes.get();
        HashSet<FlowFile> unbinned = new HashSet<FlowFile>();
        this.wLock.lock();
        try {
            block3: for (FlowFile flowFile : flowFiles) {
                if (flowFile.getSize() > currentMaxSizeBytes) {
                    unbinned.add(flowFile);
                    continue;
                }
                boolean terminatesBin = this.binTerminationCheck != null && this.binTerminationCheck.test(flowFile);
                List currentBins = this.groupBinMap.computeIfAbsent(groupIdentifier, k -> new ArrayList());
                if (terminatesBin) {
                    if (this.insertionLocation == InsertionLocation.LAST_IN_BIN) {
                        for (Bin bin : currentBins) {
                            accepted = bin.offer(flowFile, session);
                            if (!accepted) continue;
                            bin.complete();
                            bin.setEvictionReason(EvictionReason.BIN_TERMINATION_SIGNAL);
                            continue block3;
                        }
                    } else if (!currentBins.isEmpty()) {
                        for (Bin bin : currentBins) {
                            if (bin.isForcefullyCompleted()) continue;
                            bin.complete();
                            bin.setEvictionReason(EvictionReason.BIN_TERMINATION_SIGNAL);
                            break;
                        }
                    }
                } else {
                    for (Bin bin : currentBins) {
                        accepted = bin.offer(flowFile, session);
                        if (!accepted) continue;
                        continue block3;
                    }
                }
                Bin bin = new Bin(sessionFactory.createSession(), this.minSizeBytes.get(), currentMaxSizeBytes, this.minEntries.get(), this.maxEntries.get(), this.fileCountAttribute.get());
                currentBins.add(bin);
                ++this.binCount;
                boolean added = bin.offer(flowFile, session);
                if (added) {
                    if (!terminatesBin || this.insertionLocation != InsertionLocation.ISOLATED && this.insertionLocation != InsertionLocation.LAST_IN_BIN) continue;
                    bin.complete();
                    bin.setEvictionReason(EvictionReason.BIN_TERMINATION_SIGNAL);
                    continue;
                }
                unbinned.add(flowFile);
            }
        }
        finally {
            this.wLock.unlock();
        }
        return unbinned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Bin> removeReadyBins(boolean relaxFullnessConstraint) {
        HashMap newGroupMap = new HashMap();
        ArrayList<Bin> readyBins = new ArrayList<Bin>();
        this.wLock.lock();
        try {
            for (Map.Entry<String, List<Bin>> group : this.groupBinMap.entrySet()) {
                ArrayList<Bin> remainingBins = new ArrayList<Bin>();
                for (Bin bin : group.getValue()) {
                    if (relaxFullnessConstraint && bin.isFullEnough()) {
                        bin.setEvictionReason(bin.determineEvictionReason());
                        readyBins.add(bin);
                        continue;
                    }
                    if (!relaxFullnessConstraint && bin.isFull()) {
                        bin.setEvictionReason(bin.determineEvictionReason());
                        readyBins.add(bin);
                        continue;
                    }
                    if (bin.isOlderThan(this.maxBinAgeSeconds.get(), TimeUnit.SECONDS)) {
                        bin.setEvictionReason(EvictionReason.TIMEOUT);
                        readyBins.add(bin);
                        continue;
                    }
                    remainingBins.add(bin);
                }
                if (remainingBins.isEmpty()) continue;
                newGroupMap.put(group.getKey(), remainingBins);
            }
            this.groupBinMap.clear();
            this.groupBinMap.putAll(newGroupMap);
            this.binCount -= readyBins.size();
        }
        finally {
            this.wLock.unlock();
        }
        return readyBins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bin removeOldestBin() {
        this.wLock.lock();
        try {
            Bin oldestBin = null;
            String oldestBinGroup = null;
            for (Map.Entry<String, List<Bin>> group : this.groupBinMap.entrySet()) {
                for (Bin bin : group.getValue()) {
                    if (oldestBin != null && !bin.isOlderThan(oldestBin)) continue;
                    oldestBin = bin;
                    oldestBinGroup = group.getKey();
                }
            }
            if (oldestBin == null) {
                Iterator<Map.Entry<String, List<Bin>>> iterator = null;
                return iterator;
            }
            --this.binCount;
            List<Bin> bins = this.groupBinMap.get(oldestBinGroup);
            bins.remove(oldestBin);
            if (bins.isEmpty()) {
                this.groupBinMap.remove(oldestBinGroup);
            }
            Bin bin = oldestBin;
            return bin;
        }
        finally {
            this.wLock.unlock();
        }
    }
}

